local S = minetest.get_translator("more_ladders")

minetest.register_node("more_ladders:ladder_aspen", {
	description = S("Aspen Ladder"),
	drawtype = "signlike",
	tiles = {"more_ladders_ladder_aspen.png"},
	inventory_image = "more_ladders_ladder_aspen.png",
	wield_image = "more_ladders_ladder_aspen.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	selection_box = {
		type = "wallmounted",
		--wall_top = = <default>
		--wall_bottom = = <default>
		--wall_side = = <default>
	},
	groups = {choppy = 2, oddly_breakable_by_hand = 3, flammable = 2},
	legacy_wallmounted = true,
	sounds = default.node_sound_wood_defaults(),
})

minetest.register_craft({
	output = "more_ladders:ladder_aspen 5",
	recipe = {
		{"more_ladders:aspen_stick", "", "more_ladders:aspen_stick"},
		{"more_ladders:aspen_stick", "more_ladders:aspen_stick", "more_ladders:aspen_stick"},
		{"more_ladders:aspen_stick", "", "more_ladders:aspen_stick"},
	}
})

minetest.register_craft({
	type = "fuel",
	recipe = "more_ladders:ladder_aspen",
	burntime = 7,
})

minetest.register_node("more_ladders:ladder_acacia", {
	description = S("Acacia Ladder"),
	drawtype = "signlike",
	tiles = {"more_ladders_ladder_acacia.png"},
	inventory_image = "more_ladders_ladder_acacia.png",
	wield_image = "more_ladders_ladder_acacia.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	selection_box = {
		type = "wallmounted",
		--wall_top = = <default>
		--wall_bottom = = <default>
		--wall_side = = <default>
	},
	groups = {choppy = 2, oddly_breakable_by_hand = 3, flammable = 2},
	legacy_wallmounted = true,
	sounds = default.node_sound_wood_defaults(),
})

minetest.register_craft({
	type = "fuel",
	recipe = "more_ladders:ladder_acacia",
	burntime = 7,
})

minetest.register_craft({
	output = "more_ladders:ladder_acacia 5",
	recipe = {
		{"more_ladders:acacia_stick", "", "more_ladders:acacia_stick"},
		{"more_ladders:acacia_stick", "more_ladders:acacia_stick", "more_ladders:acacia_stick"},
		{"more_ladders:acacia_stick", "", "more_ladders:acacia_stick"},
	}
})

minetest.register_node("more_ladders:ladder_jungle", {
	description = S("Jungle Wood Ladder"),
	drawtype = "signlike",
	tiles = {"more_ladders_ladder_junglewood.png"},
	inventory_image = "more_ladders_ladder_junglewood.png",
	wield_image = "more_ladders_ladder_junglewood.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	selection_box = {
		type = "wallmounted",
		--wall_top = = <default>
		--wall_bottom = = <default>
		--wall_side = = <default>
	},
	groups = {choppy = 2, oddly_breakable_by_hand = 3, flammable = 2},
	legacy_wallmounted = true,
	sounds = default.node_sound_wood_defaults(),
})

minetest.register_craft({
	type = "fuel",
	recipe = "more_ladders:ladder_jungle",
	burntime = 7,
})

minetest.register_craft({
	output = "more_ladders:ladder_jungle 5",
	recipe = {
		{"more_ladders:jungle_stick", "", "more_ladders:jungle_stick"},
		{"more_ladders:jungle_stick", "more_ladders:jungle_stick", "more_ladders:jungle_stick"},
		{"more_ladders:jungle_stick", "", "more_ladders:jungle_stick"},
	}
})

minetest.register_node("more_ladders:ladder_pine", {
	description = S("Pine Ladder"),
	drawtype = "signlike",
	tiles = {"more_ladders_ladder_pine.png"},
	inventory_image = "more_ladders_ladder_pine.png",
	wield_image = "more_ladders_ladder_pine.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	selection_box = {
		type = "wallmounted",
		--wall_top = = <default>
		--wall_bottom = = <default>
		--wall_side = = <default>
	},
	groups = {choppy = 2, oddly_breakable_by_hand = 3, flammable = 2},
	legacy_wallmounted = true,
	sounds = default.node_sound_wood_defaults(),
})

minetest.register_craft({
	type = "fuel",
	recipe = "more_ladders:ladder_pine",
	burntime = 7,
})

minetest.register_craft({
	output = "more_ladders:ladder_pine 5",
	recipe = {
		{"more_ladders:pine_stick", "", "more_ladders:pine_stick"},
		{"more_ladders:pine_stick", "more_ladders:pine_stick", "more_ladders:pine_stick"},
		{"more_ladders:pine_stick", "", "more_ladders:pine_stick"},
	}
})

minetest.register_node("more_ladders:ladder_diamond", {
	description = S("Diamond Ladder"),
	drawtype = "signlike",
	tiles = {"more_ladders_ladder_diamond.png"},
	inventory_image = "more_ladders_ladder_diamond.png",
	wield_image = "more_ladders_ladder_diamond.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	selection_box = {
		type = "wallmounted",
		--wall_top = = <default>
		--wall_bottom = = <default>
		--wall_side = = <default>
	},
	groups = {cracky = 1, oddly_breakable_by_hand = 3, level = 3},
	legacy_wallmounted = true,
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_craft({
	output = "more_ladders:ladder_diamond 15",
	recipe = {
		{"default:diamond", "", "default:diamond"},
		{"default:diamond", "default:diamond", "default:diamond"},
		{"default:diamond", "", "default:diamond"},
	}
})

minetest.register_node("more_ladders:ladder_bronze", {
	description = S("Bronze Ladder"),
	drawtype = "signlike",
	tiles = {"more_ladders_ladder_bronze.png"},
	inventory_image = "more_ladders_ladder_bronze.png",
	wield_image = "more_ladders_ladder_bronze.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	selection_box = {
		type = "wallmounted",
		--wall_top = = <default>
		--wall_bottom = = <default>
		--wall_side = = <default>
	},
	groups = {cracky = 1, oddly_breakable_by_hand = 3, level = 2},
	legacy_wallmounted = true,
	sounds = default.node_sound_metal_defaults(),
})

minetest.register_craft({
	output = "more_ladders:ladder_bronze 15",
	recipe = {
		{"default:bronze_ingot", "", "default:bronze_ingot"},
		{"default:bronze_ingot", "default:bronze_ingot", "default:bronze_ingot"},
		{"default:bronze_ingot", "", "default:bronze_ingot"},
	}
})

minetest.register_node("more_ladders:ladder_gold", {
	description = S("Golden Ladder"),
	drawtype = "signlike",
	tiles = {"more_ladders_ladder_gold.png"},
	inventory_image = "more_ladders_ladder_gold.png",
	wield_image = "more_ladders_ladder_gold.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	selection_box = {
		type = "wallmounted",
		--wall_top = = <default>
		--wall_bottom = = <default>
		--wall_side = = <default>
	},
	groups = {cracky = 1, oddly_breakable_by_hand = 3},
	legacy_wallmounted = true,
	sounds = default.node_sound_metal_defaults(),
})

minetest.register_craft({
	output = "more_ladders:ladder_gold 15",
	recipe = {
		{"default:gold_ingot", "", "default:gold_ingot"},
		{"default:gold_ingot", "default:gold_ingot", "default:gold_ingot"},
		{"default:gold_ingot", "", "default:gold_ingot"},
	}
})

minetest.register_node("more_ladders:ladder_tin", {
	description = S("Tin Ladder"),
	drawtype = "signlike",
	tiles = {"more_ladders_ladder_tin.png"},
	inventory_image = "more_ladders_ladder_tin.png",
	wield_image = "more_ladders_ladder_tin.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	selection_box = {
		type = "wallmounted",
		--wall_top = = <default>
		--wall_bottom = = <default>
		--wall_side = = <default>
	},
	groups = {cracky = 1, oddly_breakable_by_hand = 3, level = 2},
	legacy_wallmounted = true,
	sounds = default.node_sound_metal_defaults(),
})

minetest.register_craft({
	output = "more_ladders:ladder_tin 15",
	recipe = {
		{"default:tin_ingot", "", "default:tin_ingot"},
		{"default:tin_ingot", "default:tin_ingot", "default:tin_ingot"},
		{"default:tin_ingot", "", "default:tin_ingot"},
	}
})

minetest.register_node("more_ladders:ladder_copper", {
	description = S("Copper Ladder"),
	drawtype = "signlike",
	tiles = {"more_ladders_ladder_copper.png"},
	inventory_image = "more_ladders_ladder_copper.png",
	wield_image = "more_ladders_ladder_copper.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	selection_box = {
		type = "wallmounted",
		--wall_top = = <default>
		--wall_bottom = = <default>
		--wall_side = = <default>
	},
	groups = {cracky = 1, oddly_breakable_by_hand = 3, level = 2},
	legacy_wallmounted = true,
	sounds = default.node_sound_metal_defaults(),
})

minetest.register_craft({
	output = "more_ladders:ladder_copper 15",
	recipe = {
		{"default:copper_ingot", "", "default:copper_ingot"},
		{"default:copper_ingot", "default:copper_ingot", "default:copper_ingot"},
		{"default:copper_ingot", "", "default:copper_ingot"},
	}
})

minetest.register_node("more_ladders:ladder_mese", {
	description = S("Mese Ladder"),
	drawtype = "signlike",
	tiles = {"more_ladders_ladder_mese.png"},
	inventory_image = "more_ladders_ladder_mese.png",
	wield_image = "more_ladders_ladder_mese.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	selection_box = {
		type = "wallmounted",
		--wall_top = = <default>
		--wall_bottom = = <default>
		--wall_side = = <default>
	},
	groups = {cracky = 1, oddly_breakable_by_hand = 3, level = 2},
	legacy_wallmounted = true,
	sounds = default.node_sound_stone_defaults(),
	light_source = 3,
})

minetest.register_craft({
	output = "more_ladders:ladder_mese 15",
	recipe = {
		{"default:mese_crystal", "", "default:mese_crystal"},
		{"default:mese_crystal", "default:mese_crytal", "default:mese_crystal"},
		{"default:mese_crystal", "", "default:mese_crystal"},
	}
})

minetest.register_node("more_ladders:ladder_coal", {
	description = S("Coal Ladder"),
	drawtype = "signlike",
	tiles = {"more_ladders_ladder_coal.png"},
	inventory_image = "more_ladders_ladder_coal.png",
	wield_image = "more_ladders_ladder_coal.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	selection_box = {
		type = "wallmounted",
		--wall_top = = <default>
		--wall_bottom = = <default>
		--wall_side = = <default>
	},
	groups = {cracky = 1, oddly_breakable_by_hand = 3, level = 2},
	legacy_wallmounted = true,
	sounds = default.node_sound_stone_defaults(),
	light_source = 3,
})

minetest.register_craft({
	output = "more_ladders:ladder_coal 15",
	recipe = {
		{"default:coal_lump", "", "default:coal_lump"},
		{"default:coal_lump", "default:coal_lump", "default:coal_lump"},
		{"default:coal_lump", "", "default:coal_lump"},
	}
})

minetest.register_craft({
	type = "fuel",
	recipe = "more_ladders:ladder_coal",
	burntime = 160,
})