local S = minetest.get_translator("more_ladders")
local unifieddyes_modpath = minetest.get_modpath("unifieddyes")

if unifieddyes_modpath then
	minetest.register_node("more_ladders:colored_ladder", {
		description = S("Colored Ladder"),
		drawtype = "signlike",
		inventory_image = "more_ladders_example.png",
		wield_image = "more_ladders_example.png",
		paramtype = "light",
		paramtype2 = "color",
		tiles = {
			"more_ladders_example.png"
		},
		sunlight_propagates = true,
		walkable = false,
		climbable = true,
		is_ground_content = false,
		selection_box = {
			type = "wallmounted",
			--wall_top = = <default>
			--wall_bottom = = <default>
			--wall_side = = <default>
		},
		groups = {choppy = 2, oddly_breakable_by_hand = 3, flammable = 2, ud_param2_colorable = 1},
		legacy_wallmounted = true,
		palette = "unifieddyes_palette_extended.png",
		sounds = default.node_sound_stone_defaults(),
		on_construct = unifieddyes.on_construct,
		on_dig = unifieddyes.on_dig,
	})
end
