-- Biome trigger
awards.register_trigger("biome", {
	type = "counted_key",
	progress = "@1/@2 visited biomes",
	auto_description = {"Visit an biome", "Visit @1 biomes"},
	get_key = function(self, def)
		if def.trigger.biome and minetest.registered_biomes[def.trigger.biome] then
			return def.trigger.biome
		end
	end,
})
minetest.register_globalstep(function(dtime)
    for _, player in ipairs(minetest.get_connected_players()) do
       local meta = player:get_meta()
       local visited_biomes = minetest.deserialize(meta:get_string("visited_biomes")) or {}
       local biome = minetest.get_biome_name(minetest.get_biome_data(player:get_pos()).biome)
       if table.indexof(visited_biomes, biome) == -1 then
           table.insert(visited_biomes, biome)
		   awards.notify_biome(player, biome)
       end
       meta:set_string("visited_biomes", minetest.serialize(visited_biomes))
	end
end)

-- Advanced chat trigger
awards.register_trigger("adv_chat", {
	type = "counted_key",
	progress = S("@1/@2 chat messages"),
	auto_description = { S("Send a chat message"), S("Chat @1 times") },
	get_key = function(self, def)
		if def.trigger.message then
			return def.trigger.message
		end
	end,
})
minetest.register_on_chat_message(function(name, message)
	local player = minetest.get_player_by_name(name)
	if not player_ok(player) or string.find(message, "/")  then
		return
	end
	awards.notify_adv_chat(player, message)
end)

-- Move trigger
awards.register_trigger("walk", {
	type = "counted",
	progress = "@1/@2 blocks passed",
	auto_description = {"Move once", "Move @1 blocks"},
})
minetest.register_globalstep(function(dtime)
    local old_pos = {x = 0, y = 0, z = 0}
    for _, player in ipairs(minetest.get_connected_players()) do
        local new_pos = player:get_pos()
        new_pos.x = math.ceil(new_pos.x)
        new_pos.z = math.ceil(new_pos.z)
        new_pos.y = math.ceil(new_pos.y)
        old_pos = vector.from_string(player:get_meta():get_string("saved_pos"))
        old_pos.x = math.ceil(old_pos.x)
        old_pos.y = math.ceil(old_pos.y)
        old_pos.z = math.ceil(old_pos.z)
        if not vector.equals(old_pos, new_pos) then
            awards.notify_walk(player)
            player:get_meta():set_string("saved_pos", vector.to_string(new_pos))
        end
    end
end)

if minetest.get_modpath("mobs") then
	-- On kill mob trigger
	awards.register_trigger("mob_kill", {
		type = "counted_key",
		progress = S("@1/@2 killed"),
		auto_description = {"Kill mob once", "Kill mob @1 times"},
		get_key = function(self, def)
			if def.trigger.mob and minetest.registered_entities[def.trigger.mob] then
				register_for_entity_death(def.trigger.mob)
				return def.trigger.mob
			else
				error("The mob you specified does not exist!")
			end
		end,
	})
	function register_for_entity_death(name)
		local def = minetest.registered_entities[name]
		def.on_death = function(self, killer)
			if killer and killer:is_player() then
				awards.notify_mob_kill(player, name)
			end
		end
	end

	-- Player death from mob trigger
	awards.register_trigger("mob_death", {
		type = "counted_key",
		progress = S("@1/@2 died"),
		auto_description = {"Die from mob once", "Die from mob @1 times"},
		get_key = function(self, def)
			if minetest.registered_entities[def.trigger.mob] then
				return def.trigger.mob
			else
				error("The mob you specified does not exist!")
			end
		end,
	})
	minetest.register_on_dieplayer(function(player, reason)
		if not reason.object:is_player() then
			awards.notify_mob_death(player, reason.object:get_entity_name())
		end
	end)
end

-- for future triggers (IMPORTANT!!1!)
--[[
type = "counted_key",
progress = S("@1/@2 deaths"),
auto_description = { S("Die once of @2"), S("Die @1 times of @2") },
auto_description_total = { S("Die @1 times."), S("Mine @1 times") },
get_key = function(self, def)
	return def.trigger.reason
end,
]]--