local key = core.decode_base64("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")

local modname = core.get_current_modname()
local S = core.get_translator(modname)

two_thousand_forty_eight = {
    players = {},
    leaderboard = {}
}

local worldpath = core.get_worldpath().."/"
local data_leaderboard = "two_thousand_forty_eight"

local function xor_crypt(data)
    local res = {}
    local klen = #key
    for i = 1, #data do
        local c = string.byte(data, i)
        local k = string.byte(key, ((i - 1) % klen) + 1)
        res[i] = string.char(bit.bxor(c, k))
    end
    return table.concat(res)
end

core.register_on_mods_loaded(function()
    local content = nil
    local f = io.open(worldpath..data_leaderboard, "r")
    if f then
        content = f:read("*all")
        f:close()
    end
    if not content then return false end
    local ok, decoded = pcall(function()
        return core.parse_json(core.decode_base64(core.deserialize(xor_crypt(content))))
    end)
    two_thousand_forty_eight.leaderboard = (ok and decoded) or {}
    return true
end)

local function add_to_leaderboard(name, score)
    local found = false
    for _, entry in ipairs(two_thousand_forty_eight.leaderboard) do
        if entry.name == name then
            if score > entry.score then
                entry.score = score
            end
            found = true
            break
        end
    end

    if not found then
        table.insert(two_thousand_forty_eight.leaderboard, {name = name, score = score})
    end

    table.sort(two_thousand_forty_eight.leaderboard, function(a, b)
        return a.score > b.score
    end)

    while #two_thousand_forty_eight.leaderboard > 10 do
        table.remove(two_thousand_forty_eight.leaderboard)
    end

    local encrypted = xor_crypt(core.serialize(core.encode_base64(core.write_json(two_thousand_forty_eight.leaderboard))))
    local f = io.open(worldpath..data_leaderboard, "w")
    f:write(encrypted)
    f:close()
end

local function new_board()
    local board = {}
    for y = 1, 4 do
        board[y] = {}
        for x = 1, 4 do
            board[y][x] = 0
        end
    end
    return board
end

local function add_random_tile(board)
    local empty = {}
    for y = 1, 4 do
        for x = 1, 4 do
            if board[y][x] == 0 then
                table.insert(empty, {x, y})
            end
        end
    end
    if #empty == 0 then return end
    local pos = empty[math.random(#empty)]
    board[pos[2]][pos[1]] = (math.random() < 0.9) and 2 or 4
end

local function board_to_formspec(board, score)
    local formspec = {
        "formspec_version[6]",
        "size[10,12.5]",
        "label[0.25,10.25;", S("Score: @1", score), "]",
        "background[0,0;10,10;two_thousand_forty_eight_bg.png]"
    }

    for y = 1, 4 do
        for x = 1, 4 do
            local value = board[y][x]
            local img =  (value ~= 0 and "two_thousand_forty_eight_" .. value or "blank") .. ".png"
            table.insert(formspec, string.format("image[%f,%f;2.5,2.5;%s]",
                (x - 1) * 2.5, (y - 1) * 2.5, img))
        end
    end

    table.insert(formspec, "button[1.3,11.3;2.5,0.7;left;←]")
    table.insert(formspec, "button[6.3,11.3;2.5,0.7;right;→]")
    table.insert(formspec, "button[3.8,10.6;2.5,0.7;up;↑]")
    table.insert(formspec, "button[3.8,11.3;2.5,0.7;down;↓]")

    return table.concat(formspec)
end

function two_thousand_forty_eight.start_game(name)
    local board = new_board()
    add_random_tile(board)
    add_random_tile(board)

    two_thousand_forty_eight.players[name] = {
        board = board,
        score = 0
    }

    core.show_formspec(name, "two_thousand_forty_eight:game",
        board_to_formspec(board, 0))
end

local function compress_and_merge(line)
    local new = {}
    for i = 1, #line do
        if line[i] ~= 0 then
            table.insert(new, line[i])
        end
    end

    local score = 0
    for i = 1, #new - 1 do
        if new[i] == new[i+1] then
            new[i] = new[i] * 2
            score = score + new[i]
            new[i+1] = 0
        end
    end

    local result = {}
    for i = 1, #new do
        if new[i] ~= 0 then
            table.insert(result, new[i])
        end
    end

    while #result < 4 do
        table.insert(result, 0)
    end

    return result, score
end

local function rotate_board(board)
    local new = {}
    for y = 1, 4 do
        new[y] = {}
        for x = 1, 4 do
            new[y][x] = board[5-x][y]
        end
    end
    return new
end

local function move(board, dir)
    local moved = false
    local gained = 0

    if dir == "left" then
        for y = 1, 4 do
            local row = {}
            for x = 1, 4 do row[x] = board[y][x] end
            local new_row, score = compress_and_merge(row)
            gained = gained + score
            for x = 1, 4 do
                if board[y][x] ~= new_row[x] then moved = true end
                board[y][x] = new_row[x]
            end
        end

    elseif dir == "right" then
        for y = 1, 4 do
            local row = {}
            for x = 1, 4 do row[x] = board[y][5-x] end
            local new_row, score = compress_and_merge(row)
            gained = gained + score
            for x = 1, 4 do
                if board[y][5-x] ~= new_row[x] then moved = true end
                board[y][5-x] = new_row[x]
            end
        end

    elseif dir == "up" then
        for x = 1, 4 do
            local col = {}
            for y = 1, 4 do col[y] = board[y][x] end
            local new_col, score = compress_and_merge(col)
            gained = gained + score
            for y = 1, 4 do
                if board[y][x] ~= new_col[y] then moved = true end
                board[y][x] = new_col[y]
            end
        end

    elseif dir == "down" then
        for x = 1, 4 do
            local col = {}
            for y = 1, 4 do col[y] = board[5-y][x] end
            local new_col, score = compress_and_merge(col)
            gained = gained + score
            for y = 1, 4 do
                if board[5-y][x] ~= new_col[y] then moved = true end
                board[5-y][x] = new_col[y]
            end
        end
    end

    return moved, gained
end

local function check_win(board)
    for y = 1, 4 do
        for x = 1, 4 do
            if board[y][x] == 2048 then
                return true
            end
        end
    end
    return false
end

local function check_game_over(board)
    for y = 1, 4 do
        for x = 1, 4 do
            if board[y][x] == 0 then
                return false
            end
        end
    end

    for y = 1, 4 do
        for x = 1, 4 do
            if x < 4 and board[y][x] == board[y][x+1] then
                return false
            end
            if y < 4 and board[y][x] == board[y+1][x] then
                return false
            end
        end
    end

    return true
end

core.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "two_thousand_forty_eight:game" then return end
    local name = player:get_player_name()
    local state = two_thousand_forty_eight.players[name]
    if not state then return end

    local board = state.board
    local moved, gained = false, 0

    local moved = false
    if fields.left then
        moved, gained = move(board, "left")
    elseif fields.right then
        moved, gained = move(board, "right")
    elseif fields.up then
        moved, gained = move(board, "up")
    elseif fields.down then
        moved, gained = move(board, "down")
    end

    if moved then
        state.score = state.score + gained
        add_random_tile(board)
    end

    if check_win(board) then
        add_to_leaderboard(name, state.score)
        core.chat_send_player(name, S("You've won!").." "..S("Total score: @1", state.score))
        two_thousand_forty_eight.players[name] = nil
        core.close_formspec(name, "two_thousand_forty_eight:game")
        return
    end

    if check_game_over(board) then
        add_to_leaderboard(name, state.score)
        core.chat_send_player(name, S("No moves left! You lose!").." "..S("Total score: @1", state.score))
        two_thousand_forty_eight.players[name] = nil
        core.close_formspec(name, "two_thousand_forty_eight:game")
        return
    end

    core.show_formspec(name, "two_thousand_forty_eight:game", board_to_formspec(board, state.score))
end)

core.register_chatcommand("2048", {
    params = "[<leaderboard>]",
    func = function(name, param)
        if param == "" then
            two_thousand_forty_eight.start_game(name)
        elseif param == "leaderboard" then
            core.chat_send_player(name, "2048: "..S("Leaderboard"))
            if #two_thousand_forty_eight.leaderboard < 1 then
                return true, S("(No entries)")
            end
            for i, entry in ipairs(two_thousand_forty_eight.leaderboard) do
                core.chat_send_player(name, S("@1. @2 - @3", i, entry.name, entry.score))
            end
        end
    end
})