local modname = core.get_current_modname()
local S = core.get_translator(modname)

wallblock = {
    tool_menu = "wallblock:walltool_menu",
}

local function wall_set(pname, pos, fields, name, is_tool_used)
    local x = tonumber(fields.x) or pos.x
    local y = tonumber(fields.y) or pos.y
    if not is_tool_used then
        y = y + 1
    end
    local z = tonumber(fields.z) or pos.z
    local width = tonumber(fields["x+"]) or 1
    local height = tonumber(fields["y+"]) or 1
    local depth = tonumber(fields["z+"]) or 1
    local x2 = x + width
    local y2 = y + height
    local z2 = z + depth

    local pos1 = {x = x, y = y, z = z}
    local pos2 = {x = x2, y = y2, z = z2}
    local size = {x = width, y = height, z = depth}

    if (size.x > 96) or (size.y > 96) or (size.z > 96) then
        core.chat_send_player(pname, S("Too big area to set! Maximum is 96x96x96."))
        return nil
    end

    local count = worldedit.set(pos1, pos2, name)
    core.chat_send_player(pname, S("Successfully set @1 node(-s)", count))

    return pos1, pos2, size
end

function wallblock.get_item_formspec(pos, name)
    local formspec = {
        "formspec_version[6]",
        "size[10.5,6.9]",
        "button[0.4,5.1;9.7,1.5;done;Set]",
        "field[0.4,0.7;3,1;node;Node name;", name, "]",
        "field[0.4,2.3;3,1;x;X pos;", pos.x, "]",
        "field[3.7,2.3;3.1,1;y;Y pos;", pos.y, "]",
        "field[7.1,2.3;3,1;z;Z pos;", pos.z, "]",
        "field[7.1,3.9;3,1;z+;Depth;", 0, "]",
        "field[3.7,3.9;3.1,1;y+;Height;", 0, "]",
        "field[0.4,3.9;3,1;x+;Width;", 0, "]",
    }
    return table.concat(formspec, "")
end

function wallblock.show_tool_menu(pname, pos, name)
	local formspec = wallblock.get_item_formspec(pos, name)

	minetest.show_formspec(pname, wallblock.tool_menu, formspec)
end

minetest.register_on_player_receive_fields(function(player, formname, fields)
	if formname ~= wallblock.tool_menu then
		return
	end
    local pname = player:get_player_name()
    if fields.done then
        if not core.registered_nodes[fields.node] then core.chat_send_player(pname, S("Wrong node name!")) return end
        local thingy = wall_set(pname, pos, fields, fields.node)
        if not thingy then return end
        minetest.close_formspec(pname, formname, fields)
    end
	return
end)

function wallblock.get_formspec(pos)
    local meta = core.get_meta(pos)
    local inv = meta:get_inventory()
    local width = meta:get_int("width")
    local height = meta:get_int("height")
    local depth = meta:get_int("depth")
    local size = {x = width, y = height, z = depth}
    local node = inv:get_stack("main", 1):get_name()

    local formspec = {
        "formspec_version[6]",
        "size[10.5,12]",
        "label[6,1.3;", core.formspec_escape(node), "]",
        "list[nodemeta:", pos.x, ",", pos.y, ",", pos.z, ";main;4.7,0.8;1,1;0]",
        "field[0.4,2.3;3,1;x;X pos;", pos.x, "]",
        "field[3.7,2.3;3.1,1;y;Y pos;", pos.y, "]",
        "field[7.1,2.3;3,1;z;Z pos;", pos.z, "]",
        "field[0.4,3.9;3,1;x+;Width;", size.x, "]",
        "field[3.7,3.9;3.1,1;y+;Height;", size.y, "]",
        "field[7.1,3.9;3,1;z+;Depth;", size.z, "]",
        "button[0.4,5.1;9.7,1.5;done;Set]",
        "list[current_player;main;0.4,6.9;8,4;0]",
    }
    return table.concat(formspec, "")
end

local function update_formspec(pos)
    local meta = core.get_meta(pos)
    meta:set_string("formspec", wallblock.get_formspec(pos))
end

core.register_alias('wallblock:wallblock', 'wallblock')
core.register_alias('wallblock:wallblock', 'worldedit:wallblock')
core.register_alias('wallblock:wallblock', 'worldedit:wall')
core.register_alias('wallblock:wallblock', 'wallblock:block')

core.register_node("wallblock:wallblock", {
    description = S("WorldEdit Wall Block"),
    tiles = {"worldedit_wallblock_wallblock.png"},
    paramtype = "light",
    sunlight_propagates = true,
    is_ground_content = false,
    groups = {cracky = 1, oddly_breakable_by_hand = 3},
    sounds = default.node_sound_glass_defaults(),
    drop = "",
    on_construct = function(pos)
        local meta = core.get_meta(pos)
        update_formspec(pos)

        local inv = meta:get_inventory()
        inv:set_size("main", 8*4)
		inv:set_width("main", 8)
    end,
    on_destruct = function(pos)
		local meta = core.get_meta(pos)
        local inv = meta:get_inventory()
	    local stack = inv:get_stack("main", 1)
		if not stack:is_empty() then
			core.add_item(pos, stack:get_name())
		end
	end,
    on_receive_fields = function(pos, formname, fields, player)
        local pname = player:get_player_name()
        local meta = core.get_meta(pos)
        local inv = meta:get_inventory()
        if fields.done then
            local name = inv:get_stack("main", 1):get_name()
            if name == "" then name = "air" end
            local pos1, pos2, size = wall_set(pname, pos, fields, name)

            meta:set_int("width", size.x)
            meta:set_int("height", size.y)
            meta:set_int("depth", size.z)

            update_formspec(pos)
        end
    end,
    on_metadata_inventory_put = function(pos, list_name, index, stack, player)
        update_formspec(pos)
    end,
    on_metadata_inventory_take = function(pos, list_name, index, stack, player)
        update_formspec(pos)
    end,
    allow_metadata_inventory_put = function(pos, listname, index, stack, player)
        if core.registered_nodes[stack:get_name()] then
            return 1
        else
            return 0
        end
    end,
})

core.register_alias('wallblock:walltool', 'walltool')
core.register_alias('wallblock:walltool', 'worldedit:walltool')
core.register_alias('wallblock:walltool', 'worldedit:wall')
core.register_alias('wallblock:walltool', 'worldedit:tool')
core.register_alias('wallblock:walltool', 'wallblock:tool')

core.register_craftitem("wallblock:walltool", {
	description = S("WorldEdit Wall Tool"),
	inventory_image = "worldedit_wallblock_walltool.png",
	on_use = function(_, player, pointed_thing)
        if not (pointed_thing.type == "node") then return end
        local pname = player:get_player_name()
		local pos = core.get_pointed_thing_position(pointed_thing)
        local node = core.get_node(pos)
        local name = node.name
        wallblock.show_tool_menu(pname, pos, name)
	end,
})