# Add actual NPC to `yl_speak_up`

Autor: Sokomine

License: GPLv3.0 or later

Requires: <a href="https://gitea.your-land.de/Sokomine/yl_speak_up">yl_speak_up</a>

Recommends:
* <a href="https://content.minetest.net/packages/TenPlus1/mobs/">mobs_redo</a>
* <a href="https://content.minetest.net/packages/TenPlus1/mobs_npc/">mobs_npc</a>
* <a href="https://content.minetest.net/packages/TenPlus1/mobs_animal/">mobs_animal</a>
* <a href="https://content.minetest.net/packages/bell07/skinsdb/">skinsdb</a>

Remember that you need the `npc_talk_owner` priv in order to configure your NPC!

This mod adds actual NPC to the game. They can be talked to on rightclick.

## Table of Content

1. [Basic talking NPC (no other mods required)](#talking_npc)
2. [Talking to blocks (no other mods required)](#talk_sign)
3. [Example NPC (requires mobs\_redo)](#mobs_redo)
4. [Talk to existing NPC (requires mobs\_npc)](#mobs_npc)
5. [Talk to animals (requires mobs\_animal)](#mobs_animal)
6. [More information](#misc)


### 1. Basic talking NPC (no other mods required)<a name="talking_npc"></a>

This basic NPC is available even if you install no other mods.

The model - `character.b3d` - is part of `minetest_game`. You can either get it from there
(you will likely have it already) or change the entry in `talking_npc.lua` to the model
your game uses. You will also need a texture called `character.png`.

There is no spawning implemented. Type `/giveme npc_talk:talking_npc` to get one.

Features:
* These NPC can be talked to on right-click.
* They look at the player when right-clicked.
* They can be picked up through a menu entry in their talk menu.
* The picked up NPC can be placed again. 
* Add more textures to the table `yl_speak_up.mob_skins["npc_talk:talking_npc"]` in order to have more diffrent textures.


### 2. Talking to blocks (no other mods required)<a name="talk_sign"></a>

With a mese block and a wooden sign, you can craft a special sign which you can place
and that will act like an NPC.

This feature is highly experimental.

The position of the sign acts as ID.



### 3. Example NPC (requires mobs\_redo)<a name="mobs_redo"></a>

This is very close to the NPC used on the Your Land server. They're basicly
`mobs_redo` based NPC. You also need to install the `skinsdb` mod so that
a mesh and textures are available. Technicly, `skinsdb` isn't really
necessary - but a mesh and textures are. They have to come from *somewhere*.

There is no spawning implemented. Type `/giveme npc_talk:npc` to get one.

Features:
* These NPC can be talked to on right-click.
* They turn around randomly (`mobs_redo` handles that).
* They can be picked up with a lasso.
* The picked up NPC show up as eggs in your inventory and can be placed again. 
* You can add more textures by creating a folder named `textures` in the folder of this mod and adding skins (MineCraft compatible) to that folder. The filenames have to start with `npc_talk_main_`. Capes are also supported.


### 4. Talk to existing NPC (requires mobs\_npc)<a name="mobs_npc"></a>

These mobs come from a mod that already adds some NPC. They spawn in the world,
can be tamed with bread, and you can even breed them. Said mod is called
`mobs_npc`.

Just right-click them to talk to and use all other features as you're used to
from that mod.


### 5. Talk to animals (requires mobs\_animal)<a name="mobs_animal"></a>

This is more for fun. You can craft a special _talk tool_ by combining a lasso and
shears together. Punch animals (only white sheep, red sheep and cows are supported)
with that tool in order to be able to _talk_ to them.

So far, neither the sheep nor the cows had much to tell me. But perhaps you'll
be more lucky!

The reason why you need the _talk tool_ here and can't just right-click them
is because these mobs have special functions on rightclick (feeding etc.) and
no interface to add new functionality there. This method - using such a tool -
shows how you can deal with such situations. You might of course also edit
the sheeps and cows and/or talk to TenPlus1 to get that integrated. But animals
seldom have much to say, so it's probably not of much interest to most players.


### 6. More information<a name="misc"></a>

As you can see, this mod is mostly a demonstration of what you can do. Plus it
does provide some usable NPC. Please select what you like and customize them!

NPC really love talking.

If you have questions, feel free to contact me on the forum or on IRC.

Sokomine
