
npc_talk.enable_talk_to_animals = function()

	-- the following information is needed in order to handle skin changes
	yl_speak_up.mesh_data["mobs_sheep.b3d"] = {
		texture_index = 1,
		animation = {
			-- {x = start_frame, y = end_frame, collisionbox}
			stand_still = {x =   0, y =   0},
			stand       = {x =   0, y =  79},
			walk        = {x =  81, y = 100},
	        },
	}
	yl_speak_up.mesh_data["mobs_cow.b3d"] = {
		texture_index = 1,
		animation = {
			-- {x = start_frame, y = end_frame, collisionbox}
			stand_still = {x =   0, y =   0},
			stand       = {x =   0, y =  30},
			stand1      = {x =  35, y =  75},
			walk        = {x =  85, y = 114},
			run         = {x = 120, y = 140},
			punch       = {x = 145, y = 160},
			die         = {x = 165, y = 185},
	        },
	}

	yl_speak_up.mob_skins["mobs_animal:sheep_white"] = {
		"mobs_sheep_base.png^(mobs_sheep_wool.png^[multiply:#ffffffc0)"}
	yl_speak_up.mob_skins["mobs_animal:sheep_red"] = {
		"mobs_sheep_base.png^(mobs_sheep_wool.png^[multiply:#ff0000a0)"}
	yl_speak_up.mob_skins["mobs_animal:cow"] = {
		"mobs_cow.png", "mobs_cow2.png"}

	table.insert(yl_speak_up.emulate_orders_on_rightclick, "mobs_animal:sheep_white")
	table.insert(yl_speak_up.emulate_orders_on_rightclick, "mobs_animal:sheep_red")
	table.insert(yl_speak_up.emulate_orders_on_rightclick, "mobs_animal:cow")
end


if(minetest.get_modpath("mobs_animal")) then
	-- make sure it gets called once now and in the future whenever yl_speak_up is reloaded
	-- (via /npc_talk_reload)
	yl_speak_up.register_on_reload(npc_talk.enable_talk_to_animals, "npc_talk.enable_talk_to_animals()")

	-- The aniamals have too many functions in on_rightclick - they would need new code
	-- for talking to them in on_rightclick.
	-- As a workaround, you need to wield this tool and punch or right-click them with it.
	minetest.register_craftitem("npc_talk:talk_tool", {
		description = "Punch a suitable animal (white or red sheep, cow) with this tool to talk to it",
		inventory_image = "mobs_magic_lasso.png^mobs_shears.png",
		groups = {book = 1}, 
		on_use = npc_talk.talk_tool, 
		on_place = npc_talk.talk_tool,
	})

	-- add a suitable craft receipe
	minetest.register_craft({
		output = "npc_talk:talk_tool",
		recipe = {
			{"mobs:shears"},
			{"mobs:lasso"},
		},
	})      
end
