
minetest.register_node("npc_talk:talk_sign", {
	description = "Place this sign and then right-click it to start talk interface.",
	drawtype = "nodebox",
	tiles = {"default_mese_block.png"},
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	is_ground_content = false,
	walkable = false,
	use_texture_alpha = "opaque",
	node_box = {
		type = "wallmounted",
		wall_top    = {-0.4375, 0.4375, -0.3125, 0.4375, 0.5, 0.3125},
		wall_bottom = {-0.4375, -0.5, -0.3125, 0.4375, -0.4375, 0.3125},
		wall_side   = {-0.5, -0.3125, -0.4375, -0.4375, 0.3125, 0.4375},
	},
	groups = {choppy = 2, oddly_breakable_by_hand = 3},
	legacy_wallmounted = true,
	on_construct = function(pos)
		local meta = minetest.get_meta(pos)
		meta:set_string("infotext", "Right-click me to start talk interface.")
		meta:set_string("talk_name", "Sign")
	end,
	after_place_node = function(pos, placer)
		local meta = minetest.get_meta(pos)
		meta:set_string("owner", placer:get_player_name() or "")
		meta:set_string("infotext", "Right-click me to start talk interface! My owner is "..tostring(meta:get_string("owner")))
	end,
	on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
		if(minetest.global_exists("yl_speak_up") and yl_speak_up.talk) then
			local meta = minetest.get_meta(pos)
			yl_speak_up.talk({is_block = true, pos = pos, owner = meta:get_string("owner")}, clicker)
		end
		return itemstack
	end,
})


minetest.register_craft({
        output = "npc_talk:talk_sign",
        recipe = {
                {"default:mese"},
                {"default:sign_wall_wood"},
        },
})      

