
-- Dynamicly read textures at start of mod
-- Create a folder textures/ inside this mod to use this function.
-- Add skins in files named   textures/npc_talk_main_SKIN_NAME.png

local function read_skins_and_capes_from_folders()
    local temp = {}

    -- get the files out of modpath
    local mp_list = minetest.get_dir_list(minetest.get_modpath("npc_talk") .. DIR_DELIM .. "textures", false)
    -- accessing the worlddir seems sometimes problematic
    if(true) then
	    return mp_list
    end

    -- get the files out of worlddir
    local wp_list =
        minetest.get_dir_list(
        yl_speak_up.worldpath .. DIR_DELIM .. "worldmods" .. DIR_DELIM .. "npc_talk" .. DIR_DELIM .. "textures",
        false
    )

    -- Let's join both lists.
    table.insert_all(temp, mp_list)
    table.insert_all(temp, wp_list)

    return temp
end


-- taken from yl_speak_up from yl
local function add_skins_and_capes(temp, races, modname)
    --[[ Let's see if the files are the ones we want. Format is
    npc_talk_main_name.png <-- Those are the ones we want
    npc_talk_cape_name.png
    npc_talk_item_name.png
    ]]--

    for _, race in ipairs(races) do
       if(not(yl_speak_up.mob_skins[modname..race])) then
           yl_speak_up.mob_skins[modname..race] = {}
       end
       if(not(yl_speak_up.mob_capes[modname..race])) then
           yl_speak_up.mob_capes[modname..race] = {}
       end
    end

    for _, v in pairs(temp) do
        local s = string.split(v, "_")
        if s[1] == "npc" and s[2] == "talk" and s[3] == "main" then
	    for i, race in ipairs(races) do
                table.insert(yl_speak_up.mob_skins[modname..race], v)
	    end
        end
        if s[1] == "npc" and s[2] == "talk" and s[3] == "cape" then
	    for i, race in ipairs(races) do
                table.insert(yl_speak_up.mob_capes[modname..race], v)
	    end
        end
    end

    for _, race in ipairs(races) do
       if(#yl_speak_up.mob_skins[modname..race] < 1) then
           yl_speak_up.mob_skins[modname..race] = {"character.png"}
       end
       if(#yl_speak_up.mob_capes[modname..race] < 1) then
           yl_speak_up.mob_capes[modname..race] = {"npc_talk_cape_default.png"}
       end
    end
end


npc_talk.add_skins_from_skinsdb = function(mob_name_string)
	if(not(yl_speak_up.mob_skins[mob_name_string])
	  or(#yl_speak_up.mob_skins[mob_name_string] < 1)) then
		yl_speak_up.mob_skins[mob_name_string] = {"character.png"}
	end
	-- read skins from skinsdb
	if(not(minetest.get_modpath("skinsdb"))) then
		return
	end
	local list = skins.get_skinlist_for_player()
	for _, skin in ipairs(list) do
		-- avoid duplicate entries
		if(table.indexof(yl_speak_up.mob_skins[mob_name_string], skin:get_texture()) == -1) then
			table.insert(yl_speak_up.mob_skins[mob_name_string], skin:get_texture())
		end
	end
	minetest.log("action","[MOD] npc_talk uses "..tostring(#list).." skins from skinsdb ")
end


-- called at startup and on reload of yl_speak_up
npc_talk.add_textures = function()
	-- do all the things that have to be done when yl_speak_up is initialized or reloaded
	add_skins_and_capes(npc_talk.file_list, {"npc"}, "npc_talk:")
	minetest.log("action","[MOD] npc_talk loaded textures for yl_speak_up")
	npc_talk.add_skins_from_skinsdb("npc_talk:npc")
end

-- this has to be called *once* when the file is initialized
npc_talk.file_list = read_skins_and_capes_from_folders()

-- make sure it gets called once now and in the future whenever yl_speak_up is reloaded
-- (via /npc_talk_reload)
yl_speak_up.register_on_reload(npc_talk.add_textures, "npc_talk.add_textures()")
