
npc_talk.register_example_npc = function()
	local mesh = npc_talk.talking_npc_mesh
	local textures = {npc_talk.talking_npc_texture}
	if(minetest.get_modpath("skinsdb")) then
		mesh = "skinsdb_3d_armor_character_5.b3d"
		-- this mesh has a diffrent texture setup as well
		textures = {{
			"blank.png", -- cape?
			"npc_talk_default_skin.png", -- 64x64 skin
			"3d_armor_trans.png", -- shield?!
			"3d_armor_trans.png", -- item right hand
		}}
	end
	-- register the new mob
	mobs:register_mob("npc_talk:npc", {
		type = "npc",
		passive = true,
		damage = 9,
		attack_type = "dogfight",
		attacks_monsters = true,
		attack_npcs = false,
		owner_loyal = false,
		pathfinding = false,
		hp_min = 100,
		hp_max = 100,
		armor = 0,
		collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
		visual = "mesh",
		visual_size = {x = 1, y = 1},
		mesh = mesh,
		drawtype = "front",
		textures = textures,
		makes_footstep_sound = true,
		sounds = {},
		walk_velocity = 2,
		run_velocity = 3,
		jump = false,
		water_damage = 0,
		lava_damage = 0,
		light_damage = 0,
		node_damage = 0,
		suffocation = 0,
		view_range = 4,
		owner = "Server",
		order = "stand",
		fear_height = 3,
		animation = {
			speed_normal = 30,
			speed_run = 30,
			stand_start = 0,
			stand_end = 79,
			walk_start = 168,
			walk_end = 187,
			run_start = 168,
			run_end = 187,
			punch_start = 200,
			punch_end = 219,
		},

		on_rightclick = yl_speak_up.mobs_on_rightclick,
		after_activate = yl_speak_up.mobs_after_activate
	})

	mobs:register_egg("npc_talk:npc", "NPC", "wool_blue.png", 1)
end

npc_talk.enable_talk_to_example_npc = function()
	-- provide information about the model
	yl_speak_up.mesh_data["skinsdb_3d_armor_character_5.b3d"] = {
		-- the second texture is the skin
		texture_index = 2,
		-- they can wear and show capes and wield items
		can_show_wielded_items = true,
		-- call textures2skin in order to convert the textures (wielded items)
		textures_to_skin = true,
		animation = {
			-- {x = start_frame, y = end_frame, collisionbox}
			stand_still = {x =   0, y =   0, collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3}},
			stand       = {x =   0, y =  79, collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3}},
			sit         = {x =  81, y = 160, collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.0, 0.3}},
			lay         = {x = 162, y = 166, collisionbox = {-0.6, 0.0, -0.6, 0.6, 0.3, 0.6}},
			walk        = {x = 168, y = 187, collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3}},
			mine        = {x = 189, y = 198, collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3}},
			walk_mine   = {x = 200, y = 219, collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3}},
	        },
	}

end

-- we need a suitable mesh and skins from somewhere
if(minetest.get_modpath("mobs")) then
	-- register the NPC once
	npc_talk.register_example_npc()
	-- make sure it gets called once now and in the future whenever yl_speak_up is reloaded
	-- (via /npc_talk_reload)
	yl_speak_up.register_on_reload(npc_talk.enable_talk_to_example_npc, "npc_talk.enable_talk_to_example_npc()")
end
