DIR_DELIM = "/"

local modpath = minetest.get_modpath("npc_talk")..DIR_DELIM

npc_talk = {}


-- find out the right mesh; if the wrong one is used, the traders become invisible
npc_talk.talking_npc_mesh = "character.b3d";
-- 3darmor/wieldview is great
if( minetest.get_modpath( '3d_armor' )) then
	npc_talk.talking_npc_mesh = "3d_armor_character.b3d";
end
npc_talk.talking_npc_texture = "character.png"
npc_talk.talking_npc_inventory_image = "character.png"



-- a very basic NPC that doesn't require any other mods
-- (apart from minetest_game/player_api or any other source of
-- a mesh named character.b3d and a suitable texture named character.png)
if(minetest.settings:get_bool("enable_npc_talk_basic", true)) then
	dofile(modpath .. "talking_npc.lua")
	if(minetest.settings:get_bool("enable_npc_talk_craft_basic", true)) then
		minetest.register_craft({
			output = "npc_talk:talking_npc_item",
			recipe = {
				{"dye:black"},
				{"default:paper"},
				{"default:goldblock"},
			},
		})
	end
end

-- register an example mob and a spawn egg
-- (requires mobs_redo and skinsdb as we need some mesh and some textures from somewhere)
if(minetest.settings:get_bool("enable_npc_talk_mobs_redo", true)) then
	dofile(modpath .. "example_npc.lua")
	if(minetest.settings:get_bool("enable_npc_talk_craft_mobs_redo", true)) then
		minetest.register_craft({
			output = "npc_talk:npc",
			recipe = {
				{"dye:blue"},
				{"default:paper"},
				{"default:goldblock"},
			},
		})
	end
end

-- add textures from textures/npc_talk_main_TEXTURE_NAME.png for the example npc
dofile(modpath .. "add_skins_and_capes.lua")

-- demonstration that a node can be used for starting talking as well
if(minetest.settings:get_bool("enable_npc_talk_sign", true)) then
	dofile(modpath .. "example_talk_sign.lua")
end

-- make mobs_npc from mobs_redo ready to be talked to (requires mobs_npc)
if(minetest.settings:get_bool("enable_npc_talk_mobs_npc", true)) then
	dofile(modpath .. "talk_to_mobs_npc.lua")
end

-- mostly a demonstration for mobs_animal (allows to talk to white and red sheep and a cow)
-- you need to craft a special book/tool to talk to them as they don't offer a suitable interface;
-- punch them with npc_talk:talk_tool
if(minetest.settings:get_bool("enable_npc_talk_talk_tool", true)) then
	dofile(modpath .. "talk_tool.lua")
end
if(minetest.settings:get_bool("enable_npc_talk_mobs_animal", true)) then
	dofile(modpath .. "talk_to_animals.lua")
end
