
npc_talk.enable_talk_to_mobs_npc = function()

	-- the following information is needed in order to handle skin changes

	-- this model is used by mobs_npc
	yl_speak_up.mesh_data["mobs_character.b3d"] = {
		-- the first texture is the skin
		texture_index = 1,
		-- there is no support for capes or wielded items
		can_show_wielded_items = false,
		-- textures are applied directly
		textures_to_skin = false,
		-- this information needed so that the animation of the mob can be set (i.e. them sitting)
		animation = {
			-- {x = start_frame, y = end_frame, collisionbox}
			stand_still = {x =   0, y =   0, collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3}},
			stand       = {x =   0, y =  79, collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3}},
			sit         = {x =  81, y = 160, collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.0, 0.3}},
			lay         = {x = 162, y = 166, collisionbox = {-0.6, 0.0, -0.6, 0.6, 0.3, 0.6}},
			walk        = {x = 168, y = 187, collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3}},
			mine        = {x = 189, y = 198, collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3}},
			walk_mine   = {x = 200, y = 219, collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3}},
	        },
	}

	-- list all textures that shall be available as skins for this particular npc:
	-- the normal NPC (can be fed and tamed with bread)
	yl_speak_up.mob_skins["mobs_npc:npc"] = {
		"mobs_npc.png", "mobs_npc2.png", "mobs_npc3.png", "mobs_npc4.png", "mobs_npc_baby.png"}
	-- the Igor mob
	yl_speak_up.mob_skins["mobs_npc:igor"] = {
		"mobs_igor.png",  "mobs_igor2.png", "mobs_igor3.png", "mobs_igor4.png",
		"mobs_igor5.png", "mobs_igor6.png", "mobs_igor7.png", "mobs_igor8.png"}
	-- the trader mob
	yl_speak_up.mob_skins["mobs_npc:trader"] = {
		"mobs_trader.png", "mobs_trader2.png", "mobs_trader3.png"}

	-- some mobs (in particular from mobs_redo) can switch between follow (their owner),
	-- stand and walking when they're right-clicked; emulate this behaviour for NPC in
	-- this list
	table.insert(yl_speak_up.emulate_orders_on_rightclick, "mobs_npc:npc")
	table.insert(yl_speak_up.emulate_orders_on_rightclick, "mobs_npc:igor")
	table.insert(yl_speak_up.emulate_orders_on_rightclick, "mobs_npc:trader")
end


if(minetest.get_modpath("mobs_npc")) then
	-- make sure it gets called once now and in the future whenever yl_speak_up is reloaded
	-- (via /npc_talk_reload)
	yl_speak_up.register_on_reload(npc_talk.enable_talk_to_mobs_npc, "npc_talk.enable_talk_to_mobs_npc()")

	-- mobs_npc now provides us with a nice function for overriding :-)
	npc_talk.old_mobs_npc_npc_talk = mobs_npc.npc_talk
	mobs_npc.npc_talk = function(self, player, message_list)
		yl_speak_up.talk(self, player)
		return 
	end
end
