-- we need to initiate talk to a mob somehow
npc_talk.talk_tool = function(itemstack, player, pointed_thing)
	if(not(player) or not(pointed_thing) or pointed_thing.type ~= 'object') then
		return nil
	end
	local pname = player:get_player_name()
 
	local ref = pointed_thing.ref
	if(not(ref)) then
		return
	elseif(ref:is_player()) then
		minetest.chat_send_player(pname, "You can talk to other players via /msg <playername> <text>")
		return
	end
	local luaob = ref:get_luaentity();
	if(not(luaob)
	  or not(luaob.name)
	  -- we can only talk to NPC for which we have information for skin configuration
	  or not(yl_speak_up.mob_skins[luaob.name])) then
		minetest.chat_send_player(pname, "Sorry. This entity hasn't been taught how to talk ("..
				tostring(luaob.name)..").")
		return
	end
	-- actually talk
	minetest.chat_send_player(pname, "Talking to entity of type "..tostring(luaob.name)..".")
	yl_speak_up.talk(luaob, player)
	
	return nil -- no item shall be removed from inventory
end


-- The aniamals have too many functions in on_rightclick - they would need new code
-- for talking to them in on_rightclick.
-- As a workaround, you need to wield this tool and punch or right-click them with it.
minetest.register_craftitem("npc_talk:talk_tool", {
	description = "Punch a suitable animal (white or red sheep, cow) with this tool to talk to it",
	inventory_image = "mobs_magic_lasso.png^mobs_shears.png",
	groups = {book = 1},
	on_use = npc_talk.talk_tool,
	on_place = npc_talk.talk_tool,
})

-- add a suitable craft receipe
minetest.register_craft({
	output = "npc_talk:talk_tool",
	recipe = {
		{"mobs:shears"},
		{"mobs:lasso"},
	},
})
