local msg_color = "#ffffff" -- use a color hex to change the color of private messages

dofile(minetest.get_modpath("betterpm") .. "/chatcmdbuilder.lua")

local reply_to = {}

ChatCmdBuilder.new("msg", function(cmd)
  cmd:sub(":target :message:text", function (sender, target, message)
    reply_to[sender] = target
    reply_to[target] = sender
    minetest.chat_send_player(target, minetest.colorize(msg_color, "[" .. sender .. " -> You] " .. message))
    minetest.chat_send_player(sender, minetest.colorize(msg_color, "[You -> " .. target .. "] " .. message))
  end)
end, {
  description = "Write private messages",
  params = "<name> <message>",
})

ChatCmdBuilder.new("r", function(cmd)
  cmd:sub(":message:text", function (sender, message)
    if reply_to[sender] ~= nil then
      minetest.chat_send_player(reply_to[sender], minetest.colorize(msg_color, "[" .. sender .. " -> You] " .. message))
      minetest.chat_send_player(sender, minetest.colorize(msg_color, "[You -> " .. reply_to[sender] .. "] " .. message))
    else
      minetest.chat_send_player(sender, "You must write to someone before replying. Use /msg <name> <message>")
    end
  end)
end, {
  description = "Reply to a private message",
  params = "<message>",
})

minetest.log("action", "[BETTERPM] Mod initialised")
