local prefix_color = "#ffffff" -- use a color hex to change the color of private messages prefix
local msg_color = "#ffffff" -- use a color hex to change the color of private messages

-- {target} is who receives the message, {sender} is who sends the message
local senderPrefix = "[You -> {target}] " -- the sender will see this
local targetPrefix = "[{sender} -> You] " -- the target will receive this

dofile(minetest.get_modpath("betterpm") .. "/chatcmdbuilder.lua")

local reply_to = {}

local function formatPrefix(prefix, sender, target)
  local res, _ = prefix:gsub("{sender}", sender)
  res, _ = res:gsub("{target}", target)

  return res
end

local function sendMessage(sender, target, message)
  reply_to[sender] = target
  reply_to[target] = sender
  minetest.chat_send_player(target, minetest.colorize(prefix_color, formatPrefix(targetPrefix, sender, target) .. minetest.colorize(msg_color, message)))
  minetest.chat_send_player(sender, minetest.colorize(prefix_color, formatPrefix(senderPrefix, sender, target) .. minetest.colorize(msg_color, message)))
end

ChatCmdBuilder.new("msg", function(cmd)
  cmd:sub(":target :message:text", function (sender, target, message)
    sendMessage(sender, target, message)
  end)
end, {
  description = "Write private messages",
  params = "<name> <message>",
})

ChatCmdBuilder.new("w", function(cmd)
  cmd:sub(":target :message:text", function (sender, target, message)
    sendMessage(sender, target, message)
  end)
end, {
  description = "Alias for /msg",
  params = "<name> <message>",
})

ChatCmdBuilder.new("r", function(cmd)
  cmd:sub(":message:text", function (sender, message)
    if reply_to[sender] ~= nil then
      reply_to[reply_to[sender]] = sender
      minetest.chat_send_player(reply_to[sender], minetest.colorize(prefix_color, formatPrefix(targetPrefix, sender, reply_to[sender]) .. minetest.colorize(msg_color, message)))
      minetest.chat_send_player(sender, minetest.colorize(prefix_color, formatPrefix(senderPrefix, sender, reply_to[sender]) .. minetest.colorize(msg_color, message)))
    else
      minetest.chat_send_player(sender, "You must write to someone before replying. Use /msg <name> <message>")
    end
  end)
end, {
  description = "Reply to a private message",
  params = "<message>",
})

minetest.log("action", "[BETTERPM] Mod initialised")
