-------diamond entity and node replacement managment







minetest.register_globalstep(function(dtime)
    local radius = 5 -- Define the radius within which to check for the node
    local target_node = "default:stone_with_diamond" -- Node to check for
    local replace_node = "3d_ores:stone_with_diamond" -- Node to replace with
    local entity1 = "3d_ores:glowing_entity" -- First entity to add
    local entity2 = "3d_ores:glowing_entity_add" -- Second entity to add

    for _, player in ipairs(minetest.get_connected_players()) do
        local pos = player:get_pos()
        local minp = vector.subtract(pos, radius)
        local maxp = vector.add(pos, radius)
        
        local nodes = minetest.find_nodes_in_area(minp, maxp, {target_node})
        for _, node_pos in ipairs(nodes) do
            minetest.set_node(node_pos, {name = replace_node})
            minetest.add_entity(node_pos, entity1)
            minetest.add_entity(node_pos, entity2)
        end
    end
end)

minetest.register_abm({
    label = "Check player radius and convert node",
    nodenames = {"3d_ores:stone_with_diamond"}, -- Replace with your target node
    interval = 1, -- Time interval in seconds
    chance = 1, -- Chance of the ABM running each interval
    action = function(pos, node)
        local radius = 10 -- Define the radius to check for players
        local objects = minetest.get_objects_inside_radius(pos, radius)
        local player_found = false

        for _, obj in ipairs(objects) do
            if obj:is_player() then
                player_found = true
                break
            end
        end

        if not player_found then
            minetest.set_node(pos, {name = "default:stone_with_diamond"}) -- Replace with the node to convert to
            local entities = minetest.get_objects_inside_radius(pos, 0.5)
            for _, entity in ipairs(entities) do
                if entity:get_luaentity() and (entity:get_luaentity().name == "3d_ores:glowing_entity" or entity:get_luaentity().name == "3d_ores:glowing_entity_add") then
                    entity:remove()
                end
            end
        end
    end,
})



--------entitys diamond
-- Register the glowing entity
minetest.register_entity("3d_ores:glowing_entity", {
    visual = "mesh",
    mesh = "ore_3d_inner.obj",

        visual_size = {x=10.01, y=10.01},
    pointable = false, -- Make the entity non-pointable

    textures = {
        "default_mineral_diamond.png", -- top
        "default_mineral_diamond.png", -- bottom
         "default_mineral_diamond.png", -- right
         "default_mineral_diamond.png", -- left
         "default_mineral_diamond.png", -- back
         "default_mineral_diamond.png"  -- front
    },

    glow = 30, -- Adjust the glow value as needed
    on_step = function(self, dtime)
        -- Keep the entity at the same position as the node
        local pos = self.object:get_pos()
        local node = minetest.get_node(pos)
        if node.name ~= "3d_ores:stone_with_diamond" then
            self.object:remove()
        end
    end,
})








-- Register the glowing entity
minetest.register_entity("3d_ores:glowing_entity_add", {
    visual = "mesh",
    mesh = "ore_3d_lightingbetter2.obj",

        visual_size = {x=10, y=10},
    pointable = false, -- Make the entity non-pointable

    textures = {
        "diglow.png", -- top
        "diglow.png", -- bottom
         "diglow.png", -- right
         "diglow.png", -- left
         "diglow.png", -- back
         "diglow.png"  -- front
    },

    glow = 10, -- Adjust the glow value as needed
    on_step = function(self, dtime)
        -- Keep the entity at the same position as the node
        local pos = self.object:get_pos()
        local node = minetest.get_node(pos)
        if node.name ~= "3d_ores:stone_with_diamond" then
            self.object:remove()
        end
    end,
})



-- Register the diamond ore node
minetest.register_node("3d_ores:stone_with_diamond", {
    description = "Glowing Diamond Ore",
    drawtype = "mesh",
    mesh = "ore_3d_lightingbetter2.obj",

    is_ground_content = true,
    groups = {cracky = 1},
    drop = "default:diamond",
    sounds = default.node_sound_stone_defaults(),
    tiles = {"diore.png"},
    inventory_image = "diinv.png",
    wield_image = "diwield.png",

    after_place_node = function(pos, placer, itemstack, pointed_thing)
        -- Place the first glowing entity at the same position
        minetest.add_entity(pos, "3d_ores:glowing_entity_add")
        -- Place the second different entity slightly offset
        local offset_pos = {x = pos.x + 0, y = pos.y, z = pos.z}
        minetest.add_entity(offset_pos, "3d_ores:glowing_entity")
    end,
    after_dig_node = function(pos, oldnode, oldmetadata, digger)
        -- Remove the glowing entities when the node is dug
        local objs = minetest.get_objects_inside_radius(pos, 1)
        for _, obj in ipairs(objs) do
            if obj:get_luaentity() then
                local entity_name = obj:get_luaentity().name
                if entity_name == "3d_ores:glowing_entity_add" or entity_name == "3d_ores:glowing_entity" then
                    obj:remove()
                end
            end
        end
    end,
})








-- Register the diamond ore node
minetest.register_node("3d_ores:stone_with_mese", {
    description = "Mese Ore",
    drawtype = "mesh",
    mesh = "ore_3d_lightingbetter2.obj",

    is_ground_content = true,
    groups = {cracky = 1},
    drop = "default:mese_crystal",
    sounds = default.node_sound_stone_defaults(),
    tiles = {"meseore.png"},
    inventory_image = "meseinv.png",
    wield_image = "mesewield.png",

    after_place_node = function(pos, placer, itemstack, pointed_thing)
        -- Place the first glowing entity at the same position
        minetest.add_entity(pos, "3d_ores:glowing_entity_add_mese")
        -- Place the second different entity slightly offset
        local offset_pos = {x = pos.x + 0, y = pos.y, z = pos.z}
        minetest.add_entity(offset_pos, "3d_ores:glowing_entity_mese")
    end,
    after_dig_node = function(pos, oldnode, oldmetadata, digger)
        -- Remove the glowing entities when the node is dug
        local objs = minetest.get_objects_inside_radius(pos, 1)
        for _, obj in ipairs(objs) do
            if obj:get_luaentity() then
                local entity_name = obj:get_luaentity().name
                if entity_name == "3d_ores:glowing_entity_add_mese" or entity_name == "3d_ores:glowing_entity_mese" then
                    obj:remove()
                end
            end
        end
    end,
})










minetest.register_globalstep(function(dtime)
    local radius = 5 -- Define the radius within which to check for the node
    local target_node = "default:stone_with_mese" -- Node to check for
    local replace_node = "3d_ores:stone_with_mese" -- Node to replace with
    local entity1 = "3d_ores:glowing_entity_mese" -- First entity to add
    local entity2 = "3d_ores:glowing_entity_add_mese" -- Second entity to add

    for _, player in ipairs(minetest.get_connected_players()) do
        local pos = player:get_pos()
        local minp = vector.subtract(pos, radius)
        local maxp = vector.add(pos, radius)
        
        local nodes = minetest.find_nodes_in_area(minp, maxp, {target_node})
        for _, node_pos in ipairs(nodes) do
            minetest.set_node(node_pos, {name = replace_node})
            minetest.add_entity(node_pos, entity1)
            minetest.add_entity(node_pos, entity2)
        end
    end
end)

minetest.register_abm({
    label = "Check player radius and convert node",
    nodenames = {"3d_ores:stone_with_mese"}, -- Replace with your target node
    interval = 1, -- Time interval in seconds
    chance = 1, -- Chance of the ABM running each interval
    action = function(pos, node)
        local radius = 10 -- Define the radius to check for players
        local objects = minetest.get_objects_inside_radius(pos, radius)
        local player_found = false

        for _, obj in ipairs(objects) do
            if obj:is_player() then
                player_found = true
                break
            end
        end

        if not player_found then
            minetest.set_node(pos, {name = "default:stone_with_mese"}) -- Replace with the node to convert to
            local entities = minetest.get_objects_inside_radius(pos, 0.5)
            for _, entity in ipairs(entities) do
                if entity:get_luaentity() and (entity:get_luaentity().name == "3d_ores:glowing_entity_mese" or entity:get_luaentity().name == "3d_ores:glowing_entity_add_mese") then
                    entity:remove()
                end
            end
        end
    end,
})











-- Register the glowing entity
minetest.register_entity("3d_ores:glowing_entity_mese", {
    visual = "mesh",
    mesh = "ore_3d_inner.obj",

        visual_size = {x=10.01, y=10.01},
    pointable = false, -- Make the entity non-pointable

    textures = {
        "mese_inside.png", -- top
        "mese_inside.png", -- bottom
         "mese_inside.png", -- right
         "mese_inside.png", -- left
         "mese_inside.png", -- back
         "mese_inside.png"  -- front
    },

    glow = 30, -- Adjust the glow value as needed
    on_step = function(self, dtime)
        -- Keep the entity at the same position as the node
        local pos = self.object:get_pos()
        local node = minetest.get_node(pos)
        if node.name ~= "3d_ores:stone_with_mese" then
            self.object:remove()
        end
    end,
})








-- Register the glowing entity
minetest.register_entity("3d_ores:glowing_entity_add_mese", {
    visual = "mesh",
    mesh = "ore_3d_lightingbetter2.obj",

        visual_size = {x=10, y=10},
    pointable = false, -- Make the entity non-pointable

    textures = {
        "meseglowore.png", -- top
        "meseglowore.png", -- bottom
         "meseglowore.png", -- right
         "meseglowore.png", -- left
         "meseglowore.png", -- back
         "meseglowore.png"  -- front
    },

    glow = 30, -- Adjust the glow value as needed
    on_step = function(self, dtime)
        -- Keep the entity at the same position as the node
        local pos = self.object:get_pos()
        local node = minetest.get_node(pos)
        if node.name ~= "3d_ores:stone_with_mese" then
            self.object:remove()
        end
    end,
})








----rest of ores


-- Register the diamond ore node
minetest.register_node("3d_ores:stone_with_coal", {

	description = ("Coal Ore"),
	groups = {cracky = 3},
	drop = "default:coal_lump",
	sounds = default.node_sound_stone_defaults(),


    drawtype = "mesh",
    mesh = "ore_3d_lightingbetter2.obj",
    tiles = {"coalore.png"},

})








-- Register the diamond ore node
minetest.register_node("3d_ores:stone_with_tin", {

	description = ("Tin Ore"),
	groups = {cracky = 2},
	drop = "default:tin_lump",
	sounds = default.node_sound_stone_defaults(),


    drawtype = "mesh",
    mesh = "ore_3d_lightingbetter2.obj",
    tiles = {"tinore.png"},

})



minetest.register_globalstep(function(dtime)
    local radius = 5 -- Define the radius within which to check for the node
    local target_node = "default:stone_with_tin" -- Node to check for
    local replace_node = "3d_ores:stone_with_tin" -- Node to replace with

    for _, player in ipairs(minetest.get_connected_players()) do
        local pos = player:get_pos()
        local minp = vector.subtract(pos, radius)
        local maxp = vector.add(pos, radius)
        
        for x = minp.x, maxp.x do
            for y = minp.y, maxp.y do
                for z = minp.z, maxp.z do
                    local node_pos = {x = x, y = y, z = z}
                    local node = minetest.get_node(node_pos)
                    
                    if node.name == target_node then
                        minetest.set_node(node_pos, {name = replace_node})
                    end
                end
            end
        end
    end
end)




minetest.register_abm({
    label = "Check player radius and convert node",
    nodenames = {"3d_ores:stone_with_tin"}, -- Replace with your target node
    interval = 1, -- Time interval in seconds
    chance = 1, -- Chance of the ABM running each interval
    action = function(pos, node)
        local radius = 10 -- Define the radius to check for players
        local objects = minetest.get_objects_inside_radius(pos, radius)
        local player_found = false

        for _, obj in ipairs(objects) do
            if obj:is_player() then
                player_found = true
                break
            end
        end

        if not player_found then
            minetest.set_node(pos, {name = "default:stone_with_tin"}) -- Replace with the node to convert to
        end
    end,
})





-- Register the diamond ore node
minetest.register_node("3d_ores:stone_with_iron", {

	description = ("Iron Ore"),
	groups = {cracky = 2},
	drop = "default:iron_lump",
	sounds = default.node_sound_stone_defaults(),


    drawtype = "mesh",
    mesh = "ore_3d_lightingbetter2.obj",
    tiles = {"ironore.png"},

})




minetest.register_globalstep(function(dtime)
    local radius = 5 -- Define the radius within which to check for the node
    local target_node = "default:stone_with_iron" -- Node to check for
    local replace_node = "3d_ores:stone_with_iron" -- Node to replace with

    for _, player in ipairs(minetest.get_connected_players()) do
        local pos = player:get_pos()
        local minp = vector.subtract(pos, radius)
        local maxp = vector.add(pos, radius)
        
        for x = minp.x, maxp.x do
            for y = minp.y, maxp.y do
                for z = minp.z, maxp.z do
                    local node_pos = {x = x, y = y, z = z}
                    local node = minetest.get_node(node_pos)
                    
                    if node.name == target_node then
                        minetest.set_node(node_pos, {name = replace_node})
                    end
                end
            end
        end
    end
end)




minetest.register_abm({
    label = "Check player radius and convert node",
    nodenames = {"3d_ores:stone_with_iron"}, -- Replace with your target node
    interval = 1, -- Time interval in seconds
    chance = 1, -- Chance of the ABM running each interval
    action = function(pos, node)
        local radius = 10 -- Define the radius to check for players
        local objects = minetest.get_objects_inside_radius(pos, radius)
        local player_found = false

        for _, obj in ipairs(objects) do
            if obj:is_player() then
                player_found = true
                break
            end
        end

        if not player_found then
            minetest.set_node(pos, {name = "default:stone_with_iron"}) -- Replace with the node to convert to
        end
    end,
})











-- Register the diamond ore node
minetest.register_node("3d_ores:stone_with_copper", {

	description = ("Copper Ore"),
	groups = {cracky = 2},
	drop = "default:copper_lump",
	sounds = default.node_sound_stone_defaults(),

    drawtype = "mesh",
    mesh = "ore_3d_lightingbetter2.obj",
    tiles = {"copperore.png"},

})



minetest.register_globalstep(function(dtime)
    local radius = 5 -- Define the radius within which to check for the node
    local target_node = "default:stone_with_copper" -- Node to check for
    local replace_node = "3d_ores:stone_with_copper" -- Node to replace with

    for _, player in ipairs(minetest.get_connected_players()) do
        local pos = player:get_pos()
        local minp = vector.subtract(pos, radius)
        local maxp = vector.add(pos, radius)
        
        for x = minp.x, maxp.x do
            for y = minp.y, maxp.y do
                for z = minp.z, maxp.z do
                    local node_pos = {x = x, y = y, z = z}
                    local node = minetest.get_node(node_pos)
                    
                    if node.name == target_node then
                        minetest.set_node(node_pos, {name = replace_node})
                    end
                end
            end
        end
    end
end)




minetest.register_abm({
    label = "Check player radius and convert node",
    nodenames = {"3d_ores:stone_with_copper"}, -- Replace with your target node
    interval = 1, -- Time interval in seconds
    chance = 1, -- Chance of the ABM running each interval
    action = function(pos, node)
        local radius = 10 -- Define the radius to check for players
        local objects = minetest.get_objects_inside_radius(pos, radius)
        local player_found = false

        for _, obj in ipairs(objects) do
            if obj:is_player() then
                player_found = true
                break
            end
        end

        if not player_found then
            minetest.set_node(pos, {name = "default:stone_with_copper"}) -- Replace with the node to convert to
        end
    end,
})






-- Register the diamond ore node
minetest.register_node("3d_ores:stone_with_gold", {

	description = ("Gold Ore"),	
	groups = {cracky = 2},
	drop = "default:gold_lump",
	sounds = default.node_sound_stone_defaults(),


    drawtype = "mesh",
    mesh = "ore_3d_lightingbetter2.obj",
    tiles = {"goldore.png"},

})




minetest.register_globalstep(function(dtime)
    local radius = 5 -- Define the radius within which to check for the node
    local target_node = "default:stone_with_gold" -- Node to check for
    local replace_node = "3d_ores:stone_with_gold" -- Node to replace with

    for _, player in ipairs(minetest.get_connected_players()) do
        local pos = player:get_pos()
        local minp = vector.subtract(pos, radius)
        local maxp = vector.add(pos, radius)
        
        for x = minp.x, maxp.x do
            for y = minp.y, maxp.y do
                for z = minp.z, maxp.z do
                    local node_pos = {x = x, y = y, z = z}
                    local node = minetest.get_node(node_pos)
                    
                    if node.name == target_node then
                        minetest.set_node(node_pos, {name = replace_node})
                    end
                end
            end
        end
    end
end)




minetest.register_abm({
    label = "Check player radius and convert node",
    nodenames = {"3d_ores:stone_with_gold"}, -- Replace with your target node
    interval = 1, -- Time interval in seconds
    chance = 1, -- Chance of the ABM running each interval
    action = function(pos, node)
        local radius = 10 -- Define the radius to check for players
        local objects = minetest.get_objects_inside_radius(pos, radius)
        local player_found = false

        for _, obj in ipairs(objects) do
            if obj:is_player() then
                player_found = true
                break
            end
        end

        if not player_found then
            minetest.set_node(pos, {name = "default:stone_with_gold"}) -- Replace with the node to convert to
        end
    end,
})


-- Define the specific node and entities
local target_node = "default:stone_with_mese"
local entity1 = "3d_ores:glowing_entity_add_mese"
local entity2 = "3d_ores:glowing_entity_mese"

-- Register the globalstep function
minetest.register_globalstep(function(dtime)
    for _, player in ipairs(minetest.get_connected_players()) do
        local pos = player:get_pos()
        pos = vector.round(pos) -- Round to the nearest node position

        -- Check if the node at the player's position is the target node
        local node = minetest.get_node(pos)
        if node.name == target_node then
            local objects = minetest.get_objects_inside_radius(pos, 0.5)
            local has_entity1 = false
            local has_entity2 = false

            -- Check for the specific entities
            for _, obj in ipairs(objects) do
                if obj:get_luaentity() then
                    if obj:get_luaentity().name == entity1 then
                        has_entity1 = true
                    elseif obj:get_luaentity().name == entity2 then
                        has_entity2 = true
                    end
                end
            end

            -- Add the entities if they are not present
            if not has_entity1 then
                minetest.add_entity(pos, entity1)
            end
            if not has_entity2 then
                minetest.add_entity(pos, entity2)
            end
        end
    end
end)





minetest.register_globalstep(function(dtime)
    local radius = 5 -- Define the radius within which to check for the node
    local target_node = "default:stone_with_coal" -- Node to check for
    local replace_node = "3d_ores:stone_with_coal" -- Node to replace with

    for _, player in ipairs(minetest.get_connected_players()) do
        local pos = player:get_pos()
        local minp = vector.subtract(pos, radius)
        local maxp = vector.add(pos, radius)
        
        for x = minp.x, maxp.x do
            for y = minp.y, maxp.y do
                for z = minp.z, maxp.z do
                    local node_pos = {x = x, y = y, z = z}
                    local node = minetest.get_node(node_pos)
                    
                    if node.name == target_node then
                        minetest.set_node(node_pos, {name = replace_node})
                    end
                end
            end
        end
    end
end)




minetest.register_abm({
    label = "Check player radius and convert node",
    nodenames = {"3d_ores:stone_with_coal"}, -- Replace with your target node
    interval = 1, -- Time interval in seconds
    chance = 1, -- Chance of the ABM running each interval
    action = function(pos, node)
        local radius = 10 -- Define the radius to check for players
        local objects = minetest.get_objects_inside_radius(pos, radius)
        local player_found = false

        for _, obj in ipairs(objects) do
            if obj:is_player() then
                player_found = true
                break
            end
        end

        if not player_found then
            minetest.set_node(pos, {name = "default:stone_with_coal"}) -- Replace with the node to convert to
        end
    end,
})






-- Register the diamond ore node
minetest.register_node("3d_ores:stone_with_ocd", {
	description = ("a node not meant to be wielded"),
    	tiles = {"pure_ocd.png"},
	groups = {cracky = 2},


})


-- Register the diamond ore node
minetest.register_node("3d_ores:stone_with_ocd_2", {
	description = ("a node not meant to be wielded"),
    	tiles = {"pure_ocd2.png"},
	groups = {cracky = 2},


})



