





-- Define gravity, friction, initial speed, max speed, and acceleration increment
local gravity = -9.8
local friction = 0.9
local initial_speed = 4
local max_speed = 20
local speed_increment = 1 -- This will increase by 1 every second

-- Register the globalstep function
minetest.register_globalstep(function(dtime)
    for _, player in ipairs(minetest.get_connected_players()) do
        local attached = player:get_attach()
        if attached then
            local entity = attached:get_luaentity()
            if entity and entity.allow_control then
                local ctrl = player:get_player_control()
                local player_yaw = player:get_look_horizontal()
                local dir = minetest.yaw_to_dir(player_yaw)
                
                -- Get current velocity
                local vel = entity.object:get_velocity()
                
                -- If moving forward or backward, increase the speed increment
                if ctrl.up or ctrl.down then
                    -- Increase speed by 1 every second
                    speed_increment = speed_increment + 1 * dtime
                    -- Cap the speed increment at the max speed minus the initial speed
                    if speed_increment > max_speed - initial_speed then
                        speed_increment = max_speed - initial_speed
                    end
                else
                    -- Reset speed increment when not moving
                    speed_increment = 0
                end
                
                -- Calculate new speed based on the speed increment
                local new_speed = initial_speed + speed_increment
                
                -- Apply new speed in the direction the player is looking
                if ctrl.up then
                    vel.x = dir.x * new_speed
                    vel.z = dir.z * new_speed
                elseif ctrl.down then
                    vel.x = -dir.x * new_speed
                    vel.z = -dir.z * new_speed
                end
                
                -- Apply gravity and friction
                vel.y = (vel.y or 0) + gravity * dtime
                vel.x = vel.x * friction
                vel.z = vel.z * friction
                
                -- Set the new velocity
                entity.object:set_velocity(vel)
            end
        end
    end
end)

minetest.register_entity("bam_mod:controllable_entity", {
    visual = "mesh",
    mesh = "bam_1.obj",
        textures = {"battledroid.png"}, -- Replace with your texture file
    stepheight = 2.5,
        visual_size = {x=20, y=20},

    physical = true,
	collisionbox = {-1.4,-0.0,-1.4, 1.4,20.5,1.4},


    on_activate = function(self, staticdata, dtime_s)
        self.object:set_properties({
            visual_size = {x=18, y=18},
        })
        self.object:set_acceleration({x=0, y=gravity, z=0})
        self.allow_control = true
    end,

    on_step = function(self, dtime)
        if self.driver then
            local ctrl = self.driver:get_player_control()
            if ctrl.up or ctrl.down or ctrl.left or ctrl.right then
                local player_yaw = self.driver:get_look_horizontal()
                self.object:set_yaw(player_yaw)
            end
            local v = self.object:get_velocity()
            if v.x ~= 0 or v.z ~= 0 then
                self.object:set_yaw(minetest.dir_to_yaw(v))
            end
        end
    end,

	on_rightclick = function(self, clicker)
		if self.driver and clicker == self.driver then
		vehicles.object_detach(self, clicker, {x=0, y=5, z=0})
		elseif not self.driver then
		vehicles.object_attach(self, clicker, {x=0, y=75, z=0}, false, {x=0, y=58, z=2})
		minetest.sound_play("mech_start", 
		{to_player=self.driver:get_player_name(), gain = 4, max_hear_distance = 3, loop = false})
		self.sound_ready = false
		minetest.after(14, function()
		self.sound_ready = true
		end)
		end
	end,
})






-- Table to keep track of entities, their models, and timers
local entity_models = {
    ["bam_mod:controllable_entity"] = {
        current_index = 1,
        models = {
            "bam_1.obj", "bam_2.obj", "bam_3.obj", "bam_4.obj",
            "bam_5.obj", "bam_6.obj", "bam_7.obj", "bam_8.obj",
            "bam_9.obj", "bam_10.obj", "bam_11.obj", "bam_12.obj",
            "bam_13.obj", "bam_14.obj", "bam_15.obj", "bam_16.obj"
        },

        last_position = {x=0, y=0, z=0},
        timer = 0, -- Reset the timer for each entity

        interval = 1 -- Initial interval in seconds for sound play
    }
}

-- Function to get the next model in the list
local function get_next_model(entity)
    entity.current_index = (entity.current_index % #entity.models) + 1
    return entity.models[entity.current_index]
end

-- Store the last position and change count of each entity
local entity_info = {}

minetest.register_globalstep(function(dtime)
    for _, obj in pairs(minetest.luaentities) do
        if obj and obj.name == "bam_mod:controllable_entity" and obj.object and obj.object.get_pos then
            local entity_data = entity_models[obj.name]
            local pos = obj.object:get_pos()

            -- Check if pos is not nil before using it
            if pos then
                -- Initialize entity info if not present
                if not entity_info[obj] then
                    entity_info[obj] = {last_pos = nil, change_count = 0}
                end

                -- Check if the position has changed
                if not entity_info[obj].last_pos or pos.x ~= entity_info[obj].last_pos.x or pos.y ~= entity_info[obj].last_pos.y or pos.z ~= entity_info[obj].last_pos.z then
                    -- Increase the change count
                    entity_info[obj].change_count = entity_info[obj].change_count + 1

                    -- If the change count is 3, change the model and reset the count
                    if entity_info[obj].change_count >= 3 then
                        -- Get the next model
                        local next_model = get_next_model(entity_data)
                        -- Set the new model
                        obj.object:set_properties({mesh = next_model})
                        -- Reset the change count
                        entity_info[obj].change_count = 0
                    end

                    -- Increase the timer by dtime
                    entity_data.timer = entity_data.timer + dtime

                    -- Calculate the speed of the entity
                    local speed = vector.length(obj.object:get_velocity())

                    -- Calculate the interval based on the speed
                    entity_data.interval = 1 / (speed / 16 + 1) -- Adjust the denominator to change the rate of increase

                    -- If the timer is greater than or equal to the interval, play the sound and reset the timer
                    if entity_data.timer >= entity_data.interval then
                        -- Play a sound
                        minetest.sound_play("bam_step", {object = obj.object, gain = 1.0, max_hear_distance = 32, loop = false})

                        -- Reset the timer
                        entity_data.timer = 0
                    end
                end

                -- Store the current position for the next check
                entity_info[obj].last_pos = pos
            end
        end
    end
end)

