minetest.register_craftitem("bam_mod:mech_spawner", {
    description = "Mech Spawner",
    inventory_image = "bam_skeleton.png",
    on_place = function(itemstack, user, pointed_thing)
        if pointed_thing.type == "node" then
            local pos = pointed_thing.above
            pos.y = pos.y + 1
            minetest.add_entity(pos, "bam_mod:controllable_entity")
            itemstack:take_item()  -- Decrease the item count by 1
        end
        return itemstack
    end,
})



-- Define gravity, friction, initial speed, max speed, and acceleration increment
local gravity = -9.8
local friction = 0.9
local initial_speed = 4
local max_speed = 20
local speed_increment = 1 -- This will increase by 1 every second

-- Register the globalstep function
minetest.register_globalstep(function(dtime)
    for _, player in ipairs(minetest.get_connected_players()) do
        local attached = player:get_attach()
        if attached then
            local entity = attached:get_luaentity()
            if entity and entity.allow_control then
                local ctrl = player:get_player_control()
                local player_yaw = player:get_look_horizontal()
                local dir = minetest.yaw_to_dir(player_yaw)
                
                -- Get current velocity
                local vel = entity.object:get_velocity()
                
                -- If moving forward or backward, increase the speed increment
                if ctrl.up or ctrl.down then
                    -- Increase speed by 1 every second
                    speed_increment = speed_increment + 1 * dtime
                    -- Cap the speed increment at the max speed minus the initial speed
                    if speed_increment > max_speed - initial_speed then
                        speed_increment = max_speed - initial_speed
                    end
                else
                    -- Reset speed increment when not moving
                    speed_increment = 0
                end
                
                -- Calculate new speed based on the speed increment
                local new_speed = initial_speed + speed_increment
                
                -- Apply new speed in the direction the player is looking
                if ctrl.up then
                    vel.x = dir.x * new_speed
                    vel.z = dir.z * new_speed
                elseif ctrl.down then
                    vel.x = -dir.x * new_speed
                    vel.z = -dir.z * new_speed
                end
                
                -- Apply gravity and friction
                vel.y = (vel.y or 0) + gravity * dtime
                vel.x = vel.x * friction
                vel.z = vel.z * friction
                
                -- Set the new velocity
                entity.object:set_velocity(vel)
            end
        end
    end
end)

minetest.register_entity("bam_mod:controllable_entity", {
    visual = "mesh",
    mesh = "bam_1.obj",
        textures = {"battledroid_innerd.png"}, -- Replace with your texture file
    stepheight = 2.5,
        visual_size = {x=20, y=20},

    physical = true,
	collisionbox = {-1.4,-0.0,-1.4, 1.4,20.5,1.4},




on_punch = function(self, puncher)
        if puncher:is_player() then
            local inv = puncher:get_inventory()
            inv:add_item("main", "bam_mod:mech_spawner 1")
            self.object:remove()
        end
    end,




    on_activate = function(self, staticdata, dtime_s)
        self.object:set_properties({
            visual_size = {x=18, y=18},
        })
        self.object:set_acceleration({x=0, y=gravity, z=0})
        self.allow_control = true
    end,

    on_step = function(self, dtime)
        if self.driver then
            local ctrl = self.driver:get_player_control()
            if ctrl.up or ctrl.down or ctrl.left or ctrl.right then
                local player_yaw = self.driver:get_look_horizontal()
                self.object:set_yaw(player_yaw)
            end
            local v = self.object:get_velocity()
            if v.x ~= 0 or v.z ~= 0 then
                self.object:set_yaw(minetest.dir_to_yaw(v))
            end
        end
    end,

	on_rightclick = function(self, clicker)
		if self.driver and clicker == self.driver then
		vehicles.object_detach(self, clicker, {x=0, y=5, z=0})
		elseif not self.driver then
		vehicles.object_attach(self, clicker, {x=0, y=5, z=0}, false, {x=0, y=53, z=2})
		minetest.sound_play("mech_start", 
		{to_player=self.driver:get_player_name(), gain = 4, max_hear_distance = 3, loop = false})
		minetest.after(14, function()
		self.sound_ready = true
		end)

		end
	end,
})



minetest.register_node("bam_mod:animated_cobble", {
    description = "Animated lava Cobble",
    tiles = {
        {
            name = "bam_lava.png",
            animation = {
                type = "vertical_frames",
                aspect_w = 16,
                aspect_h = 16,
                length = 1.0,
            },
        },
    },
    is_ground_content = false,
    groups = {cracky = 3, stone = 1},
    drop = "default:cobble",
    sounds = default.node_sound_stone_defaults(),
    after_dig_node = function(pos, oldnode, oldmetadata, digger)
        minetest.set_node(pos, {name = "default:lava_source"})
    end,
})

-- Table to keep track of entities, their models, and timers
local entity_models = {
    ["bam_mod:controllable_entity"] = {
        current_index = 1,
        models = {
            "bam_1.obj", "bam_2.obj", "bam_3.obj", "bam_4.obj",
            "bam_5.obj", "bam_6.obj", "bam_7.obj", "bam_8.obj",
            "bam_9.obj", "bam_10.obj", "bam_11.obj", "bam_12.obj",
            "bam_13.obj", "bam_14.obj", "bam_15.obj", "bam_16.obj",
            "bam_17.obj", "bam_18.obj", "bam_19.obj", "bam_20.obj"


        },

        last_position = {x=0, y=0, z=0},
        timer = 0, -- Reset the timer for each entity

        interval = 1 -- Initial interval in seconds for sound play
    }
}

-- Function to get the next model in the list
local function get_next_model(entity)
    entity.current_index = (entity.current_index % #entity.models) + 1
    return entity.models[entity.current_index]
end

-- Store the last position and change count of each entity
local entity_info = {}

minetest.register_globalstep(function(dtime)
    for _, obj in pairs(minetest.luaentities) do
        if obj and obj.name == "bam_mod:controllable_entity" and obj.object and obj.object.get_pos then
            local entity_data = entity_models[obj.name]
            local pos = obj.object:get_pos()

            -- Check if pos is not nil before using it
            if pos then
                -- Initialize entity info if not present
                if not entity_info[obj] then
                    entity_info[obj] = {last_pos = nil, change_count = 0}
                end

                -- Check if the position has changed
                if not entity_info[obj].last_pos or pos.x ~= entity_info[obj].last_pos.x or pos.y ~= entity_info[obj].last_pos.y or pos.z ~= entity_info[obj].last_pos.z then
                    -- Check if the entity is moving up or down with a velocity greater than 3
                    local velocity = obj.object:get_velocity()
                    if math.abs(velocity.y) <= 3 then
                        -- Increase the change count
                        entity_info[obj].change_count = entity_info[obj].change_count + 1

                        -- If the change count is 3, change the model and reset the count
                        if entity_info[obj].change_count >= 3 then
                            -- Get the next model
                            local next_model = get_next_model(entity_data)
                            -- Set the new model
                            obj.object:set_properties({mesh = next_model})
                            -- Reset the change count
                            entity_info[obj].change_count = 0
                        end

                        -- Increase the timer by dtime
                        entity_data.timer = entity_data.timer + dtime

                        -- Calculate the speed of the entity
                        local speed = vector.length(obj.object:get_velocity())

                        -- Calculate the interval based on the speed
                        entity_data.interval = 1 / (speed / 16 + 1) -- Adjust the denominator to change the rate of increase

                        -- If the timer is greater than or equal to the interval, play the sound and reset the timer
                        if entity_data.timer >= entity_data.interval then
                            -- Play a sound
                            minetest.sound_play("bam_step_2", {object = obj.object, gain = 1.0, max_hear_distance = 32, loop = false})

                            -- Reset the timer
                            entity_data.timer = 0
                        end
                    end
                end

                -- Store the current position for the next check
                entity_info[obj].last_pos = pos
            end
        end
    end
end)
-------bam_mod:controllable_entity






-- Register a globalstep function that gets called every server step
minetest.register_globalstep(function(dtime)
    -- Loop over every player
    for _, player in ipairs(minetest.get_connected_players()) do
        local controls = player:get_player_control()

        -- Check if the player is pressing the 'F' key
        if controls.aux1 then
            -- Check if the player is attached to a specific entity
            local attached_to = player:get_attach()
            if attached_to then
                local luaentity = attached_to:get_luaentity()
                if luaentity and luaentity.name == "bam_mod:controllable_entity" then
                    -- Check if the player has the required item in their inventory
                    local inv = player:get_inventory()
                    if inv:contains_item("main", "bam_mod:bam_lazar_fuel") then
                        -- The player has the item, proceed with adding the entity
                        local pos = player:get_pos()
                        local new_pos = {x = pos.x, y = pos.y + 7.3, z = pos.z}
                        local new_entity = minetest.add_entity(new_pos, "bam_mod:laser")

                        minetest.sound_play("lazarz_2", {pos = pos, gain = 1.0, max_hear_distance = 32})

                        -- Make the new entity fly in the direction the player is pointing
                        local dir = player:get_look_dir()
                        new_entity:set_velocity({x = dir.x * 10, y = dir.y * 10, z = dir.z * 10})

                        -- Make the parenting entity look in the direction the player is looking
                        local yaw = player:get_look_horizontal()
                        luaentity.object:set_yaw(yaw)

                        -- Change the entity's model while the button is pressed
                        luaentity.object:set_properties({
                            mesh = "bam_fire.obj", -- Change this to your desired model
                        })

                        -- Remove a specific item from the player's inventory
                        inv:remove_item("main", "bam_mod:bam_lazar_fuel")
                    end
                end
            end
        else
            -- Reset the entity's model to the original only if it's currently the new model
            local attached_to = player:get_attach()
            if attached_to then
                local luaentity = attached_to:get_luaentity()
                if luaentity and luaentity.name == "bam_mod:controllable_entity" then
                    local current_properties = luaentity.object:get_properties()
                    if current_properties.mesh == "bam_fire.obj" then
                        luaentity.object:set_properties({
                            mesh = "bam_8.obj",
                        })
                    end
                end
            end
        end
    end
end)








-----bam_mod:bam_lazar_fuel






--------------------1








minetest.register_globalstep(function(dtime)
    for _, obj in ipairs(minetest.get_objects_inside_radius({x=0, y=0, z=0}, 1000)) do
        if not obj:is_player() then
            local entity = obj:get_luaentity()
            if entity and entity.name == "bam_mod:controllable_entity" then
                local pos = obj:get_pos()
                local node_below = minetest.get_node({x=pos.x, y=pos.y-4, z=pos.z}).name
                if node_below == "air" then
                    if entity.current_model ~= "bam_air.obj" then
                        obj:set_properties({mesh = "bam_air.obj"})
                        entity.current_model = "bam_air.obj"
                    end
                else
                    if entity.current_model ~= "bam_8.obj" then
                        obj:set_properties({mesh = "bam_8.obj"})
                        entity.current_model = "bam_8.obj"
                    end
                end
            end
        end
    end
end)

-- this is not meant for use, just kept handy until i can find a use for it.
minetest.register_entity("bam_mod:laser_distruptor", {

    textures = {"lazerrrrr.png"}, -- Replace with your texture file

    -- Add a property to keep track of how many nodes the laser has passed through
    node_count = 0,

    -- Add a property to store the y position of the first node
    first_node_y = nil,

    on_step = function(self, dtime)
        -- This is called every server step. You can add your own logic here.

        local pos = self.object:get_pos()
        local node = minetest.get_node(pos)

        -- Get the node definition
        local def = minetest.registered_nodes[node.name]

        -- Check if the node is not air, not a nodebox, not airlike, and is walkable
        if node.name ~= "air" and def.drawtype ~= "nodebox" and def.drawtype ~= "airlike" and def.walkable then
            -- Store the name of the node that is being removed
            local removed_node_name = node.name

            -- Remove the node without dropping an item
            minetest.remove_node(pos)

            -- If this is the first node the laser has passed through, store its y position
            if self.node_count == 0 then
                self.first_node_y = pos.y
            end

            -- Increase the node count
            self.node_count = self.node_count + 1

            -- Add nodes above the original node
            for i = 1, self.first_node_y do
                local new_node_pos = {x = pos.x, y = pos.y + i, z = pos.z}
                minetest.set_node(new_node_pos, {name = removed_node_name})
            end

            -- If the laser has passed through 4 nodes, play a sound
            if self.node_count % 4 == 0 then
                minetest.sound_play("your_mod_your_sound", {pos = pos, gain = 1.0, max_hear_distance = 10})
            end

            -- If the laser has passed through 10 nodes, remove it
            if self.node_count >= 10 then
                self.object:remove()
                return
            end

            -- Continue moving through the node
            local dir = self.object:get_velocity()
            local new_pos = vector.add(pos, vector.multiply(dir, dtime))
            self.object:move_to(new_pos)
        end
    end,
})










minetest.register_entity("bam_mod:laser", {
    -- ... (other properties here)

    textures = {"lazerrrrr.png"}, -- Replace with your texture file

    glow = 100,

    -- Existing properties...
    node_count = 0,
    first_node_y = nil,

    on_step = function(self, dtime)
        -- Existing logic...
        
        local pos = self.object:get_pos()

        local node = minetest.get_node(pos)
        local def = minetest.registered_nodes[node.name]

        -- Check for collision with a node
        if node.name ~= "air" and def and def.drawtype ~= "nodebox" and def.drawtype ~= "airlike" and def.walkable then
            -- Trigger an explosion at the point of impact
            minetest.sound_play("bam_crash", {pos = pos, gain = 1.0, max_hear_distance = 62})
            minetest.set_node(pos, {name = "air"}) -- Remove the node

            -- Add particles for visual effect
            minetest.add_particlespawner({
                amount = 10, -- Number of particles
                time = 0.1, -- How long the spawner lasts
                minpos = vector.subtract(pos, 1), -- Min position of the particles
                maxpos = vector.add(pos, 1), -- Max position of the particles
                minvel = {x=-2, y=-2, z=-2}, -- Minimum velocity
                maxvel = {x=2, y=2, z=2}, -- Maximum velocity
                minacc = {x=0, y=-9.81, z=0}, -- Minimum acceleration
                maxacc = {x=0, y=-9.81, z=0}, -- Maximum acceleration
                minexptime = 0.1, -- Minimum expiration time
                maxexptime = 1, -- Maximum expiration time
                minsize = 8, -- Minimum size
                maxsize = 8, -- Maximum size
                collisiondetection = true, -- Enable collision detection
                vertical = false, -- Particles fall vertically
                texture = "lazerrrrr.png", -- Particle texture
            })

            -- Define the radius of the explosion
            local radius = 1 -- Adjust the radius as needed

            -- Iterate over a cubic area to drop nodes
            for x = -radius, radius do
                for y = -radius, radius do
                    for z = -radius, radius do
                        local target_pos = vector.add(pos, {x = x, y = y, z = z})
                        local target_node = minetest.get_node(target_pos)
                        local target_def = minetest.registered_nodes[target_node.name]

                        -- Check if the node is not air and is walkable
                        if target_node.name ~= "air" and target_def and target_def.walkable then
                            -- Drop the node as an item
                            minetest.add_item(target_pos, target_node.name)
                            -- Remove the node
                            minetest.remove_node(target_pos)
                        end
                    end
                end
            end

            -- Define the radius for the second node replacement
            local second_radius = 2 -- Adjust the second radius as needed

            -- Iterate over a cubic area for the second node replacement
            for x = -second_radius, second_radius do
                for y = -second_radius, second_radius do
                    for z = -second_radius, second_radius do
                        local target_pos = vector.add(pos, {x = x, y = y, z = z})
                        local target_node = minetest.get_node(target_pos)
                        local target_def = minetest.registered_nodes[target_node.name]

                        -- Check if the node is not air and is walkable
                        if target_node.name ~= "air" and target_def and target_def.walkable then
                            -- 1 in 5 chance to replace with lava
                            if math.random(1, 5) == 1 then
                                minetest.set_node(target_pos, {name = "bam_mod:animated_cobble"})
                            else
                                minetest.set_node(target_pos, {name = "default:stone"})
                            end

                            -- Check if the node above is air and set fire with 1 in 3 chance
                            local above_pos = {x = target_pos.x, y = target_pos.y + 1, z = target_pos.z}
                            local above_node = minetest.get_node(above_pos)
                            if above_node.name == "air" and math.random(1, 3) == 1 then
                                minetest.set_node(above_pos, {name = "fire:basic_flame"})
                            end
                        end
                    end
                end
            end

            -- Check for players within a radius and deal damage
            local damage_radius = 9 -- Adjust the radius as needed
            local objects = minetest.get_objects_inside_radius(pos, damage_radius)

            for _, obj in ipairs(objects) do
                if obj:is_player() then
                    obj:set_hp(obj:get_hp() - 3)
                end
            end

            -- Remove the laser entity
            self.object:remove()
            return
        end

        -- Existing logic for moving through nodes...
    end,
})






-----------------------------------------past this point is no longer meant to be used----------------fun outline entity, and sound player entity, i just included this cause i wanted to have it handy.


local gravity = -9.8

minetest.register_entity("bam_mod:outline", {
    physical = true,
    collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
    visual = "mesh",
        visual_size = {x=10, y=10},
    mesh = "overlap.obj",  -- Your .obj model
    textures = {"outline.png"},  -- Your texture

on_rightclick = function(self, clicker)
        if clicker:is_player() then
            local clicker_pos = clicker:get_pos()
            local entity_pos = self.object:get_pos()
            local yaw = math.atan2(clicker_pos.z - entity_pos.z, clicker_pos.x - entity_pos.x)
            self.object:set_yaw(yaw)
        end
    end,



    on_activate = function(self, staticdata)
        self.timer = 0
    end,

    on_step = function(self, dtime)
        self.timer = self.timer + dtime
        if self.timer >= 0.2 then
            self.timer = 0

            local nearest_player = nil
            local min_distance = math.huge
            local entity_pos = self.object:get_pos() -- Define entity_pos here

            for _, player in pairs(minetest.get_connected_players()) do
                local player_pos = player:get_pos()
                local distance = vector.distance(player_pos, entity_pos)

                if distance < min_distance then
                    min_distance = distance
                    nearest_player = player
                end
            end

            if nearest_player then
                local player_pos = nearest_player:get_pos()
                local yaw = math.atan2(player_pos.z - entity_pos.z, player_pos.x - entity_pos.x)
                self.object:set_yaw(yaw)
            end
        end
    end,
})



------------this entity allows you to listen to music when the game is on pause, or when you press escape. only works when you are close to it.


-- Example entity definition
minetest.register_entity("bam_mod:sounder", {
    on_activate = function(self, staticdata, dtime_s)
        self.max_distance = 10  -- Adjust as needed (radius in which players can hear)
        self.sound_handle = nil  -- Initialize the sound handle
    end,

    on_step = function(self, dtime)
        local player_list = minetest.get_connected_players()

        for _, player in ipairs(player_list) do
            local pos = self.object:get_pos()
            local player_pos = player:get_pos()
            local distance = vector.distance(pos, player_pos)

            if distance <= self.max_distance then
                -- Adjust volume based on distance
                local volume = 1 - (distance / self.max_distance)

                if not self.sound_handle then
                    -- Start playing the sound
                    self.sound_handle = minetest.sound_play("juke", {
                        to_player = player:get_player_name(),
                        gain = volume,
                        loop = true,  -- Loop the sound
                    })
                else
                    -- Update the volume of the currently playing sound
                    minetest.sound_stop(self.sound_handle)
                    self.sound_handle = minetest.sound_play("musicboxesc", {
                        to_player = player:get_player_name(),
                        gain = volume,
                        loop = true,  -- Loop the sound
                    })
                end
            elseif self.sound_handle then
                -- Stop the sound if player is out of range
                minetest.sound_stop(self.sound_handle)
                self.sound_handle = nil
            end
        end
    end,

    on_punch = function(self, puncher, time_from_last_punch, tool_capabilities, dir)
        -- Handle entity destruction (e.g., when punched)
        self.object:remove()
        if self.sound_handle then
            minetest.sound_stop(self.sound_handle)
            self.sound_handle = nil
        end
    end,
})





-- Example entity definition
minetest.register_entity("bam_mod:soundplayer1", {
nametag = "Now playing: a spacific music",
    textures = {"speaker.png"},  -- Texture file name
    on_activate = function(self, staticdata, dtime_s)
        self:start_timer()  -- Start the repeating timer
    end,

    start_timer = function(self)
        minetest.after(33, function()
            self:play_sound()
            self:start_timer()  -- Restart the timer
        end)
    end,

    play_sound = function(self)
        local max_distance = 10  -- Adjust as needed (radius in which players can hear)
        local player_list = minetest.get_connected_players()

        for _, player in ipairs(player_list) do
            local pos = self.object:get_pos()
            local player_pos = player:get_pos()
            local distance = vector.distance(pos, player_pos)

            if distance <= max_distance then
                -- Adjust volume based on distance
                local volume = 1 - (distance / max_distance)

                -- Play sound with adjusted volume
                minetest.sound_play("juke", {
                    to_player = player:get_player_name(),
                    gain = volume,
                })
            end
        end
    end,
})




local textures = {
    "speaker.png",
    "speaker1.png",
    "speaker2.png",
    "speaker3.png"
}

-- Function to change the entity's texture
local function changeTexture(entity)
    local currentTexture = entity:get_properties().textures[1]
    local currentIndex = 1

    -- Find the current texture index
    for i, texture in ipairs(textures) do
        if texture == currentTexture then
            currentIndex = i
            break
        end
    end

    -- Calculate the next texture index
    local nextIndex = (currentIndex % #textures) + 1
    local nextTexture = textures[nextIndex]

    -- Update the entity's texture
    entity:set_properties({textures = {nextTexture}})
end

-- Timer for texture change (0.8 seconds)
local timer = 0
minetest.register_globalstep(function(dtime)
    timer = timer + dtime
    if timer >= 0.8 then
        for _, player in ipairs(minetest.get_connected_players()) do
            local pos = player:get_pos()
            local nearby_entities = minetest.get_objects_inside_radius(pos, 10)

            for _, entity in ipairs(nearby_entities) do
                if entity:is_player() then
                    -- Skip players
                    goto continue
                end

                -- Check if the entity is the specific one you're interested in
                if entity:get_luaentity().name == "bam_mod:soundplayer1" then
                    changeTexture(entity)
                end

                ::continue::
            end
        end
        timer = 0
    end
end)




---------------------do not use the shit beyond this point, spawning it may cause some problums.




















local gravity = -9.8

minetest.register_entity("bam_mod:e1", {
    physical = true,
    collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
    visual = "mesh",
        visual_size = {x=10, y=10},
    mesh = "overlap.obj",  -- Your .obj model
    textures = {"outline.png"},  -- Your texture


    on_rightclick = function(self, clicker)
        -- Create a new entity
        local new_entity = minetest.add_entity(self.object:get_pos(), "bam_mod:outline")

        -- Parent the new entity to the initial entity
        new_entity:set_attach(self.object, "", {x = 0, y = 0, z = 0})
    end,
})






minetest.register_entity("bam_mod:e2", {
    physical = true,
    collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
    visual = "mesh",
        visual_size = {x=10, y=10},
    mesh = "overlap.obj",  -- Your .obj model
    textures = {"outline.png"},  -- Your texture
})



local entity_name = "bam_mod:outline"
local radius = 10

minetest.register_globalstep(function(dtime)
    for _, player in pairs(minetest.get_connected_players()) do
        local player_pos = player:get_pos()
        local entities = minetest.get_objects_inside_radius(player_pos, radius)

        for _, obj in ipairs(entities) do
            if obj:is_player() then
                local entity_pos = obj:get_pos()
                local yaw = math.atan2(entity_pos.z - player_pos.z, entity_pos.x - player_pos.x)
                obj:set_yaw(yaw)
                print("Entity yaw set to:", yaw) -- Debugging output
            end
        end
    end
end)























------------------------------------------------------suckernode!!
























-- Define your custom entity
minetest.register_entity("bam_mod:replacement_entity", {
    initial_properties = {
        physical = true,
        collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
        visual = "cube",
        textures = {}, -- Initialize with an empty texture list
    },

    on_step = function(self, dtime)
        local pos = self.object:get_pos()
        local replacement_radius = 5 -- Radius for node replacement
        local drop_radius = 5 -- Radius for item drop

        -- Find nearby nodes for replacement
        local nodes_for_replacement = minetest.find_nodes_in_area(
            {x = pos.x - replacement_radius, y = pos.y - replacement_radius, z = pos.z - replacement_radius},
            {x = pos.x + replacement_radius, y = pos.y + replacement_radius, z = pos.z + replacement_radius},
            {
                "group:stone",
                "group:dirt",
                -- Add more groups as necessary (excluding "air")
            }
        )

        for _, node_pos in ipairs(nodes_for_replacement) do
            local node_name = minetest.get_node(node_pos).name
            local node_def = minetest.registered_nodes[node_name]
            if node_def and node_def.tiles and node_name ~= "air" then
                -- Use the first texture from the node's definition
                local texture = node_def.tiles[1]

                -- Create replacement entity (using "bam_mod:placeholder_entity")
                local entity = minetest.add_entity(node_pos, "bam_mod:placeholder_entity")
                if entity then
                    entity:set_properties({textures = {texture}})
                end

                -- Remove original node
                minetest.remove_node(node_pos)
            end
        end

        -- Find nearby nodes for item drop
        local nodes_for_drop = minetest.find_nodes_in_area(
            {x = pos.x - drop_radius, y = pos.y - drop_radius, z = pos.z - drop_radius},
            {x = pos.x + drop_radius, y = pos.y + drop_radius, z = pos.z + drop_radius},
            {
                "group:stone",
                "group:dirt",
                -- Add more groups as necessary (excluding "air")
            }
        )

        for _, node_pos in ipairs(nodes_for_drop) do
            local node_name = minetest.get_node(node_pos).name
            local node_def = minetest.registered_nodes[node_name]
            if node_def and node_def.tiles and node_name ~= "air" then
                -- Drop the original node as an item
                minetest.add_item(node_pos, node_name)
            end
        end
    end,
})



















-----------responce test---- do not spawn!











-- Define the custom entity (replacing nodes)
minetest.register_entity("bam_mod:placeholder_entity", {
    initial_properties = {
        physical = false,
        collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
        visual = "cube",
        textures = {"placeholder.png"}, -- Replace with your texture
    },

    on_step = function(self, dtime)
        local player = minetest.get_objects_inside_radius(self.object:get_pos(), 10) -- Adjust the radius as needed
        for _, obj in ipairs(player) do
            if obj:is_player() then
                local player_pos = obj:get_pos()
                local self_pos = self.object:get_pos()
                local velocity = vector.direction(self_pos, player_pos)
                self.object:set_velocity(velocity)
                break -- Only target the nearest player
            end
        end
    end,

})


-- Define the black hole entity
minetest.register_entity("bam_mod:black_hole", {
    initial_properties = {
        physical = true,
        collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
        visual = "cube",
        textures = {"blackhole.png"}, -- Replace with your texture
    },

    on_step = function(self, dtime)
        local pos = self.object:get_pos() -- Get the black hole's position

        -- Replace nearby nodes with your specific entity
        local radius = 5
        local nearby_nodes = minetest.find_nodes_in_area(
            {x = pos.x - radius, y = pos.y - radius, z = pos.z - radius},
            {x = pos.x + radius, y = pos.y + radius, z = pos.z + radius},
            {"group:stone"} -- Replace with the group of nodes you want to replace
        )

        for _, node_pos in ipairs(nearby_nodes) do
            local original_node = minetest.get_node(node_pos)

            -- Remove the existing node
            minetest.remove_node(node_pos)

            -- Add the custom entity
            local entity = minetest.add_entity(node_pos, "bam_mod:placeholder_entity")
            entity:set_nametag_attributes({
                text = original_node.name,
                color = "white",
                scale = {x = 0.01, y = 0.01},
            })

            -- Calculate force direction toward the black hole
            local entity_pos = entity:get_pos()
            local force_direction = vector.direction(entity_pos, pos)
            local force_magnitude = 10

            -- Apply the force
            entity:set_velocity(force_direction * force_magnitude)
        end

        -- Handle entities inside the black hole
        -- ...

        -- Replace with original node drops
        -- ...
    end,
})








-- Custom entity definition
local target_entity_name = "bam_mod:placeholder_entity"
local detection_radius = 1

minetest.register_globalstep(function(dtime)
    print("Globalstep executed!")
    for _, player in pairs(minetest.get_connected_players()) do
        local player_pos = player:get_pos()
        local closest_distance = detection_radius + 1
        local closest_player = nil
        local closest_entity = nil
        local closest_nametag = nil

        for _, entity in pairs(minetest.get_objects_inside_radius(player_pos, detection_radius)) do
            if entity:is_player() then
                goto continue
            end

            local entity_name = entity:get_luaentity().name
            local entity_nametag = entity:get_luaentity().nametag

            if entity_name == target_entity_name then
                if entity_nametag and entity_nametag ~= "" then
                    local entity_pos = entity:get_pos()
                    local distance = vector.distance(player_pos, entity_pos)

                    if distance < closest_distance then
                        closest_distance = distance
                        closest_player = player
                        closest_entity = entity
                        closest_nametag = entity_nametag
                    end
                else
                    -- If the entity has no nametag, delete it
                    entity:remove()
                end
            end

            ::continue::
        end

        if closest_player and closest_entity and closest_nametag then
            -- Debugging message: Print the nametag
            minetest.chat_send_player(closest_player:get_player_name(), "Found nametag: " .. closest_nametag)

            -- Give the item specified by the entity's nametag to the closest player's main inventory
            local item_stack = ItemStack(closest_nametag)
            local player_inv = closest_player:get_inventory()
            if player_inv:room_for_item("main", item_stack) then
                player_inv:add_item("main", item_stack)
            else
                minetest.chat_send_player(closest_player:get_player_name(), "Your inventory is full!")
            end

            -- Delete the entity
            closest_entity:remove()
        end
    end
end)























































----------------bam_mod:controllable_entity










local time_since_last_sound = 0

minetest.register_globalstep(function(dtime)
    time_since_last_sound = time_since_last_sound + dtime

    for _, player in ipairs(minetest.get_connected_players()) do
        local player_name = player:get_player_name()
        local controls = player:get_player_control()

        if controls.jump then
            local pos = player:get_pos()
            local objs = minetest.get_objects_inside_radius(pos, 1)
            for _, obj in ipairs(objs) do
                if not obj:is_player() then
                    local entity = obj:get_luaentity()
                    if entity and entity.name == "bam_mod:controllable_entity" then
                        local vel = obj:get_velocity()
                        vel.y = 10 -- Adjust the jump height as needed
                        obj:set_velocity(vel)

                        local yaw = obj:get_yaw()
                        local left_offset = {x = -1.5 * math.cos(yaw), y = 0, z = -1.5 * math.sin(yaw)}
                        local right_offset = {x = 1.5 * math.cos(yaw), y = 0, z = 1.5 * math.sin(yaw)}
                        local behind_offset = {x = 1.5 * math.sin(yaw), y = 0, z = -1.5 * math.cos(yaw)}

                        -- Add particle spawner 2 nodes to the left, 2 nodes behind
                        minetest.add_particlespawner({
                            amount = 80,
                            time = 0.5,
                            minpos = {x=pos.x + left_offset.x - 0 + behind_offset.x, y=pos.y + 8.5, z=pos.z + left_offset.z - 0 + behind_offset.z},
                            maxpos = {x=pos.x + left_offset.x + 0.5 + behind_offset.x, y=pos.y + 8.5, z=pos.z + left_offset.z + 0.5 + behind_offset.z},
                            minvel = {x=0, y=-19, z=0},
                            maxvel = {x=0, y=-29, z=0},
                            minacc = {x=0, y=0, z=0},
                            maxacc = {x=0, y=0, z=0},
                            minexptime = 0.1,
                            maxexptime = 0.5,
                            minsize = 2,
                            maxsize = 6,
                            collisiondetection = true,
                            texture = "thrust.png",
                        })

                        -- Add particle spawner 2 nodes to the right, 2 nodes behind
                        minetest.add_particlespawner({
                            amount = 80,
                            time = 0.5,
                            minpos = {x=pos.x + right_offset.x - 0 + behind_offset.x, y=pos.y + 8.5, z=pos.z + right_offset.z - 0 + behind_offset.z},
                            maxpos = {x=pos.x + right_offset.x + 0.5 + behind_offset.x, y=pos.y + 8.5, z=pos.z + right_offset.z + 0.5 + behind_offset.z},
                            minvel = {x=0, y=-19, z=0},
                            maxvel = {x=0, y=-29, z=0},
                            minacc = {x=0, y=0, z=0},
                            maxacc = {x=0, y=0, z=0},
                            minexptime = 0.1,
                            maxexptime = 0.5,
                            minsize = 2,
                            collisiondetection = true,
                            maxsize = 6,
                            texture = "thrust.png",
                        })

                        -- Play sound every 2 seconds
                        if time_since_last_sound >= 2 then
                            minetest.sound_play("bamthrusters", {
                                pos = pos,
                                gain = 1.0,
                                max_hear_distance = 10,
                            })
                            time_since_last_sound = 0
                        end
                    end
                end
            end
        end
    end
end)










minetest.register_node("bam_mod:portal", {
    description = "Forced TelePortal",
    tiles = {"icon_1.png", "icon_1.png", "icon_1.png"},
    groups = {cracky = 1, level = 2},
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        local player_name = clicker:get_player_name()
        local formspec = "size[8,9]" ..
                         "label[0,0;Select a player to teleport to:]"

        local players = minetest.get_connected_players()
        for i, player in ipairs(players) do
            local name = player:get_player_name()
            formspec = formspec .. "button_exit[0," .. (i * 1) .. ";8,1;player_" .. name .. ";" .. name .. "]"
        end

        minetest.show_formspec(player_name, "bam_mod:portal_formspec", formspec)
        clicker:get_meta():set_string("bam_mod:portal_pos", minetest.pos_to_string(pos))
    end,
})

local function remove_existing_portal(pos)
    local objs = minetest.get_objects_inside_radius({x = pos.x, y = pos.y + 2, z = pos.z}, 0.5)
    for _, obj in ipairs(objs) do
        if obj:get_luaentity() and obj:get_luaentity().name == "bam_mod:teleport_portal" then
            obj:remove()
        end
    end
end

minetest.register_on_player_receive_fields(function(player, formname, fields)
    if formname == "bam_mod:portal_formspec" then
        local pos_str = player:get_meta():get_string("bam_mod:portal_pos")
        local pos = minetest.string_to_pos(pos_str)
        if pos then
            for field, _ in pairs(fields) do
                if field:sub(1, 7) == "player_" then
                    local target_name = field:sub(8)
                    local target_player = minetest.get_player_by_name(target_name)
                    if target_player then
                        remove_existing_portal(pos)
                        -- Add the new entity above the selected player
                        local target_pos = target_player:get_pos()
                        minetest.add_entity({x = target_pos.x, y = target_pos.y + 3, z = target_pos.z}, "bam_mod:target_marker")

                        -- Delay the addition of the teleport portal by 4 seconds
                        minetest.after(4, function()
                            local entity = minetest.add_entity({x = pos.x, y = pos.y + 2, z = pos.z}, "bam_mod:teleport_portal")
                            if entity then
                                entity:set_nametag_attributes({color = "#FFFFFF", text = target_name})
                                entity:get_luaentity().nametag = target_name
                            end
                        end)

                        -- Add another separate entity 3 nodes above the node
                        minetest.add_entity({x = pos.x, y = pos.y + 2, z = pos.z}, "bam_mod:another_entity")
                    end
                    return true
                end
            end
        end
    end
end)







minetest.register_entity("bam_mod:target_marker", {
    initial_properties = {
        physical = false,
        visual_size = {x=2, y=2},

        collide_with_objects = false,
        collisionbox = {0, 0, 0, 0, 0, 0},
        visual = "sprite",
        textures = {"port.png"}, -- Change this to the desired texture
        nametag = "",
        nametag_color = "#FFFFFF",
    },

    on_step = function(self, dtime)
        local pos = self.object:get_pos()
        local objs = minetest.get_objects_inside_radius(pos, 2) -- 5 is the radius
        for _, obj in ipairs(objs) do
            if obj:is_player() then
                minetest.add_entity(pos, "bam_mod:dissapear_ent_poof")
                self.object:remove()
                break
            end
        end
    end,
})





local textures = {
    "default_wood.png",
    "default_stone.png",
    "default_brick.png",
    "default_glass.png"
}

minetest.register_entity("bam_mod:changing_entity_irrelevant", {
    initial_properties = {
        physical = true,
        collide_with_objects = false,
        collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
        visual = "cube",
        textures = {textures[1], textures[1], textures[1], textures[1], textures[1], textures[1]},
    },
    on_activate = function(self)
        self.texture_index = 1
        self.timer = 0
    end,
    on_step = function(self, dtime)
        self.timer = self.timer + dtime
        if self.timer >= 0.5 then
            self.timer = 0
            self.texture_index = self.texture_index % #textures + 1
            self.object:set_properties({
                textures = {textures[self.texture_index], textures[self.texture_index], textures[self.texture_index], textures[self.texture_index], textures[self.texture_index], textures[self.texture_index]}
            })
        end
    end,
})






local textures = {
    "port.png",
    "port.png",
    "port.png",
    "port.png",
    "port.png",
    "pop_2.png",
    "pop_3.png",
    "pop_3.png"
}

minetest.register_entity("bam_mod:dissapear_ent_poof", {
    initial_properties = {
        physical = true,
        collide_with_objects = false,
        collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
        visual = "sprite",
        textures = {textures[1], textures[1], textures[1], textures[1], textures[1], textures[1]},
    },
    on_activate = function(self)
        self.texture_index = 1
        self.timer = 0
    end,
    on_step = function(self, dtime)
        self.timer = self.timer + dtime
        if self.timer >= 0.5 then
            self.timer = 0
            self.texture_index = self.texture_index % #textures + 1
            if self.texture_index == 8 then
                self.object:remove()
            else
                self.object:set_properties({
                    textures = {textures[self.texture_index], textures[self.texture_index], textures[self.texture_index], textures[self.texture_index], textures[self.texture_index], textures[self.texture_index]}
                })
            end
        end
    end,
})







minetest.register_entity("bam_mod:another_entity", {
    initial_properties = {
        physical = false,
        visual_size = {x=2, y=2},
        collide_with_objects = false,
        collisionbox = {0, 0, 0, 0, 0, 0},
        visual = "sprite",
        textures = {"empty.png"}, -- Change this to the desired texture
        nametag = "",
        nametag_color = "#FFFFFF",
    },
    
    
    on_activate = function(self, staticdata, dtime_s)
        self.textures = {
            
            "pop_3.png", "pop_3.png", "pop_2.png", "port.png"
        }
        self.texture_index = 1
        self.timer = 0
    end,

    on_step = function(self, dtime)
        self.timer = self.timer + dtime
        if self.timer >= 1 then
            self.timer = 0
            self.texture_index = self.texture_index + 1
            if self.texture_index > #self.textures then
                self.object:remove() -- Remove the entity after the ninth texture
            else
                self.object:set_properties({
                    textures = {self.textures[self.texture_index]}
                })
            end
        end
    end,
})



minetest.register_entity("bam_mod:teleport_portal", {
    initial_properties = {
        physical = true,
        visual_size = {x=2, y=2},

        collide_with_objects = false,
        collisionbox = {0, 0, 0, 0, 0, 0},
        visual = "sprite",
        textures = {"port.png"}, -- Change this to the desired texture
        nametag = "",
        nametag_color = "#FFFFFF",
    },
    timer = 0,
    on_step = function(self, dtime)
        self.timer = self.timer + dtime
        if self.timer < 1 then
            return
        end

        local pos = self.object:get_pos()
        local objs = minetest.get_objects_inside_radius(pos, 2)
        for _, obj in ipairs(objs) do
            if obj:is_player() then
                local target_marker = nil
                local all_objs = minetest.get_objects_inside_radius({x = pos.x, y = pos.y, z = pos.z}, 100)
                for _, entity in ipairs(all_objs) do
                    if entity:get_luaentity() and entity:get_luaentity().name == "bam_mod:target_marker" then
                        target_marker = entity
                        break
                    end
                end

                if target_marker then
                    local target_pos = target_marker:get_pos()
                    obj:set_pos(target_pos)
                    self.object:remove()
                end
            end
        end
    end,
})


















---------------------------body parts idk



------circut
minetest.register_craftitem("bam_mod:bam_thrust_side", {
    description = "Bam Thruster Side",
    inventory_image = "thruster_2part.png",
})



minetest.register_craft({
    output = "bam_mod:bam_thrust_side",
    recipe = {
        {"", "bam_mod:bam_blackmetal", ""},
        {"bam_mod:bam_blackmetal", "bam_mod:bam_powercone", "bam_mod:bam_blackmetal"},
        {"bam_mod:bam_blackmetal", "default:glass", "bam_mod:bam_blackmetal"},
    },
})










------circut
minetest.register_craftitem("bam_mod:bam_hip", {
    description = "Bam Lower Body",
    inventory_image = "bam_low_joint.png",
})



minetest.register_craft({
    output = "bam_mod:bam_hip",
    recipe = {
        {"bam_mod:bam_blackmetal", "bam_mod:bam_powercone", "bam_mod:bam_blackmetal"},
        {"bam_mod:bam_circut", "bam_mod:bam_blackmetal", "bam_mod:bam_circut"},
        {"bam_mod:bam_blackmetal", "", "bam_mod:bam_blackmetal"},
    },
})











------circut
minetest.register_craftitem("bam_mod:bam_thrust_main", {
    description = "Bam Thruster Main",
    inventory_image = "bam_thrust_main.png",
})



minetest.register_craft({
    output = "bam_mod:bam_thrust_main",
    recipe = {
        {"bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal"},
        {"bam_mod:bam_blackmetal", "bam_mod:bam_powercone", "bam_mod:bam_blackmetal"},
        {"bam_mod:bam_blackmetal", "default:glass", "bam_mod:bam_blackmetal"},
    },
})

















------circut
minetest.register_craftitem("bam_mod:bam_thrust_whole", {
    description = "Bam Thruster Whole",
    inventory_image = "bam_thruster_whole.png",
})



minetest.register_craft({
    output = "bam_mod:bam_thrust_whole",
    recipe = {
        {"", "", ""},
        {"bam_mod:bam_thrust_side", "bam_mod:bam_thrust_main", "bam_mod:bam_thrust_side"},
        {"", "", ""},
    },
})











------circut
minetest.register_craftitem("bam_mod:bam_circut", {
    description = "Bam Basic Motion Bourd",
    inventory_image = "bam_autowalk_circutry.png",
})



minetest.register_craft({
    output = "bam_mod:bam_circut",
    recipe = {
        {"default:glass", "bam_mod:bam_blackmetal", "default:glass"},
        {"bam_mod:bam_blackmetal", "bam_mod:bam_powercone", "bam_mod:bam_blackmetal"},
        {"default:glass", "bam_mod:bam_blackmetal", "default:glass"},
    },
})









minetest.register_craftitem("bam_mod:bam_facial_screen_control_board", {
    description = "Bam Facial Screen Board",
    inventory_image = "facial_chip.png",
})



minetest.register_craft({
    output = "bam_mod:bam_facial_screen_control_board",
    recipe = {
        {"default:glass", "bam_mod:bam_powercone", "default:glass"},
        {"bam_mod:bam_powercone", "bam_mod:bam_circut", "bam_mod:bam_powercone"},
        {"default:glass", "bam_mod:bam_powercone", "default:glass"},
    },
})









minetest.register_craftitem("bam_mod:bam_facial_screen", {
    description = "Bam Facial Screen",
    inventory_image = "screen.png",
})



minetest.register_craft({
    output = "bam_mod:bam_facial_screen",
    recipe = {
        {"bam_mod:bam_rod", "dye:black", "bam_mod:bam_rod"},
        {"bam_mod:bam_rod", "bam_mod:bam_powercone", "bam_mod:bam_rod"},
        {"bam_mod:bam_rod", "default:glass", "bam_mod:bam_facial_screen_control_board"},
    },
})








----------beams

minetest.register_craftitem("bam_mod:bam_rhotational_socket", {
    description = "Bam Rhotational Socket",
    inventory_image = "bam_rhotational_socket.png",
})



minetest.register_craft({
    output = "bam_mod:bam_rhotational_socket",
    recipe = {
        {"", "bam_mod:bam_rod", ""},
        {"bam_mod:bam_rod", "bam_mod:bam_joint_ball", "bam_mod:bam_rod"},
        {"", "bam_mod:bam_rod", ""},
    },
})












----------torso

minetest.register_craftitem("bam_mod:bam_complete_torso", {
    description = "Bam Complete Torso",
    inventory_image = "bam_torso.png",
})



minetest.register_craft({
    output = "bam_mod:bam_complete_torso",
    recipe = {
        {"", "", ""},
        {"", "bam_mod:bam_torso", ""},
        {"", "bam_mod:bam_hip", ""},
    },
})











----------torso part

minetest.register_craftitem("bam_mod:bam_torso", {
    description = "Bam Complete Torso",
    inventory_image = "bam_torso_upper_half.png",
})



minetest.register_craft({
    output = "bam_mod:bam_torso",
    recipe = {
        {"bam_mod:bam_circut", "bam_mod:bam_blackmetal", "bam_mod:bam_circut"},
        {"bam_mod:bam_rod", "bam_mod:bam_facial_screen", "bam_mod:bam_rod"},
        {"", "bam_mod:bam_rhotational_socket", "bam_mod:bam_control"},
    },
})







----------control_pad

minetest.register_craftitem("bam_mod:bam_control", {
    description = "Bam Controlpad",
    inventory_image = "bam_contpd.png",
})



minetest.register_craft({
    output = "bam_mod:bam_control",
    recipe = {
        {"bam_mod:bam_fire_bourd", "bam_mod:bam_circut", "bam_mod:bam_levers"},
        {"bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal"},
        {"", "", ""},
    },
})











----------beams

minetest.register_craftitem("bam_mod:bam_rod", {
    description = "Bam Rod",
    inventory_image = "bam_bar.png",
})



minetest.register_craft({
    output = "bam_mod:bam_rod",
    recipe = {
        {"", "", ""},
        {"", "bam_mod:bam_blackmetal", ""},
        {"", "bam_mod:bam_blackmetal", ""},
    },
})









----------jsticks

minetest.register_craftitem("bam_mod:bam_levers", {
    description = "Bam Levers",
    inventory_image = "bam_levers.png",
})



minetest.register_craft({
    output = "bam_mod:bam_levers",
    recipe = {
        {"", "", ""},
        {"", "bam_mod:bam_rod", ""},
        {"", "", ""},
    },
})










----whole hamer arm

minetest.register_craftitem("bam_mod:bam_other_arm", {
    description = "Bam Complete Arm",
    inventory_image = "bam_other_arm.png",
})



minetest.register_craft({
    output = "bam_mod:bam_other_arm",
    recipe = {
        {"", "", ""},
        {"", "bam_mod:bam_arm_upper", ""},
        {"", "bam_mod:bam_lower_other_arm", ""},
    },
})











----whole hamer arm

minetest.register_craftitem("bam_mod:bam_lower_other_arm", {
    description = "Bam lower Arm",
    inventory_image = "bam_arm_lower_norm.png",
})



minetest.register_craft({
    output = "bam_mod:bam_lower_other_arm",
    recipe = {
        {"", "bam_mod:bam_beam", "bam_mod:bam_circut"},
        {"bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal"},
        {"bam_mod:bam_blackmetal", "bam_mod:bam_powercone", "bam_mod:bam_blackmetal"},
    },
})












----whole hamer arm

minetest.register_craftitem("bam_mod:bam_hammer_arm", {
    description = "Bam Complete Arm Hammer",
    inventory_image = "bam_hamarm.png",
})



minetest.register_craft({
    output = "bam_mod:bam_hammer_arm",
    recipe = {
        {"", "", ""},
        {"", "bam_mod:bam_arm_upper", ""},
        {"", "bam_mod:bam_arm_lower_hammer", ""},
    },
})







---------upper arms


minetest.register_craftitem("bam_mod:bam_arm_upper", {
    description = "Bam Arm Upper",
    inventory_image = "bam_arm_joint.png",
})



minetest.register_craft({
    output = "bam_mod:bam_arm_upper",
    recipe = {
        {"bam_mod:bam_blackmetal", "bam_mod:bam_joint_ball", "bam_mod:bam_blackmetal"},
        {"bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal"},
        {"bam_mod:bam_circut", "bam_mod:bam_blackmetal", ""},
    },
})





------------long_metal_beam_with_supports



minetest.register_craftitem("bam_mod:bam_beam", {
    description = "Bam Joint Beam",
    inventory_image = "bam_beam.png",
})



minetest.register_craft({
    output = "bam_mod:bam_beam",
    recipe = {
        {"", "bam_mod:bam_joint_ball", "bam_mod:bam_circut"},
        {"", "bam_mod:bam_blackmetal", ""},
        {"", "bam_mod:bam_joint_ball", "bam_mod:bam_circut"},
    },
})











minetest.register_craftitem("bam_mod:bam_arm_lower_hammer", {
    description = "Bam Arm Lower Hammer",
    inventory_image = "bam_lowerarm_hammer.png",
})



minetest.register_craft({
    output = "bam_mod:bam_arm_lower_hammer",
    recipe = {
        {"", "bam_mod:bam_beam", ""},
        {"bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal"},
        {"bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal"},
    },
})








------circut_2
minetest.register_craftitem("bam_mod:bam_fire_bourd", {
    description = "Bam Lazar Blast Control Bourd",
    inventory_image = "bam_hostile_circutry.png",
})



minetest.register_craft({
    output = "bam_mod:bam_fire_bourd",
    recipe = {
        {"default:gold_ingot", "bam_mod:bam_powercone", "default:gold_ingot"},
        {"bam_mod:bam_powercone", "bam_mod:bam_circut", "bam_mod:bam_powercone"},
        {"default:gold_ingot", "bam_mod:bam_powercone", "default:gold_ingot"},
    },
})


















------cone
minetest.register_craftitem("bam_mod:bam_powercone", {
    description = "Bam Powercone",
    inventory_image = "bam_powercone.png",
})



minetest.register_craft({
    output = "bam_mod:bam_powercone",
    recipe = {
        {"dye:blue", "bam_mod:bam_blackmetal", "dye:blue"},
        {"default:mese", "default:diamondblock", "default:mese"},
        {"default:mese", "default:glass", "default:mese"},
    },
})










------jointball
minetest.register_craftitem("bam_mod:bam_joint_ball", {
    description = "Bam Joint Ball",
    inventory_image = "bam_joint_ball.png",
})



minetest.register_craft({
    output = "bam_mod:bam_joint_ball",
    recipe = {
        {"bam_mod:bam_diamond_metal", "bam_mod:bam_blackmetal", "bam_mod:bam_diamond_metal"},
        {"bam_mod:bam_blackmetal", "default:diamondblock", "bam_mod:bam_blackmetal"},
        {"bam_mod:bam_diamond_metal", "bam_mod:bam_blackmetal", "bam_mod:bam_diamond_metal"},
    },
})










minetest.register_craftitem("bam_mod:bam_leg_upper", {
    description = "Bam Leg Upper",
    inventory_image = "bam_leg_joint.png",
})



minetest.register_craft({
    output = "bam_mod:bam_leg_upper",
    recipe = {
        {"", "bam_mod:bam_joint_ball", "bam_mod:bam_circut"},
        {"bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal"},
        {"bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal"},
    },
})









minetest.register_craftitem("bam_mod:bam_diamond_metal", {
    description = "Bam Diamondmetal",
    inventory_image = "metblue.png",
})



minetest.register_craft({
    output = "bam_mod:bam_diamond_metal",
    recipe = {
        {"default:steelblock", "default:steelblock", "default:steelblock"},
        {"default:steelblock", "default:diamondblock", "default:steelblock"},
        {"default:steelblock", "default:steelblock", "default:steelblock"},
    },
})









minetest.register_craftitem("bam_mod:bam_leg", {
    description = "Bam Leg",
    inventory_image = "bam_leg.png",
})



minetest.register_craft({
    output = "bam_mod:bam_leg",
    recipe = {
        {"default:steel_ingot", "bam_mod:bam_circut", "default:steel_ingot"},
        {"default:steel_ingot", "bam_mod:bam_beam", "default:steel_ingot"},
        {"bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal"},
    },
})















minetest.register_craftitem("bam_mod:bam_complete_leg", {
    description = "Bam Complete Leg",
    inventory_image = "bam_leg_c.png",
})



minetest.register_craft({
    output = "bam_mod:bam_complete_leg",
    recipe = {
        {"", "", ""},
        {"", "bam_mod:bam_leg_upper", ""},
        {"", "bam_mod:bam_leg", ""},
    },
})













minetest.register_craftitem("bam_mod:bam_blackmetal", {
    description = "Bam Blackmetal",
    inventory_image = "bam_blackmetal.png",
})



minetest.register_craft({
    output = "bam_mod:bam_blackmetal",
    recipe = {
        {"dye:black", "dye:black", "dye:black"},
        {"dye:black", "bam_mod:bam_diamond_metal", "dye:black"},
        {"dye:black", "dye:black", "dye:black"},
    },
})




minetest.register_craft({
    output = "bam_mod:bam_head",
    recipe = {
        {"", "bam_mod:bam_blackmetal", "bam_mod:bam_blackmetal"},
        {"bam_mod:bam_blackmetal", "bam_mod:bam_fire_bourd", "bam_mod:bam_powercone"},
        {"bam_mod:bam_blackmetal", "bam_mod:bam_circut", "bam_mod:bam_blackmetal"},
    },
})


minetest.register_craftitem("bam_mod:bam_head", {
    description = "Bam Head",
    inventory_image = "bam_head.png",
})








minetest.register_craft({
    output = "bam_mod:mech_spawner",
    recipe = {
        {"", "bam_mod:bam_head", ""},
        {"bam_mod:bam_hammer_arm", "bam_mod:bam_complete_torso", "bam_mod:bam_other_arm"},
        {"bam_mod:bam_complete_leg", "bam_mod:bam_thrust_whole", "bam_mod:bam_complete_leg"},
    },
})





---bam_mod:controllable_entity




minetest.register_craftitem("bam_mod:bam_skin", {
    description = "Bam Custom Mech hold this item in hand and enter the set_mymech (texture) command to use, /help for more info",
    inventory_image = "almondonium_armor_2.png",
})




minetest.register_craft({
    output = "bam_mod:bam_skin",
    recipe = {
        {"", "", ""},
        {"", "bam_mod:bam_powercone", "bam_mod:bam_blackmetal"},
        {"", "", ""},
    },
})




minetest.register_chatcommand("set_mymech", {
    params = "<color>",
    description = "Set the color of your mech",
    func = function(name, param)
        local player = minetest.get_player_by_name(name)
        if player and player:get_wielded_item():get_name() == "bam_mod:bam_skin" then
            local color = param
            local valid_colors = {"red", "orange", "yellow", "green", "blue", "purple", "fire", "red_tapes", "orange_tapes", "yellow_tapes", "green_tapes", "blue_tapes", "purple_tapes", "eye_red", "eye_orange", "eye_yellow", "eye_green", "eye_blue", "eye_purple", "happy", "fu", "bru", "love", "target", "ko", "face1", "face2", "noface"} -- Updated list of valid colors
            local function is_valid_color(color)
                for _, v in ipairs(valid_colors) do
                    if v == color then
                        return true
                    end
                end
                return false
            end
            if color and is_valid_color(color) then
                local pos = player:get_pos()
                local radius = 1 -- Define the radius
                local entities = minetest.get_objects_inside_radius(pos, radius)
                for _, entity in ipairs(entities) do
                    if entity:get_luaentity() and entity:get_luaentity().name == "bam_mod:controllable_entity" then
                        local current_textures = entity:get_properties().textures
                        local base_texture = current_textures[1]
                        local overlayed_texture = base_texture
                        if color == "empty" then
                            -- Remove all overlays
                            overlayed_texture = base_texture
                        else
                            -- Add new overlay
                            local new_texture = "bam_" .. color .. ".png"
                            overlayed_texture = base_texture .. "^" .. new_texture
                        end
                        entity:set_properties({
                            textures = {overlayed_texture}
                        })
                    end
                end
                return true, "Mech color set to " .. color
            else
                return false, "Invalid color parameter"
            end
        else
            return false, "You must be holding the overlay item to use this command"
        end
    end,
})



















------jointball
minetest.register_craftitem("bam_mod:bam_lazar_fuel", {
    description = "Bam Lazar Power crystal",
    inventory_image = "bam_ammo.png",
})



minetest.register_craft({
    output = "bam_mod:bam_lazar_fuel 10",
    recipe = {
        {"dye:blue", "bam_mod:bam_powercone", "dye:blue"},
        {"dye:blue", "bam_mod:bam_diamond_metal", "dye:blue"},
        {"dye:black", "dye:black", "dye:black"},
    },
})
