
----------------------------basic_parasite:deadly_cyringe------------------------infectious disease cyringe




-- Define a list of textures
local overlay_texture_list = {
    "dead_blood_overlay_player_04.png",
    "dead_blood_overlay_player_04.png",
    "dead_blood_overlay_player_04.png",
    "dead_blood_overlay_player_04.png",
    "dead_blood_overlay_player_04.png",
    "dead_blood_overlay_player_04.png",
    "dead_blood_overlay_player_03.png",
    "dead_blood_overlay_player_02.png",
    "dead_blood_overlay_player_01.png",

    "dead_blood_overlay_player_1.png",
    "dead_blood_overlay_player_2.png",
    "dead_blood_overlay_player_3.png",
    "dead_blood_overlay_player_4.png",
    "dead_blood_overlay_player_5.png",
    "dead_blood_overlay_player_6.png",
    "dead_blood_overlay_player_7.png",
    "dead_blood_overlay_player_8.png",
    "character34.png",


    -- Add more textures as needed
}

-- Register the sword as a tool
minetest.register_craftitem("basic_parasite:deadly_cyringe", {
    description = "An Injector, Containing a sample of the HCBP 18_01 parasite (Highly Contageous Blood parasite)",
    inventory_image = "parasite_injector.png",

    -- Handle the "punch" event
    on_use = function(itemstack, user, pointed_thing)
        tool_used = true
        minetest.after(6, function() -- Reset the tool_used flag after 2 seconds
            tool_used = false
        end)

        if pointed_thing.ref and pointed_thing.ref:is_player() then
            local player = pointed_thing.ref
            local player_name = player:get_player_name()
            
            -- Initialize the texture change timer and index
            player:get_meta():set_int("texture_index", 0)
            player:get_meta():set_float("texture_timer", 0)
            
            -- Start a repeating globalstep that changes the player's skin every 2 seconds
            minetest.register_globalstep(function(dtime)
                -- Check if the player is still online
                local player = minetest.get_player_by_name(player_name)
                if not player then
                    return
                end
                
                -- Update the timer
                local timer = player:get_meta():get_float("texture_timer") + dtime
                if timer >= 2 then
                    -- Reset the timer
                    player:get_meta():set_float("texture_timer", timer - 2)
                    
                    -- Get the current texture index
                    local texture_index = player:get_meta():get_int("texture_index") + 1
                    if texture_index > #overlay_texture_list then
                        -- After the last texture, store the player's current texture
                        local player_texture = player:get_properties().textures[1]
                        
                        -- Replace the player with an entity
                        local pos = player:get_pos()
                        minetest.kick_player(player_name, "You Have Lost All of your Humanity and Conciousness, You Are Not In Control Anymore. Your Body Belongs To The Parisite Now....")
                        
                        -- Create the entity with the player's last texture and apply the player's name as the nametag
                        local entity = minetest.add_entity(pos, "basic_parasite:entity_name")
                        entity:set_properties({
                            textures = {player_texture},
                            nametag = player_name, -- Apply the player's name as the nametag
                            -- Set other properties as needed
                        })
                        
                        -- Stop the globalstep for this player
                        return true
                    else
                        -- Retrieve the player's current skin texture
                        local current_texture = player:get_properties().textures[1]
                        -- Overlay the new texture onto the player's current skin
                        local new_texture = current_texture .. "^" .. overlay_texture_list[texture_index]
                        player:set_properties({textures = {new_texture}})
                        player:get_meta():set_int("texture_index", texture_index)
                    end
                else
                    -- Save the updated timer
                    player:get_meta():set_float("texture_timer", timer)
                end
            end)
        end
        return itemstack
    end,
})





-- Register the globalstep function
minetest.register_globalstep(function(dtime)
    if tool_used then -- Check if the tool was used recently
        for _, player in ipairs(minetest.get_connected_players()) do
            local pos = player:get_pos()
            local radius = 10 -- Define the radius within which to check for the entity
            local entities = minetest.get_objects_inside_radius(pos, radius)

            for _, entity in ipairs(entities) do
                if entity:is_player() == false and entity:get_luaentity().name == "basic_parasite:entity_chaser" then
                    -- Perform the action as if the tool was used on the player
                    -- This could be anything from damaging the player, healing, etc.
                    player:set_hp(player:get_hp() - 6) -- Damage the player
                end
            end
        end
    end
end)


minetest.register_entity("basic_parasite:entity_name", {
    -- Entity properties
    initial_properties = {
        physical = true,
    stepheight = 1.1, -- allows the entity to step up 1.1 nodes high

        collide_with_objects = true,
	collisionbox = {-0.4,-0.0,-0.4, 0.4,1.7,0.4},

        visual = "mesh",
        mesh = "syringemonster.obj", -- Replace with your model file
        textures = {"character2.png"}, -- Replace with your texture file
        visual_size = {x=17, y=17},
        -- Other properties like HP, etc.
    },


    -- On each server step, this function will be called
    on_step = function(self, dtime)
        self.object:set_acceleration({x=0, y=-9.81, z=0})
        -- Define the radius within which the entity should detect the player
        local radius = 50

        -- Get the entity's current position
        local pos = self.object:get_pos()

        -- Get all objects within the specified radius
        local objects = minetest.get_objects_inside_radius(pos, radius)

        -- Iterate through the objects to find players
        for _, obj in ipairs(objects) do
            if obj:is_player() then
                -- Get the player's position
                local player_pos = obj:get_pos()

                -- Calculate the direction vector from the entity to the player
                local dir = vector.direction(pos, player_pos)

                -- Set the entity's yaw to face the player
                self.object:set_yaw(minetest.dir_to_yaw(dir))
            end
        end
    end,

    -- More functions and definitions as needed
})







-- Define the radius within which to check for the entity
local check_radius = 50

-- Define the specific entity type to check for
local specific_entity = "basic_parasite:entity_chaser"

-- Define the stopping distance (in nodes)
local stopping_distance = 1.3

-- Register the globalstep
minetest.register_globalstep(function(dtime)
    -- Iterate over all connected players
    for _, player in ipairs(minetest.get_connected_players()) do
        local player_pos = player:get_pos()
        local player_name = player:get_player_name()

        -- Get all entities within the radius of the player
        local entities = minetest.get_objects_inside_radius(player_pos, check_radius)

        -- Iterate through the entities to find the specific one
        for _, entity in ipairs(entities) do
            if entity:get_luaentity() and entity:get_luaentity().name == specific_entity then
                -- Calculate the distance to the player
                local distance = vector.distance(entity:get_pos(), player_pos)

                -- Check if the entity is further away than the stopping distance
                if distance > stopping_distance then
                    -- Calculate the direction vector from the entity to the player
                    local dir_to_player = vector.direction(entity:get_pos(), player_pos)
                    dir_to_player.y = 0 -- This line ensures the entity moves only diagonally, not up

                    -- Push the entity towards the player
                    entity:set_velocity(vector.multiply(dir_to_player, 3.8)) -- Adjust the speed as necessary
                else
                    -- If within stopping distance, stop the entity's movement
                    entity:set_velocity({x=0, y=0, z=0})
                end
            end
        end
    end
end)


-----basic_parasite:entity_name-----basic_parasite:entity_chaser--

-- Define a list of models
local model_list = {
    "syringemonster_simple_formation_1.obj",
    "syringemonster_simple_formation_2.obj",
    "syringemonster_simple_formation_3.obj",
    "syringemonster_simple_formation_4.obj",
    "syringemonster_simple_formation_5.obj",
    "syringemonster_simple_formation_6.obj",
    "syringemonster_simple_formation_7.obj",
    "syringemonster_simple_formation_8.obj",
    "syringemonster_simple_formation_9.obj",
    "syringemonster_simple_formation_10.obj",
    "syringemonster_simple_formation_11.obj",
    "syringemonster_simple_formation_12.obj",
    "syringemonster_simple_formation_13.obj",
    "syringemonster_simple_formation_14.obj",
    "syringemonster_simple_formation_15.obj",
    "syringemonster_simple_formation_16.obj",
    "syringemonster_simple_formation_17.obj",
    "syringemonster_simple_formation_18.obj",
    "syringemonster_simple_formation_19.obj",
    "syringemonster_simple_formation_20.obj",
    "syringemonster_simple_formation_21.obj",
    "syringemonster_simple_formation_22.obj",
    "syringemonster_simple_formation_23.obj",
    "syringemonster_simple_formation_24.obj",
    "syringemonster_simple_formation_25.obj",
    "syringemonster_simple_formation_26.obj",
    "syringemonster_simple_formation_27.obj",
    "syringemonster_simple_formation_28.obj",
    "syringemonster_simple_formation_29.obj",
    "syringemonster_simple_formation_30.obj",
    "syringemonster_simple_formation_31.obj",
    "syringemonster_simple_formation_32.obj",
    "syringemonster_simple_formation_33.obj",
    "syringemonster_simple_formation_34.obj",
    "syringemonster_simple_formation_35.obj",
    "syringemonster_simple_formation_36.obj",
    "syringemonster_simple_formation_37.obj",
    "syringemonster_simple_formation_38.obj",
    "syringemonster_simple_formation_39.obj",
    "syringemonster_simple_formation_40.obj",
    "syringemonster_simple_formation_41.obj",
    "syringemonster_simple_formation_42.obj",
    "syringemonster_simple_formation_43.obj",
    "syringemonster_simple_formation_44.obj",
    "syringemonster_simple_formation_45.obj",
    "syringemonster_simple_formation_46.obj",
    "syringemonster_simple_formation_47.obj",



















    -- Add more models as needed
}

-- Set the interval for changing models (in seconds)
local change_interval = 0.3

-- Initialize a timer
local timer = 0



minetest.register_globalstep(function(dtime)
    timer = timer + dtime
    if timer >= change_interval then
        -- Reset the timer
        timer = timer - change_interval
        
        -- Iterate through all entities of a certain type
        for _, entity in pairs(minetest.luaentities) do
            if entity and entity.name == "basic_parasite:entity_name" then
                -- Get the current model index
                local model_index = entity.model_index or 1
                
                -- Check if the current model is the last in the list
                if model_index == #model_list then
                    -- Get the entity's position, texture, and nametag safely
                    local pos = entity.object and entity.object:get_pos()
                    local texture = entity.object and entity.object:get_properties() and entity.object:get_properties().textures and entity.object:get_properties().textures[1]
                    local nametag = entity.object and entity.object:get_nametag_attributes() and entity.object:get_nametag_attributes().text
                    if pos and texture and nametag then
                        -- Remove the current entity
                        entity.object:remove()
                        -- Add the new entity with the same texture and nametag
                        local new_entity_ref = minetest.add_entity(vector.round(pos), "basic_parasite:entity_chaser")
                        if new_entity_ref then
                            -- Ensure the entity is fully initialized before setting properties
                            minetest.after(0, function()
                                new_entity_ref:set_properties({
                                    textures = {texture},
                                    nametag = nametag
                                })
                            end)
                        end
                    end
                    
                    -- No need to update the model index since the entity is replaced
                else
                    -- Update to the next model
                    model_index = model_index + 1
                    
                    -- Set the new model
                    if entity.object then
                        entity.object:set_properties({
                            mesh = model_list[model_index],
                        })
                    end
                    
                    -- Save the new model index
                    entity.model_index = model_index
                end
            end
        end
    end
end)



minetest.register_entity("basic_parasite:entity_chaser", {
    -- Entity properties
    initial_properties = {
        physical = true,
        stepheight = 3.3,
        collide_with_objects = true,
	collisionbox = {-0.4,-0.0,-0.4, 0.4,1.7,0.4},

        visual = "mesh",
        mesh = "syringemonster_simple_formation_47.obj", -- Replace with your model file
        textures = {"character2.png"}, -- Replace with your texture file
        visual_size = {x=17, y=17},
        -- Other properties like HP, etc.
    },


    -- On each server step, this function will be called
    on_step = function(self, dtime)

        self.object:set_acceleration({x=0, y=-480.81, z=0})
        -- Define the radius within which the entity should detect the player
        local radius = 50

        -- Get the entity's current position
        local pos = self.object:get_pos()

        -- Get all objects within the specified radius
        local objects = minetest.get_objects_inside_radius(pos, radius)

        -- Iterate through the objects to find players
        for _, obj in ipairs(objects) do
            if obj:is_player() then
                -- Get the player's position
                local player_pos = obj:get_pos()

                -- Calculate the direction vector from the entity to the player
                local dir = vector.direction(pos, player_pos)

                -- Set the entity's yaw to face the player
                self.object:set_yaw(minetest.dir_to_yaw(dir))
            end
        end
    end,

    -- More functions and definitions as needed
})





-- Table to keep track of entities, their models, and timers
local entity_models = {
    ["basic_parasite:entity_chaser"] = {
        current_index = 1,
        models = {
    "parisite_stomper.obj",
    "parisite_stomper_1.obj",
    "parisite_stomper_2.obj",
    "parisite_stomper_3.obj",
    "parisite_stomper_4.obj",
    "parisite_stomper_5.obj",
    "parisite_stomper_6.obj",
    "parisite_stomper_7.obj",
    "parisite_stomper_8.obj",
    "parisite_stomper_9.obj",
    "parisite_stomper_10.obj",
    "parisite_stomper_11.obj",
    "parisite_stomper_12.obj",
    "parisite_stomper_13.obj",
    "parisite_stomper_14.obj",
    "parisite_stomper_15.obj",
    "parisite_stomper_16.obj",





        },
        last_position = {x=0, y=0, z=0},
        timer = 2, -- Add a timer for each entity
        interval = 0.04 -- Interval in seconds for model change
    }
}

-- Function to get the next model in the list
local function get_next_model(entity)
    entity.current_index = (entity.current_index % #entity.models) + 1
    return entity.models[entity.current_index]
end

-- Define the specific velocity threshold
local specific_velocity = 2 -- Adjust this value to the desired velocity

-- Globalstep to check for entity position change and change models
minetest.register_globalstep(function(dtime)
    for _, obj in pairs(minetest.luaentities) do
        if obj and obj.name == "basic_parasite:entity_chaser" and obj.object then
            local entity_data = entity_models[obj.name]
            local velocity = obj.object:get_velocity() or {x=0, y=0, z=0}
            local speed = vector.length(velocity)

            -- Check if the entity's speed exceeds the specific velocity threshold
            if speed > specific_velocity then
                entity_data.timer = entity_data.timer + dtime
                if entity_data.timer >= entity_data.interval then
                    -- Interval has passed, update the model
                    local next_model = get_next_model(entity_data)
                    obj.object:set_properties({mesh = next_model})
                    entity_data.timer = 0 -- Reset the timer
                end
            end
        end
    end
end)





-------infection!----------------------------basic_parasite:deadly_cyringe------------------------basic_parasite:entity_chaser


-- Define a table to keep track of affected players and their damage timers
local affected_players = {}

-- Define the radius within which to check for the entity
local radius = 2

-- Define the specific entity to check for
local specific_entity = "basic_parasite:entity_chaser"

-- Define the damage interval in seconds
local damage_interval = 1 -- Change this to your desired interval

-- Define the on_use function logic
local function apply_on_use_effects(player)
    -- Logic from the provided on_use function
    -- Initialize the texture change timer and index
    player:get_meta():set_int("texture_index", 0)
    player:get_meta():set_float("texture_timer", 0)
    
    -- Start a repeating globalstep that changes the player's skin every 2 seconds
    minetest.register_globalstep(function(dtime)
        -- Check if the player is still online and has been affected
        local player = minetest.get_player_by_name(player:get_player_name())
        if not player or not affected_players[player:get_player_name()] then
            return
        end
        
        -- Update the timer
        local timer = player:get_meta():get_float("texture_timer") + dtime
        if timer >= 5 then
            -- Reset the timer
            player:get_meta():set_float("texture_timer", timer - 2)
            
            -- Get the current texture index
            local texture_index = player:get_meta():get_int("texture_index") + 1
            if texture_index > #overlay_texture_list then
                -- After the last texture, store the player's current texture
                local player_texture = player:get_properties().textures[1]
                
                -- Replace the player with an entity
                local pos = player:get_pos()
                minetest.kick_player(player:get_player_name(), "You Have Lost All of your Humanity and Conciousness, You Are Not In Control Anymore. Your Body Belongs To The Parisite Now....")
                
                -- Create the entity with the player's last texture and apply the player's name as the nametag
                local entity = minetest.add_entity(pos, "basic_parasite:entity_name")
                entity:set_properties({
                    textures = {player_texture},
                    nametag = player:get_player_name(), -- Apply the player's name as the nametag
                    -- Set other properties as needed
                })
                
                -- Mark the player as affected
                affected_players[player:get_player_name()] = {damage_timer = 0}
                
                -- Stop the globalstep for this player
                return true
            else
                -- Retrieve the player's current skin texture
                local current_texture = player:get_properties().textures[1]
                -- Overlay the new texture onto the player's current skin
                local new_texture = current_texture .. "^" .. overlay_texture_list[texture_index]
                player:set_properties({textures = {new_texture}})
                player:get_meta():set_int("texture_index", texture_index)
            end
        else
            -- Save the updated timer
            player:get_meta():set_float("texture_timer", timer)
        end
    end)
end

-- Register the globalstep function
minetest.register_globalstep(function(dtime)
    for _, player in ipairs(minetest.get_connected_players()) do
        local pos = player:get_pos()
        local entities = minetest.get_objects_inside_radius(pos, radius)

        for _, entity in ipairs(entities) do
            if entity:is_player() == false and entity:get_luaentity().name == specific_entity then
                local player_name = player:get_player_name()
                -- Check if the player has already been affected
                if not affected_players[player_name] then
                    -- Apply the initial effect to the player
                    apply_on_use_effects(player)
                    -- Initialize the player's damage timer
                    affected_players[player_name] = {damage_timer = 0}
                else
                    -- Update the player's damage timer
                    affected_players[player_name].damage_timer = affected_players[player_name].damage_timer + dtime
                    -- Check if the damage interval has passed
                    if affected_players[player_name].damage_timer >= damage_interval then
                        -- Reset the damage timer
                        affected_players[player_name].damage_timer = affected_players[player_name].damage_timer - damage_interval
                        -- Apply damage to the player
                        player:set_hp(player:get_hp() - 1)
                    end
                end
            end
        end
    end
end)


