
minetest.register_node("blackhole_containment:rickroll", {
    description = "Black Hole",
    walkable = false,
	damage_per_second = 2000,
    tiles = {{
    name = "netherite_block.png", -- replace with your texture file
    animation = {
        type = "vertical_frames",
        aspect_w = 16,
        aspect_h = 16,
        length = 1.0, -- adjust to control the speed of the animation
    },
}},
    paramtype = "light",
    sunlight_propagates = true,
    light_source = minetest.LIGHT_MAX, -- emit light
    groups = {cracky = 3, oddly_breakable_by_hand = 3},
    sounds = default.node_sound_glass_defaults(),
})

minetest.register_node("blackhole_containment:black_hole", {
    description = "Black Hole",
    drawtype = "airlike",
    walkable = false,
	damage_per_second = 2000,
    paramtype = "light",
    sunlight_propagates = true,
    groups = {cracky = 3, oddly_breakable_by_hand = 3},
    sounds = default.node_sound_glass_defaults(),
})


minetest.register_abm({
    nodenames = {"blackhole_containment:black_hole"},
    interval = 1,
    chance = 1,
    action = function(pos, node)
        -- Define the area around the black hole for all effects
        local min_pos = vector.subtract(pos, 15)  -- 15 is the radius for all effects
        local max_pos = vector.add(pos, 15)

        -- Get all the objects in the area
        -- ... (rest of the object handling code)

        -- Get all the nodes in the area
        local nodes = minetest.find_nodes_in_area(min_pos, max_pos, {"group:cracky", "group:crumbly", "group:choppy", "group:snappy"})

        -- Randomly make the nodes drop
        for _, node_pos in ipairs(nodes) do
            -- Ignore the black hole node itself
            if not vector.equals(node_pos, pos) then
                if math.random() < 0.1 then  -- 0.1 is the drop chance, adjust as needed
                    local node = minetest.get_node(node_pos)
                    local drop_item = minetest.get_node_drops(node.name, "")

                    -- Remove the node
                    minetest.remove_node(node_pos)

                    -- Add the drop item
                    for _, item in ipairs(drop_item) do
                        minetest.add_item(node_pos, item)
                    end

                    -- Add a particle spawner at the position of the removed node
                    minetest.add_particlespawner({
                        amount = 20, -- number of particles
                        time = 0.5, -- duration the spawner is active
                        minpos = node_pos,
                        maxpos = node_pos,
                        minvel = {x = 0, y = 3, z = 0},
                        maxvel = {x = 0, y = 3, z = 0},
                        minacc = {x = 0, y = -13, z = 0},
                        maxacc = {x = 0, y = -13, z = 0},
                        minexptime = 2,
                        maxexptime = 2,
                        minsize = 2,
                        maxsize = 2,
                        collisiondetection = false,
                        vertical = false,
                        texture = "default_item_smoke.png",
                    })
                end
            end
        end
    end,
})



minetest.register_node("blackhole_containment:black_hole_15", {
    description = "Black Hole",
    drawtype = "glasslike",
    walkable = false,
	damage_per_second = 2000,
    tiles = {"f_chair_1.png"}, -- replace with your black hole texture
    paramtype = "light",
    sunlight_propagates = true,
    light_source = minetest.LIGHT_MAX, -- emit light
    groups = {cracky = 3, not_in_creative_inventory = 1, oddly_breakable_by_hand = 3},
    sounds = default.node_sound_glass_defaults(),
})

minetest.register_node("blackhole_containment:button_of_death_unpressed", {
    description = "(Black Hole box) Disclaimer: do not activate unless you want absolute distruction of private property!",
    drawtype = "mesh",
    mesh = "black_hole_box.obj",
    tiles = {"blackhole_box.png"},
    groups = {cracky = 3},

    paramtype = "light",
    paramtype2 = "facedir",
    light_source = 30,

on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        -- Define the new position 15 nodes above the right-clicked node
        local new_pos = {x = pos.x, y = pos.y + 15, z = pos.z}

        -- Specify the name of the node you want to add
        local node_to_add = "blackhole_containment:black_hole"

        -- Check if the new position is within the world's limits
        if minetest.get_node_or_nil(new_pos) then
            -- Add the specific node at the new position
            minetest.set_node(new_pos, {name = node_to_add})
            -- Set the right-clicked node to the pressed button
            minetest.set_node(pos, {name = "blackhole_containment:button_of_death_half"})
		minetest.sound_play("box", { pos = pos }, true)


        else
            -- Optionally handle the case where the position is not valid (e.g., out of bounds)
            minetest.chat_send_player(clicker:get_player_name(), "The position is out of bounds or not loaded.")
        end
    end
})

minetest.register_node("blackhole_containment:button_of_death_half", {
    description = "(Black Hole box)_half",
    drawtype = "mesh",
    mesh = "black_hole_box_open_half.obj",
    tiles = {"blackhole_box.png"},
    groups = {unstoppable=1, not_in_creative_inventory = 1},

	pointable = false,


    paramtype = "light",
    paramtype2 = "facedir",
    light_source = 30,
})



local oxide_correspondences = {
	["blackhole_containment:button_of_death_half"] = "blackhole_containment:button_of_death_half_2",
}

minetest.register_abm({
	label = "Oxidation",
	nodenames = {"blackhole_containment:button_of_death_half"},
	neighbors = {"air"},
	interval = 1,
	chance = 1,
	catch_up = true,
	action = function(pos, node)
		node.name = oxide_correspondences[node.name]
		if node.name then
			minetest.set_node(pos, node)
minetest.sound_play("box", { pos = pos }, true)

		end
	end
})

minetest.register_node("blackhole_containment:button_of_death_half_2", {
    description = "(Black Hole box)_half_2",
    drawtype = "mesh",
    mesh = "black_hole_box_open_half_2.obj",
    tiles = {"blackhole_box.png"},
    groups = {unstoppable=1, not_in_creative_inventory = 1},

	pointable = false,


    paramtype = "light",
    paramtype2 = "facedir",
    light_source = 30,
})

local oxide_correspondences = {
	["blackhole_containment:button_of_death_half_2"] = "blackhole_containment:button_of_death_half_3",
}

minetest.register_abm({
	label = "Oxidation",
	nodenames = {"blackhole_containment:button_of_death_half_2"},
	neighbors = {"air"},
	interval = 1,
	chance = 1,
	catch_up = true,
	action = function(pos, node)
		node.name = oxide_correspondences[node.name]
		if node.name then
			minetest.set_node(pos, node)
minetest.sound_play("box", { pos = pos }, true)

		end
	end
})

minetest.register_node("blackhole_containment:button_of_death_half_3", {
    description = "(Black Hole box)_half_3",
    drawtype = "mesh",
    mesh = "black_hole_box_open_half_3.obj",
    tiles = {"blackhole_box.png"},
    groups = {unstoppable=1, not_in_creative_inventory = 1},

	pointable = false,


    paramtype = "light",
    paramtype2 = "facedir",
    light_source = 30,
})


local oxide_correspondences = {
	["blackhole_containment:button_of_death_half_3"] = "blackhole_containment:button_of_death_pressed",
}

minetest.register_abm({
	label = "Oxidation",
	nodenames = {"blackhole_containment:button_of_death_half_3"},
	neighbors = {"air"},
	interval = 1,
	chance = 1,
	catch_up = true,
	action = function(pos, node)
		node.name = oxide_correspondences[node.name]
		if node.name then
			minetest.set_node(pos, node)
		minetest.sound_play("box", { pos = pos }, true)


		end
	end
})



minetest.register_node("blackhole_containment:button_of_death_pressed", {
    description = "hat",
    drawtype = "mesh",
    mesh = "black_hole_box_open.obj",
    tiles = {"blackhole_box.png"},
    groups = {unstoppable=1, not_in_creative_inventory = 1},
    paramtype = "light",
    paramtype2 = "facedir",
        selection_box = {
	type = "fixed",
	fixed = {
		{-0.5000, 0.000, -0.5000, -0.4375, 0.5000, 0.5000},
		{0.4375, 0.000, -0.5000, 0.5000, 0.5000, 0.5000},
		{-0.5000, 0.000, 0.4375, 0.5000, 0.5000, 0.5000},
		{-0.5000, 0.000, -0.5000, 0.5000, 0.5000, -0.4375}
	},
},
        collision_box = {
	type = "fixed",
	fixed = {
		{-0.5000, 0.000, -0.5000, -0.4375, 0.5000, 0.5000},
		{0.4375, 0.000, -0.5000, 0.5000, 0.5000, 0.5000},
		{-0.5000, 0.000, 0.4375, 0.5000, 0.5000, 0.5000},
		{-0.5000, 0.000, -0.5000, 0.5000, 0.5000, -0.4375}
	},
},

    walkable = true,
damage_per_second = 100,
    light_source = 30,

})



minetest.register_on_punchnode(function(pos, node, puncher, pointed_thing)
    -- Check if the punched node is the specific node that triggers the action
    if node.name == "blackhole_containment:button_of_death_pressed" then
        -- Define the new position 14 nodes above the punched node
        local new_pos = {x = pos.x, y = pos.y + 15, z = pos.z}

        -- Specify the name of the node you want to add
        local node_to_add = "air"

        -- Check if the new position is within the world's limits
        if minetest.get_node_or_nil(new_pos) then
            -- Add the specific node at the new position
            minetest.set_node(new_pos, {name = node_to_add})
            -- Set the punched node to air
            minetest.set_node(pos, {name = "blackhole_containment:button_of_death_closing1"})
		minetest.sound_play("box", { pos = pos }, true)

        else
            -- Optionally handle the case where the position is not valid (e.g., out of bounds)
            minetest.chat_send_player(puncher:get_player_name(), "The position is out of bounds or not loaded.")
        end
    end
end)


minetest.register_abm({
    nodenames = {"blackhole_containment:button_of_death_pressed"},
    interval = 1,
    chance = 1,
    action = function(pos, node, active_object_count, active_object_count_wider)
        for _,obj in ipairs(minetest.get_objects_inside_radius(pos, 22)) do
            if obj:is_player() then
                -- Skip if the object is a player
            else
                -- Get the entity's current position
                local e_pos = obj:get_pos()

                -- Define the center point of the circle
                local center = {x = pos.x, y = pos.y, z = pos.z}

                -- Calculate the distance to the center
                local distance = math.sqrt((e_pos.x - center.x)^2 + (e_pos.z - center.z)^2)

                -- Calculate the angle and the new position with a larger increment for faster rotation
                local angle = math.atan2(e_pos.z - center.z, e_pos.x - center.x) + (math.pi / 30)  -- Increased angle increment
                local new_x = center.x + distance * math.cos(angle)
                local new_z = center.z + distance * math.sin(angle)

                -- Calculate the pull factor based on the distance to the center
                local pull_factor = 0.1  -- The pull factor is set to a small value for a slower pull

                -- Apply the pull factor to the new position
                new_x = new_x + pull_factor * (center.x - new_x)
                new_z = new_z + pull_factor * (center.z - new_z)

                -- Update the entity's position
                obj:set_pos({x = new_x, y = e_pos.y, z = new_z})
            end
        end
    end
})







-----------------closing prosedure











minetest.register_node("blackhole_containment:button_of_death_closing1", {
    description = "(Black Hole box)_half",
    drawtype = "mesh",
    mesh = "black_hole_box_open_half_3.obj",
    tiles = {"blackhole_box.png"},
    groups = {unstoppable=1, not_in_creative_inventory = 1},

	pointable = false,


    paramtype = "light",
    paramtype2 = "facedir",
    light_source = 30,
})

local oxide_correspondences = {
	["blackhole_containment:button_of_death_closing1"] = "blackhole_containment:button_of_death_closing2",
}

minetest.register_abm({
	label = "Oxidation",
	nodenames = {"blackhole_containment:button_of_death_closing1"},
	neighbors = {"air"},
	interval = 1,
	chance = 1,
	catch_up = true,
	action = function(pos, node)
		node.name = oxide_correspondences[node.name]
		if node.name then
			minetest.set_node(pos, node)
minetest.sound_play("box", { pos = pos }, true)

		end
	end
})

minetest.register_node("blackhole_containment:button_of_death_closing2", {
    description = "(Black Hole box)_half_2",
    drawtype = "mesh",
    mesh = "black_hole_box_open_half_2.obj",
    tiles = {"blackhole_box.png"},
    groups = {unstoppable=1, not_in_creative_inventory = 1},

	pointable = false,


    paramtype = "light",
    paramtype2 = "facedir",
    light_source = 30,
})



local oxide_correspondences = {
	["blackhole_containment:button_of_death_closing2"] = "blackhole_containment:button_of_death_closing3",
}

minetest.register_abm({
	label = "Oxidation",
	nodenames = {"blackhole_containment:button_of_death_closing2"},
	neighbors = {"air"},
	interval = 1,
	chance = 1,
	catch_up = true,
	action = function(pos, node)
		node.name = oxide_correspondences[node.name]
		if node.name then
			minetest.set_node(pos, node)
minetest.sound_play("box", { pos = pos }, true)

		end
	end
})

minetest.register_node("blackhole_containment:button_of_death_closing3", {
    description = "(Black Hole box)_half_3",
    drawtype = "mesh",
    mesh = "black_hole_box_open_half.obj",
    tiles = {"blackhole_box.png"},
    groups = {unstoppable=1, not_in_creative_inventory = 1},

	pointable = false,


    paramtype = "light",
    paramtype2 = "facedir",
    light_source = 30,
})

local oxide_correspondences = {
	["blackhole_containment:button_of_death_closing3"] = "blackhole_containment:button_of_death_unpressed",
}

minetest.register_abm({
	label = "Oxidation",
	nodenames = {"blackhole_containment:button_of_death_closing3"},
	neighbors = {"air"},
	interval = 1,
	chance = 1,
	catch_up = true,
	action = function(pos, node)
		node.name = oxide_correspondences[node.name]
		if node.name then
			minetest.set_node(pos, node)
minetest.sound_play("box", { pos = pos }, true)

		end
	end
})
