

-- Cooldown tracker for each player
local sound_cooldowns = {}

-- Players currently hearing the sound
local active_players = {}

-- Register globalstep
minetest.register_globalstep(function(dtime)
    -- Update cooldown timers
    for player_name, cooldown in pairs(sound_cooldowns) do
        sound_cooldowns[player_name] = math.max(0, cooldown - dtime)
    end

    -- Track players to stop sound if they leave the radius
    local players_in_radius = {}

    -- Get all connected players
    for _, player in ipairs(minetest.get_connected_players()) do
        local player_pos = player:get_pos()
        local player_name = player:get_player_name()
        local within_radius = false

        -- Check all entities of the specific type
        local entities = minetest.get_objects_inside_radius(player_pos, 6)
        for _, entity in ipairs(entities) do
            local lua_entity = entity:get_luaentity()
            if lua_entity and lua_entity.name == "poto_launcher:portal" then
                -- Player is within radius of the entity
                within_radius = true
                break
            end
        end

        if within_radius then
            -- Add player to the list of active players in radius
            players_in_radius[player_name] = true

            -- Play sound if cooldown allows
            if not sound_cooldowns[player_name] or sound_cooldowns[player_name] <= 0 then
                minetest.sound_play("smoothie", {
                    pos = player_pos,
                    max_hear_distance = 40,
                    gain = 1.0,
                })

                -- Set a cooldown for 2.8 seconds
                sound_cooldowns[player_name] = 2.8
            end
        end
    end

    -- Stop sound for players who have left the radius
    for player_name, _ in pairs(active_players) do
        if not players_in_radius[player_name] then
            -- Remove from active players
            active_players[player_name] = nil
        end
    end

    -- Update active players
    active_players = players_in_radius
end)








-- Cooldown tracker for each player
local sound_cooldowns = {}

-- Players currently hearing the sound
local active_players = {}

-- Register globalstep
minetest.register_globalstep(function(dtime)
    -- Update cooldown timers
    for player_name, cooldown in pairs(sound_cooldowns) do
        sound_cooldowns[player_name] = math.max(0, cooldown - dtime)
    end

    -- Track players to stop sound if they leave the radius
    local players_in_radius = {}

    -- Get all connected players
    for _, player in ipairs(minetest.get_connected_players()) do
        local player_pos = player:get_pos()
        local player_name = player:get_player_name()
        local within_radius = false

        -- Check all entities of the specific type
        local entities = minetest.get_objects_inside_radius(player_pos, 12)
        for _, entity in ipairs(entities) do
            local lua_entity = entity:get_luaentity()
            if lua_entity and lua_entity.name == "poto_launcher:potal_unstabel" then
                -- Player is within radius of the entity
                within_radius = true
                break
            end
        end

        if within_radius then
            -- Add player to the list of active players in radius
            players_in_radius[player_name] = true

            -- Play sound if cooldown allows
            if not sound_cooldowns[player_name] or sound_cooldowns[player_name] <= 0 then
                minetest.sound_play("potal_wawa", {
                    pos = player_pos,
                    max_hear_distance = 40,
                    gain = 1.0,
                })

                -- Set a cooldown for 7.5 seconds
                sound_cooldowns[player_name] = 7.5
            end
        end
    end

    -- Stop sound for players who have left the radius
    for player_name, _ in pairs(active_players) do
        if not players_in_radius[player_name] then
            -- Remove from active players
            active_players[player_name] = nil
        end
    end

    -- Update active players
    active_players = players_in_radius
end)





 -- poto_launcher:portal_projectile




minetest.register_globalstep(function(dtime)
    for _, obj in pairs(minetest.luaentities) do
        if obj and obj.name == "poto_launcher:portal_projectile" then
            local pos = obj.object:get_pos()
            if pos then
                -- Check nodes within radius
                local radius = 0.7
                local found_non_air_default_node = false
                for x = -radius, radius do
                    for y = -radius, radius do
                        for z = -radius, radius do
                            local node_pos = {
                                x = pos.x + x,
                                y = pos.y + y,
                                z = pos.z + z
                            }
                            local node = minetest.get_node(node_pos)
                            -- Check if the node is from "default", isn't air, and doesn't end with "grass_(number)"
                            if node 
                                and node.name:sub(1, 8) == "default:" 
                                and node.name ~= "default:air" 
                                and not string.match(node.name, "grass_%d+$") then
                                found_non_air_default_node = true
                                break
                            end
                        end
                        if found_non_air_default_node then break end
                    end
                    if found_non_air_default_node then break end
                end

                -- Replace entity if a valid non-air default node is found
                if found_non_air_default_node then
                    -- Add particle explosion at the portal location
                    minetest.add_particlespawner({
                        amount = 100,
                        time = 0.2,
                        minpos = vector.subtract(pos, 0.5),
                        maxpos = vector.add(pos, 0.5),
                        minvel = {x = -2, y = -2, z = -2},
                        maxvel = {x = 2, y = 2, z = 2},
                        minacc = {x = 0, y = 0, z = 0},
                        maxacc = {x = 0, y = 0, z = 0},
                        minexptime = 1,
                        maxexptime = 2,
                        minsize = 1,
                        maxsize = 3,
                        texture = "potal_tiny_particle.png", -- Replace with your particle texture
                        glow = 15,
                    })

                    -- Add the new portal
                    local new_portal = minetest.add_entity(pos, "poto_launcher:portal")
                    new_portal:get_luaentity().creation_time = minetest.get_us_time()

                    -- Play sound effect
                    minetest.sound_play("potal_bloop", {
                        pos = pos,
                        max_hear_distance = 40,
                        gain = 1.0,
                    })

                    -- Find all portals in the world
                    local all_objects = minetest.get_objects_inside_radius({x = 0, y = 0, z = 0}, 10000)
                    local portals = {}
                    for _, obj in ipairs(all_objects) do
                        local lua_entity = obj:get_luaentity()
                        if lua_entity and lua_entity.name == "poto_launcher:portal" then
                            table.insert(portals, obj)
                        end
                    end

                    -- Identify the newest portal (besides the current one)
                    local newest_portal = nil
                    local newest_time = 0
                    for _, portal in ipairs(portals) do
                        local lua_entity = portal:get_luaentity()
                        if lua_entity and lua_entity.creation_time and lua_entity.creation_time > newest_time and portal ~= new_portal then
                            newest_time = lua_entity.creation_time
                            newest_portal = portal
                        end
                    end

                    -- Remove all portals except the current one and the newest one
                    for _, portal in ipairs(portals) do
                        if portal ~= new_portal and portal ~= newest_portal then
                            portal:remove()
                        end
                    end

                    -- Remove the projectile
                    obj.object:remove()
                end
            end
        end
    end
end)









minetest.register_entity("poto_launcher:potal_unstabel", {
    initial_properties = {
        physical = true,
        collisionbox = {-1.2, -1.2, -1.2, 1.2, 1.2, 1.2},
        pointable = false, -- The entitiy cannot be right-clikced
        stepheight = 5, -- Allows it to step over obsticles up to 5 nudes high
        visual = "mesh", -- Use a custim mesh for rendring
        mesh = "potal.obj", -- Speccify your mesh fil
        visual_size = {x = 100, y = 100}, -- Adjust the size of the entitiy
        textures = {"potal_unstabel.png"}, -- Apply a custim unstabel teksture
        collide_with_objects = false,
        automatic_rotate = 3,
        static_save = false,
        glow = 30,
    },

    -- Variables to track particle motion
    ring_particles = {},

    on_activate = function(self)
        -- Initialize 20 rings with different heights, radii, and speeds
        self.ring_particles = {
            {angle = 0, radius = 3, height = 1.5, speed = 1.5},
            {angle = 0, radius = 2, height = 1.0, speed = 3.0},
            {angle = 0, radius = 3, height = 0.5, speed = 1.8},
            {angle = 0, radius = 2, height = 0.0, speed = 3.2},
            {angle = 0, radius = 3, height = -0.5, speed = 1.5},
            {angle = 0, radius = 2, height = -1.0, speed = 2.9},
            {angle = math.pi / 4, radius = 2.5, height = -1.5, speed = 1.7},
            {angle = math.pi / 2, radius = 3.5, height = 3.0, speed = 1.4},
            {angle = math.pi / 6, radius = 2.8, height = -3.0, speed = 3.0},
            {angle = -math.pi / 4, radius = 2.3, height = -3.5, speed = 2.1},
            {angle = 0, radius = 3.7, height = 2.5, speed = 1.6},
            {angle = math.pi / 3, radius = 2.9, height = 1.8, speed = 1.8},
            {angle = -math.pi / 3, radius = 2.1, height = -1.8, speed = 2.3},
            {angle = math.pi / 2, radius = 3.2, height = 0.0, speed = 1.7},
            {angle = math.pi / 5, radius = 3.3, height = 2.8, speed = 1.9}, -- New rings
            {angle = math.pi / 3.5, radius = 2.7, height = -2.8, speed = 3.1},
            {angle = 0, radius = 3.8, height = -3.0, speed = 1.5},
            {angle = math.pi / 2.5, radius = 2.4, height = 3.0, speed = 3.3},
            {angle = -math.pi / 3.5, radius = 2.6, height = -3.5, speed = 3.2},
            {angle = math.pi / 4.5, radius = 2.5, height = 0.0, speed = 2.4}
        }
    end,

    on_step = function(self, dtime)
        local pos = self.object:get_pos()
        if not pos then return end

        -- Define possible textures for bolts
        local bolt_textures = {
            "enargy_bolt_1.png",
            "enargy_bolt_2.png",
            "enargy_bolt_3.png",
            "enargy_bolt_4.png",
            "enargy_bolt_5.png"
        }

        -- Create sudden, erratic energy bolts
        if math.random() < 0.9 then -- 70% chance per step for more bolts
            minetest.add_particle({
                pos = {
                    x = pos.x + math.random(-4, 4),
                    y = pos.y + math.random(-4, 4),
                    z = pos.z + math.random(-4, 4)
                },
                velocity = {
                    x = math.random(-6, 6),
                    y = math.random(-6, 6),
                    z = math.random(-6, 6)
                },
                acceleration = {x = 0, y = 0, z = 0},
                expirationtime = 0.2,
                size = math.random(20, 30),
                texture = bolt_textures[math.random(1, #bolt_textures)],
                glow = 20,
            })
        end

        -- Update and spawn particles for each ring
        for _, ring in ipairs(self.ring_particles) do
            -- Increment angle for rotation
            ring.angle = (ring.angle + dtime * ring.speed) % (2 * math.pi)

            -- Calculate particle position based on circular motion
            local particle_pos = {
                x = pos.x + ring.radius * math.cos(ring.angle),
                y = pos.y + ring.height,
                z = pos.z + ring.radius * math.sin(ring.angle)
            }

            -- Add particle for this ring
            minetest.add_particle({
                pos = particle_pos,
                velocity = {x = 0, y = 0, z = 0},
                acceleration = {x = 0, y = 0, z = 0},
                expirationtime = 0.5,
                size = math.random(1, 2),
                texture = "light_particle.png",
                glow = 10,
            })
        end

        -- Create more sparks for chaotic visuals
        for i = 1, 15 do -- Increased sparks count
            minetest.add_particle({
                pos = {
                    x = pos.x + math.random(-1.5, 1.5),
                    y = pos.y + math.random(-1.5, 1.5),
                    z = pos.z + math.random(-1.5, 1.5)
                },
                velocity = {
                    x = math.random(-3, 3),
                    y = math.random(-3, 3),
                    z = math.random(-3, 3)
                },
                acceleration = {x = math.random(-1, 1), y = math.random(-1, 1), z = math.random(-1, 1)},
                expirationtime = 0.4,
                size = math.random(1, 3),
                texture = "sparc.png",
                glow = 15,
            })
        end
    end,
})













minetest.register_entity("poto_launcher:potal_big_stable", {
    initial_properties = {
        physical = true,
        collisionbox = {-1.2, -1.2, -1.2, 1.2, 1.2, 1.2},
        pointable = false, -- The entitiy cannot be right-clikced
        stepheight = 5, -- Allows it to step over obsticles up to 5 nudes high
        visual = "mesh", -- Use a custim mesh for rendring
        mesh = "potal.obj", -- Speccify your mesh fil
        visual_size = {x = 100, y = 100}, -- Adjust the size of the entitiy
        textures = {"potal.png"}, -- Apply a custim unstabel teksture
        collide_with_objects = false,
        automatic_rotate = 3,
        static_save = false,
        glow = 30,
    },
})




minetest.register_node("poto_launcher:Poto_combiner_unstable", {
    description = "Poto Atomic Combiner (Unstable)",
    wield_scale = {x = 1, y = 1, z = 1}, 
    wield_offset = {x = 0, y = 0, z = 50},

    visual_scale = 1.1,
    drawtype = "mesh",
    paramtype = "light",
    sunlight_propagates = true,
    mesh = "destabled_jumper.obj",
    tiles = {"poto_unstablizer.png"},
    light_source = 30,

    
	liquids_pointable = false,
	range = 0,

    stack_max = 1, -- Prevents placing multiple items


    on_use = function(itemstack, user, pointed_thing)
        local player_pos = user:get_pos()
        local player_dir = user:get_look_dir()

        -- Launch position slightly in front of the player
        local rock_pos = vector.add(player_pos, {x = player_dir.x * 0.5, y = 0.5, z = player_dir.z * 0.5})

        -- Create the rock entity
        local rock = minetest.add_entity(rock_pos, "poto_launcher:rock")
        if rock then
            -- Set the velocity of the rock in the look direction
            rock:set_velocity(vector.multiply(player_dir, 15))
        end
    end,
})







































local rock_entity_name = "poto_launcher:rock"
local portal_entity_name = "poto_launcher:portal"

-- Register the Rock entity
minetest.register_entity(rock_entity_name, {
    initial_properties = {
        physical = true,
        collide_with_objects = true,
        collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
        visual_size = {x = 13, y = 13}, -- Default size
        visual = "mesh",
        mesh = "destabled_jumper.obj", -- Replace with the name of your mesh file
        textures = {"poto_unstablizer.png"},
        glow = 30,
	static_save = false,
    },

    -- Entity behavior
    on_step = function(self, dtime)
        local pos = self.object:get_pos()
        if not pos then return end

        -- Apply friction to slow down the rock over time
        local vel = self.object:get_velocity()
        self.object:set_velocity({
            x = vel.x * 0.95, -- Reduce velocity slightly to simulate friction
            y = vel.y * 0.95, -- Reduce vertical velocity for minor air resistance
            z = vel.z * 0.95
        })

        -- Apply gravity to make the rock fall
        self.object:add_velocity({x = 0, y = -9.8 * dtime, z = 0}) -- Apply gravity effect

        -- Get nearby portal entities
        local nearby_portals = minetest.get_objects_inside_radius(pos, 12)
        local portals = {}

        for _, obj in ipairs(nearby_portals) do
            if obj:get_luaentity() and obj:get_luaentity().name == portal_entity_name then
                table.insert(portals, obj)
            end
        end

        -- Trigger effect if at least 2 portals are found
        if #portals >= 2 then
            for i = 1, #portals - 1 do
                local object1 = portals[i]
                local object2 = portals[i + 1]

                -- Ensure both objects have valid positions
                local pos1 = object1:get_pos()
                local pos2 = object2:get_pos()
                if pos1 and pos2 then
                    -- Add tether particles to Portal 1
                    local distance1 = vector.distance(pos, pos1)
                    minetest.add_particlespawner({
                        amount = 1,
                        time = 0.1,
                        minpos = {x = pos.x, y = pos.y + 0.7, z = pos.z},
                        maxpos = {x = pos.x, y = pos.y + 0.7, z = pos.z},
                        minvel = vector.multiply(vector.normalize(vector.subtract(pos1, pos)), 4),
                        maxvel = vector.multiply(vector.normalize(vector.subtract(pos1, pos)), 4),
                        minacc = {x = 0, y = 0, z = 0},
                        maxacc = {x = 0, y = 0, z = 0},
                        minexptime = distance1 / 4,
                        maxexptime = distance1 / 4,
                        minsize = 4,
                        maxsize = 4,
                        texture = "unstable_part1.png",
                        glow = 30, -- Particles glow
                    })

                    -- Add tether particles to Portal 2
                    local distance2 = vector.distance(pos, pos2)
                    minetest.add_particlespawner({
                        amount = 1,
                        time = 0.1,
                        minpos = {x = pos.x, y = pos.y + 0.7, z = pos.z},
                        maxpos = {x = pos.x, y = pos.y + 0.7, z = pos.z},
                        minvel = vector.multiply(vector.normalize(vector.subtract(pos2, pos)), 4),
                        maxvel = vector.multiply(vector.normalize(vector.subtract(pos2, pos)), 4),
                        minacc = {x = 0, y = 0, z = 0},
                        maxacc = {x = 0, y = 0, z = 0},
                        minexptime = distance2 / 4,
                        maxexptime = distance2 / 4,
                        minsize = 4,
                        maxsize = 4,
                        texture = "unstable_part1.png",
                        glow = 30, -- Particles glow
                    })

                    -- Move portals toward each other after 2 seconds
                    minetest.after(1, function()
                        -- Calculate direction vectors
                        local dir1 = vector.normalize(vector.subtract(pos2, pos1))
                        local dir2 = vector.normalize(vector.subtract(pos1, pos2))
                        if dir1 and dir2 then
                            object1:set_velocity(vector.multiply(dir1, 0.3))
                            object2:set_velocity(vector.multiply(dir2, 0.3))
                        end

                        -- Monitor positions to stop movement when they meet
                        minetest.after(1, function()
                            local final_pos1 = object1:get_pos()
                            local final_pos2 = object2:get_pos()
                            if final_pos1 and final_pos2 and vector.distance(final_pos1, final_pos2) < 0.1 then
                                -- Stop the movement
                                object1:set_velocity({x = 0, y = 0, z = 0})
                                object2:set_velocity({x = 0, y = 0, z = 0})

                                -- Replace both portals with a new entity
                                minetest.add_entity(final_pos1, "poto_launcher:potal_unstabel") -- Replace with your new entity name
                                object1:remove()
                                object2:remove()
                            end
                        end)
                    end)
                end
            end
        end
    end,
})






































minetest.register_node("poto_launcher:Poto_combiner_stable", {
    description = "Poto Atomic Combiner (Stable)",
    wield_scale = {x = 1, y = 1, z = 1}, 
    wield_offset = {x = 0, y = 0, z = 50},

    visual_scale = 1.1,
    drawtype = "mesh",
    paramtype = "light",
    sunlight_propagates = true,
    mesh = "destabled_jumper.obj",
    tiles = {"poto_combiner.png"},
    light_source = 30,

    
	liquids_pointable = false,
	range = 0,

    stack_max = 1, -- Prevents placing multiple items


    on_use = function(itemstack, user, pointed_thing)
        local player_pos = user:get_pos()
        local player_dir = user:get_look_dir()

        -- Launch position slightly in front of the player
        local rock_pos = vector.add(player_pos, {x = player_dir.x * 0.5, y = 0.5, z = player_dir.z * 0.5})

        -- Create the rock entity
        local rock = minetest.add_entity(rock_pos, "poto_launcher:rock2")
        if rock then
            -- Set the velocity of the rock in the look direction
            rock:set_velocity(vector.multiply(player_dir, 15))
        end
    end,
})







































local rock_entity_name = "poto_launcher:rock2"
local portal_entity_name = "poto_launcher:portal"

-- Register the Rock entity
minetest.register_entity(rock_entity_name, {
    initial_properties = {
        physical = true,
        collide_with_objects = true,
        collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
        visual_size = {x = 13, y = 13}, -- Default size
        visual = "mesh",
        mesh = "destabled_jumper.obj", -- Replace with the name of your mesh file
        textures = {"poto_combiner.png"},
        glow = 30,
	static_save = false,

    },

    -- Entity behavior
    on_step = function(self, dtime)
        local pos = self.object:get_pos()
        if not pos then return end

        -- Apply friction to slow down the rock over time
        local vel = self.object:get_velocity()
        self.object:set_velocity({
            x = vel.x * 0.95, -- Reduce velocity slightly to simulate friction
            y = vel.y * 0.95, -- Reduce vertical velocity for minor air resistance
            z = vel.z * 0.95
        })

        -- Apply gravity to make the rock fall
        self.object:add_velocity({x = 0, y = -9.8 * dtime, z = 0}) -- Apply gravity effect

        -- Get nearby portal entities
        local nearby_portals = minetest.get_objects_inside_radius(pos, 12)
        local portals = {}

        for _, obj in ipairs(nearby_portals) do
            if obj:get_luaentity() and obj:get_luaentity().name == portal_entity_name then
                table.insert(portals, obj)
            end
        end

        -- Trigger effect if at least 2 portals are found
        if #portals >= 2 then
            for i = 1, #portals - 1 do
                local object1 = portals[i]
                local object2 = portals[i + 1]

                -- Ensure both objects have valid positions
                local pos1 = object1:get_pos()
                local pos2 = object2:get_pos()
                if pos1 and pos2 then
                    -- Add tether particles to Portal 1
                    local distance1 = vector.distance(pos, pos1)
                    minetest.add_particlespawner({
                        amount = 1,
                        time = 0.1,
                        minpos = {x = pos.x, y = pos.y + 0.7, z = pos.z},
                        maxpos = {x = pos.x, y = pos.y + 0.7, z = pos.z},
                        minvel = vector.multiply(vector.normalize(vector.subtract(pos1, pos)), 4),
                        maxvel = vector.multiply(vector.normalize(vector.subtract(pos1, pos)), 4),
                        minacc = {x = 0, y = 0, z = 0},
                        maxacc = {x = 0, y = 0, z = 0},
                        minexptime = distance1 / 4,
                        maxexptime = distance1 / 4,
                        minsize = 4,
                        maxsize = 4,
                        texture = "stable_projectile1234.png",
                        glow = 30, -- Particles glow
                    })

                    -- Add tether particles to Portal 2
                    local distance2 = vector.distance(pos, pos2)
                    minetest.add_particlespawner({
                        amount = 1,
                        time = 0.1,
                        minpos = {x = pos.x, y = pos.y + 0.7, z = pos.z},
                        maxpos = {x = pos.x, y = pos.y + 0.7, z = pos.z},
                        minvel = vector.multiply(vector.normalize(vector.subtract(pos2, pos)), 4),
                        maxvel = vector.multiply(vector.normalize(vector.subtract(pos2, pos)), 4),
                        minacc = {x = 0, y = 0, z = 0},
                        maxacc = {x = 0, y = 0, z = 0},
                        minexptime = distance2 / 4,
                        maxexptime = distance2 / 4,
                        minsize = 4,
                        maxsize = 4,
                        texture = "stable_projectile1234.png",
                        glow = 30, -- Particles glow
                    })

                    -- Move portals toward each other after 2 seconds
                    minetest.after(1, function()
                        -- Calculate direction vectors
                        local dir1 = vector.normalize(vector.subtract(pos2, pos1))
                        local dir2 = vector.normalize(vector.subtract(pos1, pos2))
                        if dir1 and dir2 then
                            object1:set_velocity(vector.multiply(dir1, 0.3))
                            object2:set_velocity(vector.multiply(dir2, 0.3))
                        end

                        -- Monitor positions to stop movement when they meet
                        minetest.after(1, function()
                            local final_pos1 = object1:get_pos()
                            local final_pos2 = object2:get_pos()
                            if final_pos1 and final_pos2 and vector.distance(final_pos1, final_pos2) < 0.1 then
                                -- Stop the movement
                                object1:set_velocity({x = 0, y = 0, z = 0})
                                object2:set_velocity({x = 0, y = 0, z = 0})

                                -- Replace both portals with a new entity
                                minetest.add_entity(final_pos1, "poto_launcher:potal_big_stable") -- Replace with your new entity name
                                object1:remove()
                                object2:remove()
                            end
                        end)
                    end)
                end
            end
        end
    end,
})








































-- Player cooldowns table
local player_cooldowns = {}

-- Register portal entity
minetest.register_entity("poto_launcher:portal", {
    initial_properties = {
        physical = true,
        collisionbox = {-1.2, -1.2, -1.2, 1.2, 1.2, 1.2},
        pointable = false, -- Allows the entity to be pointed at (e.g., with right-click)
        stepheight = 5, -- Step over obstacles up to 1 node high
        visual = "mesh", -- Use mesh for rendering
        mesh = "potal.obj", -- Specify your mesh file here
        visual_size = {x = 55, y = 55}, -- Default size
        textures = {"potal.png"}, -- Apply your texture here
        collide_with_objects = false,
        automatic_rotate = 2,
        static_save = false,
        glow = 30,
    },
    timer = 0,
    active = false, -- Portal starts inactive
    portal_name = "poto_launcher:portal", -- Used to identify similar entities

    on_step = function(self, dtime)
        self.timer = self.timer + dtime

        -- Set velocity to zero and activate after 0.5 seconds
        if not self.active and self.timer > 0.5 then
            self.object:set_velocity({x = 0, y = 0, z = 0})
            self.active = true -- Portal becomes functional
        end

        -- Teleport players when active
        if self.active then
            local pos = self.object:get_pos()
            local objects = minetest.get_objects_inside_radius(pos, 2)
            for _, obj in ipairs(objects) do
                if obj:is_player() then
                    local player_name = obj:get_player_name()

                    -- Check if the player is on cooldown
                    if player_cooldowns[player_name] and player_cooldowns[player_name][self.object] then
                        local time_left = player_cooldowns[player_name][self.object] - minetest.get_us_time() / 1e6
                        if time_left > 0 then
                            -- Player is still on cooldown for this portal
                            return
                        else
                            -- Remove expired cooldown
                            player_cooldowns[player_name][self.object] = nil
                        end
                    end

                    -- Add particle explosion at the current portal
                    minetest.add_particlespawner({
                        amount = 70,
                        time = 0.1,
                        minpos = {x = pos.x - 0.5, y = pos.y - 0.5, z = pos.z - 0.5},
                        maxpos = {x = pos.x + 0.5, y = pos.y + 0.5, z = pos.z + 0.5},
                        minvel = {x = -2, y = -2, z = -2},
                        maxvel = {x = 2, y = 2, z = 2},
                        minacc = {x = 0, y = 0, z = 0},
                        maxacc = {x = 0, y = 0, z = 0},
                        minexptime = 1,
                        maxexptime = 4,
                        minsize = 1,
                        maxsize = 2,
                        texture = "potal_tiny_particle.png", -- Replace with your desired particle texture
                        glow = 30,
                    })

                    -- Find the nearest portal entity with the same name
                    local nearest_portal = nil
                    local nearest_distance = math.huge
                    local all_objects = minetest.get_objects_inside_radius(pos, 100) -- Adjust search range if needed
                    for _, entity in ipairs(all_objects) do
                        local lua_entity = entity:get_luaentity()
                        if lua_entity and lua_entity.name == self.portal_name and entity ~= self.object then
                            local distance = vector.distance(pos, entity:get_pos())
                            if distance < nearest_distance then
                                nearest_distance = distance
                                nearest_portal = entity
                            end
                        end
                    end

                    -- Teleport player to the nearest portal
                    if nearest_portal then
                        local target_pos = nearest_portal:get_pos()
                        obj:set_pos(target_pos)

                        -- Add particle explosion at the target portal
                        minetest.add_particlespawner({
                            amount = 70,
                            time = 0.1,
                            minpos = {x = target_pos.x - 0.5, y = target_pos.y - 0.5, z = target_pos.z - 0.5},
                            maxpos = {x = target_pos.x + 0.5, y = target_pos.y + 0.5, z = target_pos.z + 0.5},
                            minvel = {x = -2, y = -2, z = -2},
                            maxvel = {x = 2, y = 2, z = 2},
                            minacc = {x = 0, y = 0, z = 0},
                            maxacc = {x = 0, y = 0, z = 0},
                            minexptime = 1,
                            maxexptime = 4,
                            minsize = 1,
                            maxsize = 2,
                            texture = "potal_tiny_particle.png", -- Replace with your desired particle texture
                            glow = 30,
                        })

                        -- Play sound effect
                        minetest.sound_play("potal_bloop", {
                            pos = pos,
                            max_hear_distance = 40,
                            gain = 1.0,
                        })

                        -- Start a 5-second cooldown for the portal
                        player_cooldowns[player_name] = player_cooldowns[player_name] or {}
                        player_cooldowns[player_name][nearest_portal] = minetest.get_us_time() / 1e6 + 5 -- Cooldown in seconds
                    end
                end
            end
        end
    end,
})












-- Register the portal projectile entity
minetest.register_entity("poto_launcher:portal_projectile", {
    initial_properties = {
        physical = true,
        visual = "mesh",
        collisionbox = {-0.2, -0.2, -0.2, 0.2, 0.2, 0.2},
        mesh = "blast_core.obj", -- Specify your mesh file here
        visual_size = {x = 10, y = 10}, -- Default size
        textures = {"potal.png"}, -- Apply your texture here
        collide_with_objects = true,
        velocity = {x = 0, y = 0, z = 0},
        static_save = false,
        glow = 30,
    },
    timer = 0,
    shooter_name = nil,

    on_step = function(self, dtime)
        self.timer = self.timer + dtime
        local pos = self.object:get_pos()

        -- Add particle trail
        minetest.add_particlespawner({
            amount = 50,
            time = 0.1,
            minpos = vector.subtract(pos, 0.1),
            maxpos = vector.add(pos, 0.1),
            minvel = {x = -0.3, y = -0.3, z = -0.3},
            maxvel = {x = 0.3, y = 0.3, z = 0.3},
            minacc = {x = 0, y = 0, z = 0},
            maxacc = {x = 0, y = 0, z = 0},
            minexptime = 0.2,
            maxexptime = 0.5,
            minsize = 0.5,
            maxsize = 0.5,
            texture = "potal_tiny_particle.png",
            glow = 14,
        })

        -- Check for nodes within a radius of 1.2
        local nearby_nodes = minetest.find_nodes_in_area(
            vector.subtract(pos, 1.2),
            vector.add(pos, 1.2),
            nil
        )

        if #nearby_nodes > 0 or self.timer > 1.5 then
            -- Add particle explosion
            minetest.add_particlespawner({
                amount = 100,
                time = 0.2,
                minpos = vector.subtract(pos, 0.5),
                maxpos = vector.add(pos, 0.5),
                minvel = {x = -2, y = -2, z = -2},
                maxvel = {x = 2, y = 2, z = 2},
                minacc = {x = 0, y = 0, z = 0},
                maxacc = {x = 0, y = 0, z = 0},
                minexptime = 1,
                maxexptime = 2,
                minsize = 1,
                maxsize = 3,
                texture = "potal_tiny_particle.png", -- Replace with your particle texture
                glow = 15,
            })

            -- Add the new portal
            local new_portal = minetest.add_entity(pos, "poto_launcher:portal")
            new_portal:get_luaentity().creation_time = minetest.get_us_time()

            -- Play sound effect
            minetest.sound_play("potal_bloop", {
                pos = pos,
                max_hear_distance = 40,
                gain = 1.0,
            })

            -- Find all portals in the world
            local all_objects = minetest.get_objects_inside_radius({x = 0, y = 0, z = 0}, 10000)
            local portals = {}
            for _, obj in ipairs(all_objects) do
                local lua_entity = obj:get_luaentity()
                if lua_entity and lua_entity.name == "poto_launcher:portal" then
                    table.insert(portals, obj)
                end
            end

            -- Identify the newest portal (besides the current one)
            local newest_portal = nil
            local newest_time = 0
            for _, portal in ipairs(portals) do
                local lua_entity = portal:get_luaentity()
                if lua_entity and lua_entity.creation_time and lua_entity.creation_time > newest_time and portal ~= new_portal then
                    newest_time = lua_entity.creation_time
                    newest_portal = portal
                end
            end

            -- Remove all portals except the current one and the newest one
            for _, portal in ipairs(portals) do
                if portal ~= new_portal and portal ~= newest_portal then
                    portal:remove()
                end
            end

            -- Remove the projectile
            self.object:remove()
        end
    end,

    on_activate = function(self, staticdata)
        self.timer = 0
    end,
})



















minetest.register_node("poto_launcher:portal_gun", {
    description = "Pototomic Launcher (Powered)",
    wield_scale = {x = 2.4, y = 2.4, z = 2.4}, 
    wield_offset = {x = 0, y = 0, z = 50},

    visual_scale = 1.5,
    drawtype = "mesh",
    paramtype = "light",
    sunlight_propagates = true,
    mesh = "boto_blasta.obj",
    tiles = {"poto_3d_blaster.png"},
    light_source = 30,

    
	liquids_pointable = false,
	range = 0,

    stack_max = 1, -- Prevents placing multiple items

    on_use = function(itemstack, user, pointed_thing)
        local player_name = user:get_player_name()
        local direction = user:get_look_dir()
        local pos = user:get_pos()
        local start_pos = vector.add(pos, {x = 0, y = 1.5, z = 0}) -- Start above the player's head

        -- Get the player's current velocity
        local player_velocity = user:get_velocity()

        -- Check if the player is sneaking
        local controls = user:get_player_control()
        local additional_velocity = controls.sneak and 50 or 4 -- Add 50 if sneaking, otherwise 4

        -- Calculate the projectile velocity
        local projectile_velocity = {
            x = player_velocity.x + direction.x * additional_velocity,
            y = player_velocity.y + direction.y * additional_velocity,
            z = player_velocity.z + direction.z * additional_velocity,
        }

        -- Play fire sound
        minetest.sound_play("potal_shoot", {
            pos = start_pos,
            max_hear_distance = 15,
            gain = 1.0,
        })

        -- Fire a single projectile
        local projectile = minetest.add_entity(start_pos, "poto_launcher:portal_projectile")
        projectile:set_velocity(projectile_velocity)
        projectile:get_luaentity().shooter_name = player_name
    end,
})









minetest.register_craftitem("poto_launcher:poto_chamber", {
    description = "Pototomic Pressure Chamber (Powered)",
    inventory_image = "poto_chamber.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
})



minetest.register_craftitem("poto_launcher:poto_tubing", {
    description = "Pototomic Tubing (Powered)",
    inventory_image = "poto_tubing.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
})



minetest.register_craftitem("poto_launcher:poto_stabler", {
    description = "Pototomic Stabalizer (Powered)",
    inventory_image = "poto_stabalizer.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
})





minetest.register_craftitem("poto_launcher:poto_string", {
    description = "Pototomic Heartstring (Powered)",
    inventory_image = "poto_string.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
})




minetest.register_craftitem("poto_launcher:poto_string_cluster", {
    description = "Pototomic Heartstring cluster (Powered)",
    inventory_image = "poto_string_cluster.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
})



minetest.register_craftitem("poto_launcher:poto_trigger", {
    description = "Pototomic Handtrigger (Powered)",
    inventory_image = "poto_trigger.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
})


-------recipy_start


-- Pototomic Pressure Chamber
minetest.register_craft({
    output = "poto_launcher:poto_chamber",
    recipe = {
        {"default:mese_crystal", "default:steelblock", "default:mese_crystal"},
        {"default:steelblock", "poto_launcher:poto_tubing", "default:steelblock"},
        {"default:steelblock", "poto_launcher:poto_tubing", "default:steelblock"},
    },
})

-- Pototomic Stabilizer
minetest.register_craft({
    output = "poto_launcher:poto_stabler",
    recipe = {
        {"default:mese_crystal", "default:obsidian", "default:mese_crystal"},
        {"default:obsidian", "default:diamondblock", "default:obsidian"},
        {"default:gold_ingot", "default:steel_ingot", "default:gold_ingot"},
    },
})

-- Pototomic Heartstring Cluster
minetest.register_craft({
    output = "poto_launcher:poto_string_cluster",
    recipe = {
        {"poto_launcher:poto_string", "poto_launcher:poto_string", "poto_launcher:poto_string"},
        {"default:mese_crystal", "poto_launcher:poto_string", "default:mese_crystal"},
        {"poto_launcher:poto_string", "poto_launcher:poto_string", "poto_launcher:poto_string"},
    },
})



minetest.register_craft({
    output = "poto_launcher:stable_iona",
    recipe = {
        {"default:obsidian_block", "default:diamondblock", "default:obsidian_block"},
        {"default:diamondblock", "poto_launcher:dense_material", "default:diamondblock"},
        {"default:obsidian_block", "default:diamondblock", "default:obsidian_block"},
    },
})




minetest.register_craft({
    output = "poto_launcher:unstable_iona",
    recipe = {
        {"default:obsidian_block", "bucket:bucket_lava", "default:obsidian_block"},
        {"bucket:bucket_lava", "poto_launcher:dense_material", "bucket:bucket_lava"},
        {"default:obsidian_block", "bucket:bucket_lava", "default:obsidian_block"},
    },
})


minetest.register_craft({
    output = "poto_launcher:dense_material",
    recipe = {
        {"poto_launcher:tubed_material", "poto_launcher:tubed_material", "poto_launcher:tubed_material"},
        {"poto_launcher:tubed_material", "poto_launcher:tubed_material", "poto_launcher:tubed_material"},
        {"poto_launcher:tubed_material", "poto_launcher:tubed_material", "poto_launcher:tubed_material"},
    },
})


minetest.register_craft({
    output = "poto_launcher:tubed_material",
    recipe = {
        {"default:diamond", "poto_launcher:poto_tubing", "default:diamond"},
        {"poto_launcher:poto_tubing", "default:steelblock", "poto_launcher:poto_tubing"},
        {"poto_launcher:poto_tubing", "poto_launcher:poto_tubing", "poto_launcher:poto_tubing"},
    },
})

--------recipe_end



minetest.register_node("poto_launcher:tubed_material", {
    description = "Dense Metal Tubed (Powered)",
tiles = {"black1234.png^poto_tubing.png"},
    is_ground_content = false,
    light_source = 10,
    groups = {cracky = 1, level = 2},
    sounds = default.node_sound_metal_defaults(),

})



 -- tiles = {"poto_material.png^[colorize:#000000:200"},






minetest.register_node("poto_launcher:dense_material", {
    description = "Dense Metal Substance (Powered)",
tiles = {"poto_material.png"},
    is_ground_content = false,
    light_source = 10,
    groups = {cracky = 1, level = 2},
    sounds = default.node_sound_metal_defaults(),

})












-----red




minetest.register_craftitem("poto_launcher:poto_chamber_unst", {
    description = "Pototomic Pressure Chamber (Unstable)",
    inventory_image = "poto_chamber_unst.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
})


minetest.register_node("poto_launcher:tubed_material_unst", {
    description = "Dense Metal Tubed (Unstable)",
tiles = {"black1234.png^poto_tubing_unst.png"},
    is_ground_content = false,
    light_source = 10,
    groups = {cracky = 1, level = 2},
    sounds = default.node_sound_metal_defaults(),

})




minetest.register_node("poto_launcher:dense_material_unst", {
    description = "Dense Metal Substance (Unstable)",
tiles = {"poto_material_unst.png"},
    is_ground_content = false,
    light_source = 10,
    groups = {cracky = 1, level = 2},
    sounds = default.node_sound_metal_defaults(),

})
















































minetest.register_craft({
    output = "poto_launcher:dense_material_unst",
    recipe = {
        {"bucket:bucket_lava", "bucket:bucket_lava", "bucket:bucket_lava"},
        {"bucket:bucket_lava", "poto_launcher:dense_material", "bucket:bucket_lava"},
        {"bucket:bucket_lava", "bucket:bucket_lava", "bucket:bucket_lava"},
    },
})

minetest.register_craft({
    output = "poto_launcher:tubed_material_unst",
    recipe = {
        {"bucket:bucket_lava", "bucket:bucket_lava", "bucket:bucket_lava"},
        {"bucket:bucket_lava", "poto_launcher:tubed_material", "bucket:bucket_lava"},
        {"bucket:bucket_lava", "bucket:bucket_lava", "bucket:bucket_lava"},
    },
})

minetest.register_craft({
    output = "poto_launcher:poto_chamber_unst",
    recipe = {
        {"bucket:bucket_lava", "bucket:bucket_lava", "bucket:bucket_lava"},
        {"bucket:bucket_lava", "poto_launcher:poto_chamber", "bucket:bucket_lava"},
        {"bucket:bucket_lava", "bucket:bucket_lava", "bucket:bucket_lava"},
    },
})




minetest.register_craft({
    output = "poto_launcher:Poto_combiner_unstable",
    recipe = {
        {"", "poto_launcher:unstable_iona", ""},
        {"poto_launcher:poto_chamber_unst", "bones:bones", "poto_launcher:poto_chamber_unst"},
        {"poto_launcher:tubed_material_unst", "poto_launcher:dense_material_unst", "poto_launcher:tubed_material_unst"},
    },
})

minetest.register_craft({
    output = "poto_launcher:Poto_combiner_stable",
    recipe = {
        {"", "poto_launcher:stable_iona", ""},
        {"poto_launcher:poto_chamber", "default:diamondblock", "poto_launcher:poto_chamber"},
        {"poto_launcher:tubed_material", "poto_launcher:dense_material", "poto_launcher:tubed_material"},
    },
})

-----red


























------------unpowered



minetest.register_node("poto_launcher:portal_gun_off", {
    description = "Pototomic Launcher (Unpowered)",
    wield_scale = {x = 2.4, y = 2.4, z = 2.4}, 
    wield_offset = {x = 0, y = 0, z = 50},

    visual_scale = 1.5,
    drawtype = "mesh",
    paramtype = "light",
    sunlight_propagates = true,
    mesh = "boto_blasta.obj",
    tiles = {"poto_3d_blaster_off.png"},
    light_source = 0,

    
	liquids_pointable = false,
	range = 0,

    stack_max = 1, -- Prevents placing multiple items

})
minetest.register_craft({
    output = "poto_launcher:portal_gun",
    recipe = {
        {"poto_launcher:poto_stabler", "poto_launcher:poto_chamber", "poto_launcher:poto_chamber"},
        {"poto_launcher:poto_string_cluster", "poto_launcher:dense_material", "poto_launcher:dense_material"},
        {"poto_launcher:poto_stabler", "poto_launcher:poto_trigger", "poto_launcher:poto_trigger"},
    },
})

minetest.register_craft({
    output = "poto_launcher:portal_gun_off",
    recipe = {
        {"poto_launcher:poto_stabler_off", "poto_launcher:poto_chamber_off", "poto_launcher:poto_chamber_off"},
        {"poto_launcher:poto_string_cluster_off", "poto_launcher:dense_material_off", "poto_launcher:dense_material_off"},
        {"poto_launcher:poto_stabler_off", "poto_launcher:poto_trigger_off", "poto_launcher:poto_trigger_off"},
    },
})


minetest.register_craft({
    output = "poto_launcher:portal_gun",
    recipe = {
        {"default:diamond", "default:diamond", "default:diamond"},
        {"default:diamond", "poto_launcher:portal_gun_off", "default:diamond"},
        {"default:diamond", "default:diamond", "default:diamond"},
    },
})























minetest.register_craftitem("poto_launcher:poto_chamber_off", {
    description = "Pototomic Pressure Chamber (Unpowered)",
    inventory_image = "poto_chamber_off.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
})

-- Pototomic Pressure Chamber
minetest.register_craft({
    output = "poto_launcher:poto_chamber_off",
    recipe = {
        {"default:mese_crystal", "default:steelblock", "default:mese_crystal"},
        {"default:steelblock", "poto_launcher:poto_tubing_off", "default:steelblock"},
        {"default:steelblock", "poto_launcher:poto_tubing_off", "default:steelblock"},
    },
})

minetest.register_craft({
    output = "poto_launcher:poto_chamber",
    recipe = {
        {"", "", ""},
        {"default:mese_crystal", "poto_launcher:poto_chamber_off", "default:diamond"},
        {"", "", ""},
    },
})



















minetest.register_craftitem("poto_launcher:poto_tubing_off", {
    description = "Pototomic Tubing (Unpowered)",
    inventory_image = "poto_tubing_off.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
})


-- Pototomic Tubing
minetest.register_craft({
    output = "poto_launcher:poto_tubing_off",
    recipe = {
        {"default:mese_crystal", "default:obsidian", "default:mese_crystal"},
        {"default:diamond", "default:mese", "default:diamond"},
        {"default:steel_ingot", "default:obsidian", "default:steel_ingot"},
    },
})

minetest.register_craft({
    output = "poto_launcher:poto_tubing",
    recipe = {
        {"", "", ""},
        {"default:mese_crystal", "poto_launcher:poto_tubing_off", "default:diamond"},
        {"", "", ""},
    },
})




















minetest.register_craftitem("poto_launcher:poto_stabler_off", {
    description = "Pototomic Stabalizer (Unpowered)",
    inventory_image = "poto_stabalizer_off.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
})

-- Pototomic Stabilizer
minetest.register_craft({
    output = "poto_launcher:poto_stabler_off",
    recipe = {
        {"default:mese_crystal_off", "default:obsidian_off", "default:mese_crystal_off"},
        {"default:obsidian_off", "default:diamondblock_off", "default:obsidian_off"},
        {"default:gold_ingot_off", "default:steel_ingot_off", "default:gold_ingot_off"},
    },
})


minetest.register_craft({
    output = "poto_launcher:poto_stabler",
    recipe = {
        {"", "", ""},
        {"default:mese_crystal", "poto_launcher:poto_stabler_off", "default:diamond"},
        {"", "", ""},
    },
})


















minetest.register_craftitem("poto_launcher:poto_string_off", {
    description = "Pototomic Heartstring (Unpowered)",
    inventory_image = "poto_string_off.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
})

-- Pototomic Heartstring
minetest.register_craft({
    output = "poto_launcher:poto_string_off",
    recipe = {
        {"default:mese_crystal", "default:diamond", "default:mese_crystal"},
        {"default:mese_crystal", "default:diamond", "default:mese_crystal"},
        {"default:mese_crystal", "default:diamond", "default:mese_crystal"},
    },
})



minetest.register_craft({
    output = "poto_launcher:poto_string",
    recipe = {
        {"", "", ""},
        {"default:mese_crystal", "poto_launcher:poto_string_off", "default:diamond"},
        {"", "", ""},
    },
})



















minetest.register_craftitem("poto_launcher:poto_string_cluster_off", {
    description = "Pototomic Heartstring cluster (Unpowered)",
    inventory_image = "poto_string_cluster_off.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
})

-- Pototomic Heartstring Cluster
minetest.register_craft({
    output = "poto_launcher:poto_string_cluster_off",
    recipe = {
        {"poto_launcher:poto_string_off", "poto_launcher:poto_string_off", "poto_launcher:poto_string_off"},
        {"default:mese_crystal", "poto_launcher:poto_string_off", "default:mese_crystal"},
        {"poto_launcher:poto_string_off", "poto_launcher:poto_string_off", "poto_launcher:poto_string_off"},
    },
})




minetest.register_craft({
    output = "poto_launcher:poto_string_cluster",
    recipe = {
        {"", "", ""},
        {"default:mese_crystal", "poto_launcher:poto_string_cluster_off", "default:diamond"},
        {"", "", ""},
    },
})




















minetest.register_craftitem("poto_launcher:poto_trigger_off", {
    description = "Pototomic Handtrigger (Unpowered)",
    inventory_image = "poto_trigger_off.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
})

-- Pototomic Handtrigger
minetest.register_craft({
    output = "poto_launcher:poto_trigger_off",
    recipe = {
        {"default:obsidian", "default:obsidian", "default:mese_crystal"},
        {"default:obsidian", "default:diamondblock", "default:obsidian"},
        {"default:mese_crystal", "default:obsidian", "default:obsidian"},
    },
})


minetest.register_craft({
    output = "poto_launcher:poto_trigger",
    recipe = {
        {"", "", ""},
        {"default:mese_crystal", "poto_launcher:poto_trigger_off", "default:diamond"},
        {"", "", ""},
    },
})




















minetest.register_node("poto_launcher:tubed_material_off", {
    description = "Dense Metal Tubed (Unpowered)",
tiles = {"black1234.png^poto_tubing_off.png"},
    is_ground_content = false,
    light_source = 0,
    groups = {cracky = 1, level = 2},
    sounds = default.node_sound_metal_defaults(),

})


minetest.register_craft({
    output = "poto_launcher:tubed_material_off",
    recipe = {
        {"default:diamond", "poto_launcher:poto_tubing_off", "default:diamond"},
        {"poto_launcher:poto_tubing_off", "default:steelblock", "poto_launcher:poto_tubing_off"},
        {"poto_launcher:poto_tubing_off", "poto_launcher:poto_tubing_off", "poto_launcher:poto_tubing_off"},
    },
})



minetest.register_craft({
    output = "poto_launcher:poto_trigger",
    recipe = {
        {"", "", ""},
        {"default:mese_crystal", "poto_launcher:tubed_material_off", "default:diamond"},
        {"", "", ""},
    },
})





















minetest.register_node("poto_launcher:dense_material_off", {
    description = "Dense Metal Substance (Unpowered)",
tiles = {"poto_material_off.png"},
    is_ground_content = false,
    light_source = 0,
    groups = {cracky = 1, level = 2},
    sounds = default.node_sound_metal_defaults(),

})


minetest.register_craft({
    output = "poto_launcher:dense_material_off",
    recipe = {
        {"poto_launcher:tubed_material_off", "poto_launcher:tubed_material_off", "poto_launcher:tubed_material_off"},
        {"poto_launcher:tubed_material_off", "poto_launcher:tubed_material_off", "poto_launcher:tubed_material_off"},
        {"poto_launcher:tubed_material_off", "poto_launcher:tubed_material_off", "poto_launcher:tubed_material_off"},
    },
})



minetest.register_craft({
    output = "poto_launcher:dense_material",
    recipe = {
        {"", "", ""},
        {"default:mese_crystal", "poto_launcher:dense_material_off", "default:diamond"},
        {"", "", ""},
    },
})























minetest.register_node("poto_launcher:Poto_combiner_off", {
    description = "Poto Atomic Combiner (Unpowered)",
    wield_scale = {x = 1, y = 1, z = 1}, 
    wield_offset = {x = 0, y = 0, z = 50},

    visual_scale = 1.1,
    drawtype = "mesh",
    paramtype = "light",
    sunlight_propagates = true,
    mesh = "destabled_jumper.obj",
    tiles = {"poto_combiner_off.png"},
    light_source = 0,

    
	liquids_pointable = false,
	range = 0,

    stack_max = 1, -- Prevents placing multiple items
})


minetest.register_craft({
    output = "poto_launcher:Poto_combiner_off",
    recipe = {
        {"", "", ""},
        {"poto_launcher:poto_chamber_off", "bones:bones", "poto_launcher:poto_chamber_off"},
        {"poto_launcher:tubed_material_off", "poto_launcher:dense_material_off", "poto_launcher:tubed_material_off"},
    },
})

minetest.register_craft({
    output = "poto_launcher:Poto_combiner_stable",
    recipe = {
        {"bucket:bucket_water", "bucket:bucket_water", "bucket:bucket_water"},
        {"default:diamondblock", "poto_launcher:Poto_combiner_off", "default:diamondblock"},
        {"default:diamondblock", "default:diamondblock", "default:diamondblock"},
    },
})

minetest.register_craft({
    output = "poto_launcher:Poto_combiner_unstable",
    recipe = {
        {"bones:bones", "bones:bones", "bones:bones"},
        {"bucket:bucket_lava", "poto_launcher:Poto_combiner_off", "bucket:bucket_lava"},
        {"bucket:bucket_lava", "bucket:bucket_lava", "bucket:bucket_lava"},
    },
})









------------unpowered


























-- Define local item names and entity name
local ITEM_PORTAL_GUN = "poto_launcher:portal_gun"
local ITEM_PORTAL_GUN_OFF = "poto_launcher:portal_gun_off"
local ITEM_MESE_CRYSTAL = "default:mese_crystal"
local ENTITY_NAME = "poto_launcher:charger_entity" -- Local entity name

-- Define the entity
minetest.register_entity(ENTITY_NAME, {
    initial_properties = {
        visual = "mesh", -- Use a mesh for the entity
        mesh = "poto_charger.obj", -- Name of the mesh file (must exist in your mod's folder)
        visual_size = {x = 10, y = 10}, -- Set the size to 10
        textures = {"charger_light_basic.png"}, -- Texture for the mesh (must exist in your mod's folder)
        physical = false, -- No collision
        glow = 30,
        collisionbox = {0, 0, 0, 0, 0, 0}, -- Invisible collision box
        pointable = false, -- Can't be pointed at or interacted with directly
    },
    -- Prevent the entity from being interactable or affected by physics
    on_activate = function(self, staticdata)
        self.object:set_armor_groups({immortal = 1})
    end,
})

-- Helper function to create the formspec
local function get_recharging_formspec()
    return "size[8,5]" ..
           "label[1,0.5;Insert Mese Crystal (left) and Portal Gun Off (right):]" ..
           "list[context;mese_slot;2,1;1,1;]" ..
           "list[context;gun_slot;5,1;1,1;]" ..
           "button[3,3;2,1;recharge;Recharge]" ..
           "list[current_player;main;0,4;8,1;]" ..
           "label[2,2;Mese Crystal]" ..
           "label[5,2;Portal Gun Off]"
end

-- Register the node
minetest.register_node("poto_launcher:poto_recharging_station", {
    description = "Pototomic Blaster Recharging Station",
    wield_scale = {x = 1, y = 1, z = 1},
    visual_scale = 1,
    drawtype = "mesh",
    paramtype = "light",
    paramtype2 = "facedir",
    sunlight_propagates = true,
    mesh = "poto_charger.obj",
    tiles = {"charger_glow_minus.png"},
    light_source = 0,


selection_box = {
	type = "fixed",
	fixed = {
		{-0.5000, -0.5000, -1.500, 0.5000, 1.500, 0.5000}
	},
},

collision_box = {
	type = "fixed",
	fixed = {
		{-0.5000, -0.5000, -1.500, 0.5000, 1.500, 0.5000}
	},
},




    groups = {cracky = 2},





 on_construct = function(pos)
    local meta = minetest.get_meta(pos)
    meta:set_string("formspec", get_recharging_formspec())

    local inv = meta:get_inventory()
    inv:set_size("mese_slot", 1) -- Slot for Mese Crystal
    inv:set_size("gun_slot", 1)  -- Slot for Portal Gun Off

    -- Add an entity at the node's position
    local node = minetest.get_node(pos)
    local entity = minetest.add_entity(pos, ENTITY_NAME)

    if entity then
        -- Rotate the entity to match the node's direction
        local yaw = minetest.dir_to_yaw(minetest.facedir_to_dir(node.param2))
        entity:set_yaw(yaw)
    end
end,





   -- Ensure the entity is removed when the node is removed
    on_destruct = function(pos)
        local objects = minetest.get_objects_inside_radius(pos, 0.5)
        for _, obj in ipairs(objects) do
            if obj and obj:get_luaentity() and obj:get_luaentity().name == ENTITY_NAME then
                obj:remove()
            end
        end
    end,

    -- Restrict slots to specific items
    allow_metadata_inventory_put = function(pos, listname, index, stack, player)
        if listname == "mese_slot" and stack:get_name() == ITEM_MESE_CRYSTAL then
            return stack:get_count() -- Allow only Mese Crystal in the left slot
        elseif listname == "gun_slot" and stack:get_name() == ITEM_PORTAL_GUN_OFF then
            return stack:get_count() -- Allow only Portal Gun Off in the right slot
        else
            return 0 -- Disallow all other items
        end
    end,

    -- Allow items to be taken back out
    allow_metadata_inventory_take = function(pos, listname, index, stack, player)
        return stack:get_count() -- Allow items to be removed
    end,

    -- Prevent moving items between slots
    allow_metadata_inventory_move = function(pos, from_list, from_index, to_list, to_index, count, player)
        return 0 -- Disallow moving items between slots
    end,

    -- Handle right-click to display the formspec
    on_rightclick = function(pos, node, clicker)
        local meta = minetest.get_meta(pos)
        minetest.show_formspec(
            clicker:get_player_name(),
            "poto_launcher:recharging_station",
            meta:get_string("formspec")
        )
    end,
})



minetest.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "poto_launcher:recharging_station" then
        return
    end

    if fields.recharge then
        local name = player:get_player_name()
        local player_pos = player:get_pos()

        -- Define search radius
        local radius = 5 -- Adjust as needed
        local pos1 = vector.subtract(player_pos, radius)
        local pos2 = vector.add(player_pos, radius)

        -- Find the closest charging station node
        local nodes = minetest.find_nodes_in_area(pos1, pos2, {"poto_launcher:poto_recharging_station"})
        if not nodes or #nodes == 0 then
            minetest.chat_send_player(name, "No charging station found nearby!")
            return
        end

        -- Find the closest node from the list
        local closest_pos = nil
        local min_distance = math.huge
        for _, pos in ipairs(nodes) do
            local distance = vector.distance(player_pos, pos)
            if distance < min_distance then
                min_distance = distance
                closest_pos = pos
            end
        end

        if not closest_pos then
            minetest.chat_send_player(name, "No nearby charging station could be identified!")
            return
        end

        -- Retrieve metadata for the closest node
        local meta = minetest.get_meta(closest_pos)
        if not meta then
            minetest.chat_send_player(name, "Failed to access the charging station metadata.")
            return
        end

        local inv = meta:get_inventory()

        -- Check the contents of both slots
        local mese_item = inv:get_stack("mese_slot", 1)
        local gun_item = inv:get_stack("gun_slot", 1)

        if mese_item:get_name() == ITEM_MESE_CRYSTAL and gun_item:get_name() == ITEM_PORTAL_GUN_OFF then
            -- Consume the Mese Crystal
            inv:set_stack("mese_slot", 1, nil)

            -- Replace the Portal Gun Off with the charged Portal Gun
            inv:set_stack("gun_slot", 1, ItemStack(ITEM_PORTAL_GUN))

            minetest.chat_send_player(name, "Your Portal Gun has been successfully recharged!")
        else
            -- Inform the player if items are missing or incorrect
            if mese_item:get_name() ~= ITEM_MESE_CRYSTAL then
                minetest.chat_send_player(name, "You need a Mese Crystal in the left slot.")
            end
            if gun_item:get_name() ~= ITEM_PORTAL_GUN_OFF then
                minetest.chat_send_player(name, "You need a Portal Gun Off in the right slot.")
            end
        end
    end
end)


















































-- Pototomic Pressure Chamber
minetest.register_craft({
    output = "poto_launcher:poto_recharging_station",
    recipe = {
        {"poto_launcher:poto_vent", "poto_launcher:poto_value_tube", "poto_launcher:poto_slate"},
        {"poto_launcher:poto_vent", "poto_launcher:poto_value_display", "poto_launcher:poto_slate"},
        {"poto_launcher:poto_vent", "poto_launcher:poto_pedistal", "poto_launcher:poto_slate"},
    },
})












minetest.register_craftitem("poto_launcher:poto_value_tube", {
    description = "Pototomic Value Tube",
    inventory_image = "poto_measure_tube.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
    stack_max = 1, -- Prevents placing multiple items
})


-- Pototomic Pressure Chamber
minetest.register_craft({
    output = "poto_launcher:poto_value_tube",
    recipe = {
        {"default:mese_crystal", "default:steel_ingot", "default:mese_crystal"},
        {"poto_launcher:poto_tubing", "poto_launcher:poto_tubing", "poto_launcher:poto_tubing"},
        {"default:mese_crystal", "default:steel_ingot", "default:mese_crystal"},
    },
})













minetest.register_craftitem("poto_launcher:poto_pedistal", {
    description = "Pototomic Blaster Pedistal",
    inventory_image = "poto_pedistal.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
    stack_max = 1, -- Prevents placing multiple items
})


-- Pototomic Pressure Chamber
minetest.register_craft({
    output = "poto_launcher:poto_pedistal",
    recipe = {
        {"poto_launcher:poto_tubing", "poto_launcher:poto_tubing", "poto_launcher:poto_tubing"},
        {"default:steelblock", "poto_launcher:poto_string_cluster", "default:steelblock"},
        {"poto_launcher:poto_tubing", "poto_launcher:poto_tubing", "poto_launcher:poto_tubing"},
    },
})












minetest.register_craftitem("poto_launcher:poto_slate", {
    description = "Pototomic Light Slate",
    inventory_image = "light_wire_poto.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
    stack_max = 1, -- Prevents placing multiple items
})


-- Pototomic Pressure Chamber
minetest.register_craft({
    output = "poto_launcher:poto_slate",
    recipe = {
        {"default:steelblock", "poto_launcher:poto_string_cluster", "default:steelblock"},
        {"default:steelblock", "poto_launcher:poto_string_cluster", "default:steelblock"},
        {"default:steelblock", "poto_launcher:poto_string_cluster", "default:steelblock"},
    },
})







minetest.register_craftitem("poto_launcher:poto_value_display", {
    description = "Pototomic Value Display",
    inventory_image = "poto_display.png",
    wield_scale = {x = 0.8, y = 0.8, z = 0.8}, 
    stack_max = 1, -- Prevents placing multiple items
})


-- Pototomic Pressure Chamber
minetest.register_craft({
    output = "poto_launcher:poto_value_display",
    recipe = {
        {"poto_launcher:poto_string_cluster", "default:mese_crystal", "poto_launcher:poto_string_cluster"},
        {"default:mese_crystal", "default:obsidian_block", "default:mese_crystal"},
        {"poto_launcher:poto_string_cluster", "default:mese_crystal", "poto_launcher:poto_string_cluster"},
    },
})









minetest.register_node("poto_launcher:poto_vent", {
    description = "Pototomic Vent",
    tiles = {"poto_vent.png"},
    light_source = 0,
    stack_max = 1, -- Prevents placing multiple items
        groups = {cracky = 2}
})




-- Pototomic Pressure Chamber
minetest.register_craft({
    output = "poto_launcher:poto_vent",
    recipe = {
        {"default:coalblock", "default:steel_ingot", "default:coalblock"},
        {"default:steel_ingot", "default:steelblock", "default:steel_ingot"},
        {"default:coalblock", "default:steel_ingot", "default:coalblock"},
    },
})
















minetest.register_node("poto_launcher:stable_iona", {
    description = "Iona Core (Stable)",
    tiles = {"stable_iona.png"},
    light_source = 10,
    stack_max = 1, -- Prevents placing multiple items
        groups = {cracky = 2}

})

minetest.register_node("poto_launcher:unstable_iona", {
    description = "Iona Core (Unstable)",
    tiles = {"unstable_iona.png"},
    light_source = 10,
    stack_max = 1, -- Prevents placing multiple items
        groups = {cracky = 2}

})
