# Builda City™

A multiplayer city-building game running on the Minetest Engine.

![screenshot](screenshot.png)

## Quick Rundown
You've been employed by a company with plenty of energy to
sell but no customers to sell it to! It's your job
to build a city for them so that they can make some cash!

## Installation
You will need to install [Minetest](http://minetest.net) and
place this repo inside Minetest's game directory. Start up
Minetest and select the Builda City coin from the main menu.
Now you can create a world and start playing!
Hint: if you can't think of a good world name, try "Earth".

## Quick Start
Press K to toggle flight mode.
You can only build roads and buildings next to existing roads 
so you will need to find a road in order to begin building your city. 
Buildings cost coins and eventually you will run out. Don't worry
you can collect more coins by delivering energy to the structures 
you have built. You'll need to click on energy sources to charge your
battery. You can also check on the status of your city at any time
by pressing I / inventory (whilst within the city limits).

## Assets
The assets for this game have been sourced from various CC0 sources.
The houses, buildings and roads are by Kenny [https://kenney.nl]. 
The sounds have been sourced from Freesound [https://freesound.org].
The icons are emojis from Twemoji [https://twemoji.twitter.com].

The wind turbine and powercraft were both authored by me using 
AssetForge [https://assetforge.io/].

## Features Wishlist / Roadmap / Ideas
A list of features that would be nice to have, if you are
a modder, submit a PR!
* Traffic
* Airports
* Railroads
* Ports/Ships
* Upgradable Crafts
* Disasters
* Farms/Industry
* Smoother Coastlines
* Mesecon-style power?
* Bridges, Tunnels and Hilly Roads
* Driving around the city in a car.
* Walking around the city as a person?

## Minetest Engine Wishlist
If you work on the Minetest engine, here are some feature
that would help to polish & improve Builda City.
* Meshlike particles
* Change the chat/log/debug position
* Use the game name in the pause menu.
* Automatically load clientmods in the game directory 
  (for singleplayer) if provided.

## License
This project is licensed under the The Qlovatech Community Trademark License 1.0
this means you can do what you like with this project as long as you share your 
changes and respect the community trademarks. See the https://qlova.tech/ctl/1.0