-- Register Concrete block
minetest.register_node("bunker:steelConc", {
    description = "Steel Reinforced Concrete",
    tiles = {
        "bunker_steelConc.png",
        "bunker_steelConc.png",
        "bunker_steelConc.png",
        "bunker_steelConc.png",
        "bunker_steelConc.png",
        "bunker_steelConc.png"
    },
    is_ground_content = false,
    groups = {cracky=1, level=3},
    sounds = default.node_sound_stone_defaults(),
    on_blast = function() end --Make it blast proof
 })

--Register Custom Ingredients
minetest.register_craftitem("bunker:cement_powder", {
    description = "Cement Powder",
    inventory_image = "bunker_cement_powder.png"
})
minetest.register_craftitem("bunker:wet_cement", {
    description = "Wet Cement",
    inventory_image = "bunker_wet_cement.png"
})
minetest.register_craftitem("bunker:rebar", {
    description = "Reinforcing Bar",
    inventory_image = "bunker_rebar.png"
})

--Register Recipes
minetest.register_craft({
    type = "shapeless",
    output = "bunker:steelConc",
    recipe = {
        "bunker:rebar",
        "bunker:rebar",
        "bunker:rebar",
        "bunker:wet_cement",
        "bunker:wet_cement",
        "bunker:wet_cement",
        "bunker:wet_cement",
        "bunker:wet_cement",
        "bunker:wet_cement",
    },
})
minetest.register_craft({
    type = "shapeless",
    output = "bunker:rebar 3",
    recipe = {
        "default:steel_ingot",
        "default:steel_ingot",
    },
})
minetest.register_craft({
    type = "shapeless",
    output = "bunker:wet_cement",
    recipe = {
        "bucket:bucket_water",
        "bunker:cement_powder",
        "default:gravel",
        "default:sand",
    },
    replacements = {{"bucket:bucket_water", "bucket:bucket_empty"}},
})
minetest.register_craft({
    type = "cooking",
    output = "bunker:cement_powder",
    recipe = "default:clay_lump",
    cooktime = 10,
})

--Register with pkarcs mod
if minetest.get_modpath("pkarcs") then
	pkarcs.register_node("bunker:steelConc")
end



