-- Register Concrete block, slab, and stair
minetest.register_node("bunker:steelConc", {
    description = "Steel Reinforced Concrete",
    tiles = {
        "bunker_steelConc.png",
        "bunker_steelConc.png",
        "bunker_steelConc.png",
        "bunker_steelConc.png",
        "bunker_steelConc.png",
        "bunker_steelConc.png"
    },
    is_ground_content = false,
    groups = {cracky=1, level=3},
    sounds = default.node_sound_stone_defaults(),
    on_blast = function() end --Make it blast proof
})
minetest.register_node("bunker:steelConc_stair", {
    description = "Steel Reinforced Concrete Stair",
    tiles = {"bunker_steelConc.png"},  
    groups = {cracky=1, level=3},
    paramtype2 = "facedir",  
    drawtype = "nodebox",    
    node_box = {
        type = "fixed",
        fixed = {
            -- Define the stair shape using nodebox
            {-0.5, -0.5, -0.5, 0.5, 0.0, 0.5},  
            {-0.5, 0.0, 0.0, 0.5, 0.5, 0.5},  
        }
    },
    sounds = default.node_sound_stone_defaults(),
    on_blast = function() end --Make it blast proof
})
minetest.register_node("bunker:steelConc_slab", {
    description = "Steel Reinforced Concrete Slab",
    tiles = {"bunker_steelConc.png"},
    groups = {cracky = 3, slab = 1},  
    sounds = default.node_sound_stone_defaults(),
    drawtype = "nodebox",
    node_box = {
        type = "fixed",
        fixed = {
            {-0.5, -0.5, -0.5, 0.5, 0, 0.5},
        },
    },
    on_blast = function() end --Make it blast proof
})

--Register Custom Ingredients
minetest.register_craftitem("bunker:cement_powder", {
    description = "Cement Powder",
    inventory_image = "bunker_cement_powder.png"
})
minetest.register_craftitem("bunker:wet_cement", {
    description = "Wet Cement",
    inventory_image = "bunker_wet_cement.png"
})
minetest.register_craftitem("bunker:rebar", {
    description = "Reinforcing Bar",
    inventory_image = "bunker_rebar.png"
})

--Register Recipes
minetest.register_craft({
    type = "shapeless",
    output = "bunker:steelConc",
    recipe = {
        "bunker:wet_cement",
        "bunker:wet_cement",
        "bunker:wet_cement",
        "bunker:rebar",
        "bunker:rebar",
        "bunker:rebar",
        "bunker:wet_cement",
        "bunker:wet_cement",
        "bunker:wet_cement",
    },
})
minetest.register_craft({
    output = "bunker:steelConc_stair 8",  
    recipe = {
        {"bunker:steelConc", "", ""},
        {"bunker:steelConc", "bunker:steelConc", ""},
        {"bunker:steelConc", "bunker:steelConc", "bunker:steelConc"},
    },
})
minetest.register_craft({
    output = "bunker:steelConc_slab 6",  
    recipe = {
        {"bunker:steelConc", "bunker:steelConc", "bunker:steelConc"},
    },
})
minetest.register_craft({
    type = "shapeless",
    output = "bunker:rebar 3",
    recipe = {
        "default:steel_ingot",
        "default:steel_ingot",
    },
})
minetest.register_craft({
    type = "shapeless",
    output = "bunker:wet_cement",
    recipe = {
        "bucket:bucket_water",
        "bunker:cement_powder",
        "default:gravel",
        "default:sand",
    },
    replacements = {{"bucket:bucket_water", "bucket:bucket_empty"}},
})
minetest.register_craft({
    type = "cooking",
    output = "bunker:cement_powder",
    recipe = "default:clay_lump",
    cooktime = 10,
})

--Register with pkarcs mod
if minetest.get_modpath("pkarcs") then
	pkarcs.register_node("bunker:steelConc")
end



