-- Copyright (C) 2024 Stakbox
-- This file is licensed under the GNU General Public License, version 3.0 or later
-- It is distributed WITHOUT ANY WARRANTY
-- See LICENSE.txt for more details

function s_weapons.register_hammer(def)
	
	local hammer_name = "s_weapons:hammer_" .. def.material
	
	local sword_item = minetest.registered_tools["default:sword_" .. def.material]
	local pick_item = minetest.registered_tools["default:pick_" .. (def.pickaxe_level or def.material)]
	
	local punch_interval = def.full_punch_interval or sword_item.tool_capabilities.full_punch_interval * 2 or 1
	
	local damage_groups = {}
	
	if def.damage then
		
		damage_groups = def.damage
		
	elseif sword_item.tool_capabilities.damage_groups then
		
		for index, damage_group in next, sword_item.tool_capabilities.damage_groups do
			
			damage_groups[index] = damage_group
		end
	end
	
	local max_drop_level = pick_item.tool_capabilities.max_drop_level or 0
	
	local groupcaps = pick_item.tool_capabilities.groupcaps or {}
	
	damage_groups.fleshy = damage_groups.fleshy - 1
	damage_groups.knockback = damage_groups.fleshy * 4--3
	
	minetest.register_tool(hammer_name, {
		description = string.upper(string.sub(def.material, 1, 1)) .. string.sub(def.material, 2) .. " Battlehammer",
		inventory_image = "s_weapons_hammer_" .. def.material .. ".png",
		tool_capabilities = {
			full_punch_interval = punch_interval,
			damage_groups = damage_groups,
			max_drop_level = max_drop_level,
			groupcaps = groupcaps
		},
		sounds = {breaks = "default_tool_breaks"},
		groups = {battlehammer = 1}
	})
	
	local mat = def.crafting_item
	
	if mat then
		minetest.register_craft({
			output = hammer_name,
			recipe = {
				{mat, mat, mat},
				{mat, "group:stick", mat},
				{"", "group:stick", ""}
			}
		})
	end
	
end

local materials = {
	{"wood", "group:wood"},
	{"stone", "group:stone"},
	{"bronze", "default:bronze_ingot"},
	{"steel", "default:steel_ingot"},
	{"mese", "default:mese_crystal"},
	{"diamond", "default:diamond"}
}

for i = 2, #materials do
	
	s_weapons.register_hammer({
		material = materials[i][1],
		pickaxe_level = materials[i-1][1],
		crafting_item = materials[i][2]
	})
	
end

local hammer_sound_enabled = minetest.settings:get_bool("s_weapons_hammer_sound")
local cmi_loaded = minetest.get_modpath("cmi")

if hammer_sound_enabled ~= false and cmi_loaded then
	
	cmi.register_on_punchmob(function(mob, hitter, tflp, toolcaps)
		
		if tflp >= toolcaps.full_punch_interval then
		
			local weapon = hitter:get_wielded_item()
			local weapon_def = weapon:get_definition() or {}
			
			if weapon_def.groups.battlehammer and weapon:get_name() ~= "s_weapons:hammer_stone" then
				
				sound_parameters = {object = mob, max_hear_distance = 12, gain = 0.29, pitch = 1+math.random(-1,1)*0.02}
				
				minetest.sound_play("s_weapons_hammer_hit", sound_parameters, true)
				
			end
		end
		
	end)
	
elseif hammer_sound_enabled ~= false and not cmi_loaded then
	
	minetest.log("Common Mob Interface mod isn't enabled, hammer bonk sounds won't work without it.")
	
end
