
function worldedit_hud_helper.initialise_hud(player)
	local player_name = player:get_player_name()
	local player_info = worldedit_hud_helper.info[player_name]
	
	if not player_info then
		player_info = {
			enabled = true,
			node_name = nil,
			rotation = nil
		}
		worldedit_hud_helper.info[player_name] = player_info
	end
	
	player_info.id_node_name = player:hud_add({
		hud_elem_type	= "text",
		text			= "",
		number			= 0xFFFFFF,
		position		= { x = 0.5, y = 1 },
		offset			= { x = 0, y = -100 },
		
		alignment		= { x = 0, y = 0 }, -- Align to the centre
		scale			= { x = 150, y = 30 }
	})
	
	player_info.id_rotation = player:hud_add({
		hud_elem_type	= "text",
		text			= "",
		number			= 0xFFFFFF,
		position		= { x = 0.5, y = 1 },
		offset			= { x = 0, y = -135 },
		
		alignment		= { x = 0, y = 0 }, -- Align to the centre
		scale			= { x = 150, y = 30 }
	})
	
end

function worldedit_hud_helper.hide_hud(player)
	local player_info = worldedit_hud_helper.info[player:get_player_name()]
	
	
	player:hud_remove(player_info.id_node_name)
	player:hud_remove(player_info.id_rotation)
	
	player_info.node_name = nil
	player_info.rotation = nil
end

function worldedit_hud_helper.delete_hud(player)
	worldedit_hud_helper.info[player:get_player_name()] = nil
end


minetest.register_on_joinplayer(worldedit_hud_helper.initialise_hud)
minetest.register_on_leaveplayer(worldedit_hud_helper.delete_hud)
