
function worldedit_hud_helper.raycast(player)
	local look_dir = player:get_look_dir()
	
	local cur_pos = {}
	local player_pos = player:getpos()
	player_pos.y = player_pos.y + 1.5 -- Calculate from the eye position
	
	for i = 1,100 do
		i = i/10
		
		cur_pos.x = (look_dir.x*i) + player_pos.x
		cur_pos.y = (look_dir.y*i) + player_pos.y
		cur_pos.z = (look_dir.z*i) + player_pos.z
		
		local node
		node_name = minetest.get_node(cur_pos).name
		if node_name ~= "air" and node_name ~= "ignore" then
			return node_name
		end
	end
	
	return ""
end
