

minetest.register_node('br_core:water_source', {
    description = 'Water Source',
    groups = { nature = 1, dig_immediate = 2, water_source = 1, liquid = 3, water = 3, flowing = 0, dynamic_source=1 },

    tiles = {
        {name="(br_meta_blank.png^[colorize:#3383a6:255"..
        "^(br_meta_overlay_dirt_2.png^[colorize:#ffffff03:255))^[opacity:"..(br_core.dev_mode and "20" or "0"), backface_culling=true, align_style="world", scale=16},
        {name='blank.png', backface_culling=true},
        {name='blank.png', backface_culling=true},
    },
    use_texture_alpha = 'blend',
    drawtype = 'liquid',
    paramtype = 'light',
    waving = 0,

    walkable = false,
    is_ground_content = false,
    liquid_move_physics = true,
    move_resistance = 0,
    pointable = br_core.nodes_pointable or false,
    -- liquidtype = "source",
    liquid_viscosity = 0.1,
    liquid_renewable = false,
    liquid_range = 0,
    on_construct = function(pos)
        local node = minetest.get_node(vector.offset(pos, 0, 1, 0))
        if minetest.get_item_group(node.name, "liquid") > 0 then
            local thisnode = minetest.get_node(pos)
            thisnode.name = "br_core:water_source"
            minetest.swap_node(pos, thisnode)
            return true
        end
    end,
    _on_node_update = function(pos)
        local node = minetest.get_node(vector.offset(pos, 0, 1, 0))
        if minetest.get_item_group(node.name, "liquid") == 0 then
            local thisnode = minetest.get_node(pos)
            thisnode.name = "br_core:water_source_top"
            minetest.swap_node(pos, thisnode)
            return true
        end
    end,
    -- sounds = br_sounds.water(),
    -- liquid_alternative_source = "br_core:water_source",
    -- liquid_alternative_flowing = "br_core:water_flowing",
    post_effect_color = {a=200, r=0x23, g=0x3E, b=0x6C},
})
local water_box = {
    -8/16,  -8/16, -8/16,
     8/16,   6/16,     8/16
}
minetest.register_node('br_core:water_source_top', {
    description = 'Water Source',
    groups = { nature = 1, dig_immediate = 2, water_source = 1, liquid = 3, water = 3, flowing = 0, dynamic_source=1 },

    tiles = {
        {name="(br_meta_blank.png^[colorize:#4ab:255"..
        "^(br_meta_overlay_dirt_2.png^[colorize:#ffffff03:255))^[opacity:"..("225"), backface_culling=true, align_style="world", scale=16},
        {name='blank.png', backface_culling=true},
        {name='blank.png', backface_culling=true},
    },
    use_texture_alpha = 'blend',
    drawtype = 'nodebox',
    paramtype = 'light',
    waving = 0,
    node_box = {
        type = "fixed",
        fixed = water_box
    },

    walkable = false,
    is_ground_content = false,
    liquid_move_physics = true,
    move_resistance = 0,
    pointable = br_core.nodes_pointable or false,
    -- liquidtype = "source",
    liquid_viscosity = 0.1,
    liquid_renewable = false,
    liquid_range = 0,
    on_construct = function(pos)
        local node = minetest.get_node(vector.offset(pos, 0, 1, 0))
        if minetest.get_item_group(node.name, "liquid") > 0 then
            local thisnode = minetest.get_node(pos)
            thisnode.name = "br_core:water_source"
            minetest.swap_node(pos, thisnode)
            return true
        end
    end,
    _on_node_update = function(pos)
        local node = minetest.get_node(vector.offset(pos, 0, 1, 0))
        if minetest.get_item_group(node.name, "liquid") > 0 then
            local thisnode = minetest.get_node(pos)
            thisnode.name = "br_core:water_source"
            minetest.swap_node(pos, thisnode)
            return true
        end
    end,
    -- sounds = br_sounds.water(),
    -- liquid_alternative_source = "br_core:water_source",
    -- liquid_alternative_flowing = "br_core:water_flowing",
    post_effect_color = {a=200, r=0x23, g=0x3E, b=0x6C},
})

local pl = {}

minetest.register_globalstep(function(dtime)
    for _, player in pairs(minetest.get_connected_players()) do
        if not pl[player] then pl[player] = {time = 1} end
        local pi = player_info.get(player)
        local is_in_water = minetest.get_item_group(minetest.get_node(vector.offset(player:get_pos(), 0, 0.2, 0)).name, "liquid") > 0
        if is_in_water and not pl[player].is_in_water then
            pl[player].is_in_water = true
            minetest.sound_play("br_water_step", {
                gain = 0.2,
                object = player,
            })
        elseif not is_in_water then
            pl[player].is_in_water = false
        end
        if pl[player].can_play
        and is_in_water and pi and (pi.is_moving) then
            pl[player].handle = minetest.sound_play("br_water_step", {
                gain = 0.2,
                object = player,
            })
            minetest.sound_play("br_water_step", {
                gain = 0.2,
                pos = player:get_pos(),
            })
            pl[player].time = 1.2
            pl[player].can_play = false
        else
            pl[player].time = pl[player].time - dtime
            if pl[player].time < 0.3 then
                pl[player].can_play = true
            end
        end
    end
end)
