local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local debug = br_core.debug

local function build_variants(name, count, node)
    for i = 0, count-1 do
        local copy = table.copy(node)
        copy.tiles[1] = node.tiles[1].."_"..i..".png"
        copy.description = node.description.."_"..i..".png"
        minetest.register_node(name.."_"..i, copy)
        pmb_util.register_all_shapes(name.."_"..i)
    end
end

build_variants("br_core:pool_tiles", 3, {
    description = "br_core:pool_tiles",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = { "br_tiles" },
    sounds = br_sounds.tile(),
    light_source = (br_core.fullbright) or 0,
})

