local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local basic_items = {
    {"br_core:relocator"},
    {"br_core:flashlight","br_core:flashlight_on"},
}

minetest.register_on_joinplayer(function(player, last_login)
	player:set_lighting({ shadows = { intensity = tonumber(minetest.settings:get("br_shadow_intensity") or 0.33) } })
    local inv = player:get_inventory()
    for i, group in pairs(basic_items) do
        local stack = ItemStack(group[1])
        local has_item = false
        for k, item in pairs(group) do
            if inv:contains_item("main", ItemStack(item)) then
                has_item = true
                break
            end
        end
        if not has_item then
            inv:add_item("main", stack)
        end
    end
end)

br_core.on_changed_level_calls = {}
local call = br_core.on_changed_level_calls

function br_core.register_on_changed_level(func)
    call[#call+1] = func
end

function br_core.on_changed_level(player, from_level, to_level)
    for i, func in pairs(call) do
        func(player, from_level, to_level)
    end
end

minetest.register_globalstep(function(dtime)
    minetest.set_timeofday(0.49)
    for i, player in pairs(minetest.get_connected_players()) do
        local pos = player:get_pos()
        local level = br_core.get_level(player)
        local pli = br_spawn.player[player:get_player_name()]
        if pli.level ~= level and br_core.level[level] then
            br_core.on_changed_level(player, pli.level, level)
            pli.level = level
        end
    end
end)

br_core.register_on_changed_level(function(player, from_level, to_level)
    if (not br_core.dev_mode) and br_core.level[to_level] and br_core.level[to_level].sky then
        player:set_sky(br_core.level[to_level].sky)
    elseif not br_core.dev_mode then
        player:set_sky({
            base_color = "#001",
            type = "plain"
        })
    else
        player:set_sky({})
    end
end)


minetest.register_chatcommand("level", {
	params = "level [number]",
	description = S("Teleports the player to that level if it exists"),
	privs = {},
	func = function(name, param)
        local num = tonumber(param)
        local player = minetest.get_player_by_name(name)
        if type(num) == "number" and num >= 0 and num <= 180 then
            if br_core.level[num] then
                br_spawn.relocate_player(player, num)
                return true, S("Going to level "..num)
            end
        end
        local levels = ""
        for i, def in pairs(br_core.level) do
            levels = levels..(i)..", "
        end
        return false, minetest.colorize("#ffff99", ("That is not a level (yet)\nHere is a list of levels: \n"))..minetest.colorize("#99ff99", levels)
	end
})


--  add hand tool
minetest.override_item("", {
	wield_scale = { x = 1, y = 1, z = 1 },
    range = (br_core.nodes_pointable and 10) or nil,
	tool_capabilities = {
		full_punch_interval = 0.5,
		max_drop_level = 0,
		groupcaps = {
            oddly_breakable_by_hand = {
                times = { 0.1, 0.3, 2 },
                uses = 0,
            },
            cracky = {
                times = { 0.5, 0.8, 2 },
                uses = 0,
            },
        },
		damage_groups = { fleshy = 1 },
	}
})

