local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local basic_items = {
    ["br_core:relocator"] = true,
    ["br_core:flashlight"] = true,
    ["br_core:flashlight_on"] = true,
}
local start_kit = {
    "br_core:relocator",
    "br_core:flashlight"
}
-- prevent dropping important items
local CACHE_item_drop = minetest.item_drop
minetest.item_drop = function(itemstack, dropper, pos)
    if br_core.dev_mode or (basic_items[itemstack:get_name()] ~= true) then
        return CACHE_item_drop(itemstack, dropper, pos)
    else
        return itemstack
    end
end
-- prevent pulverize command
if not br_core.dev_mode then
    minetest.unregister_chatcommand("pulverize")
end

-- init the player on join
minetest.register_on_joinplayer(function(player, last_login)
    if player.set_lighting then -- compat
	    player:set_lighting({ shadows = { intensity = tonumber(minetest.settings:get("br_shadow_intensity") or 0.33) } })
    end

    player:hud_set_flags({
        minimap_radar = (br_core.dev_mode or false),
        minimap = (br_core.dev_mode or false),
        healthbar = (br_core.dev_mode or false),
        basic_debug = (br_core.dev_mode or false),
    })

    if not last_login then
        local inv = player:get_inventory()
        for i, itemname in pairs(start_kit) do
            inv:add_item("main", ItemStack(itemname))
        end
    end
end)

br_core.on_changed_level_calls = {}
local call = br_core.on_changed_level_calls

function br_core.register_on_changed_level(func)
    call[#call+1] = func
end

function br_core.on_changed_level(player, from_level, to_level)
    for i, func in pairs(call) do
        func(player, from_level, to_level)
    end
end

minetest.register_globalstep(function(dtime)
    minetest.set_timeofday(0.49)
    for i, player in pairs(minetest.get_connected_players()) do
        local pos = player:get_pos()
        local level = br_core.get_level(player)
        local pli = br_spawn.player[player:get_player_name()]
        if pli.level ~= level and br_core.level[level] then
            br_core.on_changed_level(player, pli.level, level)
            pli.level = level
        end
    end
end)

local default_sun = {
    visible = false,
    sunrise_visible = false,
}
local default_moon = {
    visible = false,
}
local default_sky = {
    clouds = false,
    base_color = "#001",
    type = "plain"
}

local function set_sky(player, param)
    player:set_sky(param or (default_sky))
end
local function set_sun(player, param)
    player:set_sun(param or (default_sun))
end
local function set_moon(player, param)
    player:set_moon(param or (default_moon))
end

br_core.register_on_changed_level(function(player, from_level, to_level)
    if (not br_core.dev_mode) and br_core.level[to_level] then
        set_sky(player, br_core.level[to_level].sky)
        set_sun(player, br_core.level[to_level].sun)
        set_moon(player, br_core.level[to_level].moon)
    elseif not br_core.dev_mode then
        player:set_sky({
            base_color = "#001",
            type = "plain"
        })
    else
        player:set_sky({})
    end
end)


minetest.register_chatcommand("level", {
	params = "level [number]",
	description = S("Teleports the player to that level if it exists"),
	privs = {},
	func = function(name, param)
        local num = tonumber(param)
        local player = minetest.get_player_by_name(name)
        if type(num) == "number" and num >= 0 and num <= 180 then
            if br_core.level[num] then
                br_spawn.relocate_player(player, num)
                return true, S("Going to level "..num)
            end
        end
        local levels = ""
        for i, def in pairs(br_core.level) do
            levels = levels..(i)..", "
        end
        local curlevel = "???"
        if br_spawn.player[name] then curlevel = br_spawn.player[name].level end
        return false, (minetest.colorize("#ffff99", ("List of levels: \n"))..minetest.colorize("#99ff99", levels)..
            "\nThis level: "..minetest.colorize("#ffff99", curlevel))
	end
})


--  add hand tool
minetest.override_item("", {
	wield_image = "blank.png",
	wield_scale = { x = 3, y = 3, z = 5 },
    range = (br_core.nodes_pointable and 10) or nil,
	tool_capabilities = {
		full_punch_interval = 0.5,
		max_drop_level = 0,
		groupcaps = {
            oddly_breakable_by_hand = {
                times = { 0.1, 0.3, 2 },
                uses = 0,
            },
            cracky = {
                times = { 0.5, 0.8, 2 },
                uses = 0,
            },
        },
		damage_groups = { fleshy = 1 },
	}
})

