# Backroom Test

A "game" for [Minetest](https://www.minetest.net/) [ContentDB link](https://content.minetest.net/packages/Sumianvoice/backroomtest/)

Place in your .minetest/games/ folder (inside a folder called "backroomtest" or something)

Keep in mind, this isn't a game in the usual sense, as there isn't much in the way of progression, you can't build, mine, collect items, or anything else you would normally do and this is intentional. It's meant to mimic some of the backrooms found footage videos and other stories various people have created, and so typical game features like digging and building wouldn't work at all. The player needs to be helpless and lost.

Basically, what would it be like if you no-clipped into the backrooms? What would your journey be like?

## Mission statement
To create liminal spaces that are familiar yet disconcerting for the player to be trapped in and explore.

Although inspiration is taken from various storied others have created, it isn't based on any particular canon, and so levels and features present on whatever wiki / video / etc can be added or not freely. It is its own canon. 

## Contributing and licenses
This is a personal project; I want to maintain full autonomy over the project and my code. That means:
- any contributions must not modify already licensed code unless that code was licensed by the contributor themselves
- all contributions must be explicitly licensed in a LICENSE file or in-line in the code
- if it can be done as a mod for the game, that's probably better as it keeps things compartmentalised

## Planned features
- several more levels
- more reason to explore
- more sounds, triggers, biomes
- some "outdoor" levels maybe (streetscapes etc)
- entities will only be benign or at least so incredibly rare that they are a distant, vague threat, and should be easily escapable yet terrifying

## What it isn't
- a horror game
- a survival game
- a simulation

## Features it will never have
- survival mechanics, hunger, thirst, etc etc etc unless there's a REALLY good way to do it that doesn't destroy immersion or punish the player / give them chores
- entities spawning all over the place
- smilers are dumb
- partygoers and other cringe
- a way "out" obviously

## Rough idea of the "canon"
- similar to the original concept, some of Kane Pixels's work, some of various wikis but not the cringe/SCP stuff.