local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

minetest.register_node("br_core:portal_0", {
    description = "portal",
    pointable = br_core.nodes_pointable or false,
    groups = { oddly_breakable_by_hand = 2, cracky = 1, backrooms_portal = 1 },
    tiles = {{
        animation = {type="vertical_frames", aspect_w = 16, aspect_h = 16, length = 2.0},
        name = "br_portal_0.png^[multiply:#647",
    }},
    use_texture_alpha = "clip",
    sounds = {},
    paramtype = "light",
    -- sunlight_propagates = true,
    walkable = false,
	post_effect_color = {a=255, r=0x23, g=0x22, b=0x22},
})
pmb_util.register_slab("br_core:portal_0", {no_world_align=true})

minetest.register_node("br_core:portal_1", {
    description = "portal, relocates to same level",
    pointable = br_core.nodes_pointable or false,
    groups = { oddly_breakable_by_hand = 2, cracky = 1, backrooms_portal = 2 },
    tiles = {{
        animation = {type="vertical_frames", aspect_w = 16, aspect_h = 16, length = 2.0},
        name = "br_portal_0.png^[multiply:#667",
    }},
    use_texture_alpha = "clip",
    sounds = {},
    paramtype = "light",
    -- sunlight_propagates = true,
    walkable = false,
	post_effect_color = {a=255, r=0x23, g=0x22, b=0x22},
})
pmb_util.register_slab("br_core:portal_1", {no_world_align=true})

minetest.register_node("br_core:portal_2", {
    description = "portal, relocates to random level",
    pointable = br_core.nodes_pointable or false,
    groups = { oddly_breakable_by_hand = 2, cracky = 1, backrooms_portal = 3 },
    tiles = {{
        animation = {type="vertical_frames", aspect_w = 16, aspect_h = 16, length = 2.0},
        name = "br_portal_0.png^[multiply:#612",
    }},
    use_texture_alpha = "clip",
    sounds = {},
    paramtype = "light",
    -- sunlight_propagates = true,
    walkable = false,
	post_effect_color = {a=255, r=0x23, g=0x22, b=0x22},
})
pmb_util.register_slab("br_core:portal_2", {no_world_align=true})

local function relocator(user)
    local pli = br_spawn.player[user:get_player_name()]
    local level_index = (br_core.level[pli.level].index + 0) % #br_core.level_for_index + 1
    level_index = br_core.level_for_index[level_index]
    br_spawn.relocate_player(user, level_index)
end
local function same_level_relocator(user)
    local pli = br_spawn.player[user:get_player_name()]
    br_spawn.relocate_player(user, pli.level)
end
local function random_level_relocator(user)
    local pli = br_spawn.player[user:get_player_name()]
    local level_index = math.random(#br_core.level_for_index)
    level_index = br_core.level_for_index[level_index]
    br_spawn.relocate_player(user, level_index)
end

minetest.register_globalstep(function(dtime)
    for i, player in pairs(minetest.get_connected_players() or {}) do
        local pos = vector.offset(player:get_pos(), 0, 1, 0)
        if (not minetest.is_creative_enabled(player:get_player_name())) then
            local portaltype = minetest.get_item_group(minetest.get_node(pos).name, "backrooms_portal")
            if portaltype ~= 0 then
                minetest.sound_play(("br_noclip"), {
                    gain = (br_sounds.master or 1) * 1,
                    pos = player:get_pos(),
                    pitch = (math.random()*0.2) + 0.80
                })
                if portaltype == 1 then
                    relocator(player)
                elseif portaltype == 2 then
                    same_level_relocator(player)
                elseif portaltype == 3 then
                    random_level_relocator(player)
                end
                minetest.sound_play(("br_noclip"), {
                    gain = (br_sounds.master or 1) * 1,
                    pos = player:get_pos(),
                    pitch = (math.random()*0.2) + 0.80
                })
            end
        end
    end
end)

