local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

br_core = {
    debug = false,
    level_height = 160,
    chunk_width = 80,
    fullbright = false, --debug
    mapgen = "nil",
    dev_mode = false,
    nodes_pointable = true,
}
if minetest.is_creative_enabled() then
    br_core.fullbright = 1
    br_core.dev_mode = true
    br_core.nodes_pointable = true
end
br_core.fullbright = 0

br_core.mapgen = minetest.get_mapgen_setting("mg_name")
-- set mapgen params if correct mapgen setting
if br_core.mapgen == "v7" then
    minetest.set_mapgen_params({
        mgname = "singlenode",
        flags = "nocaves,nodungeons,light,decorations,biomes,ores",
    })
end

dofile(mod_path .. DIR_DELIM .. "core" .. DIR_DELIM .. "soundspecs.lua")
dofile(mod_path .. DIR_DELIM .. "core" .. DIR_DELIM .. "inventory.lua")
dofile(mod_path .. DIR_DELIM .. "core" .. DIR_DELIM .. "frames.lua")
dofile(mod_path .. DIR_DELIM .. "core" .. DIR_DELIM .. "core.lua")
dofile(mod_path .. DIR_DELIM .. "core" .. DIR_DELIM .. "biome_register.lua")
dofile(mod_path .. DIR_DELIM .. "core" .. DIR_DELIM .. "mapgen.lua")
dofile(mod_path .. DIR_DELIM .. "core" .. DIR_DELIM .. "spawn.lua")
dofile(mod_path .. DIR_DELIM .. "core" .. DIR_DELIM .. "sounds.lua")
dofile(mod_path .. DIR_DELIM .. "core" .. DIR_DELIM .. "level_tracker.lua")
dofile(mod_path .. DIR_DELIM .. "core" .. DIR_DELIM .. "achievements.lua")

dofile(mod_path .. DIR_DELIM .. "achievements" .. DIR_DELIM .. "rebirth.lua")
dofile(mod_path .. DIR_DELIM .. "achievements" .. DIR_DELIM .. "scare.lua")
dofile(mod_path .. DIR_DELIM .. "achievements" .. DIR_DELIM .. "achievement_formspec.lua")

dofile(mod_path .. DIR_DELIM .. "items" .. DIR_DELIM .. "flashlight.lua")
dofile(mod_path .. DIR_DELIM .. "items" .. DIR_DELIM .. "relocator.lua")
-- makes nodes
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "main_nodes.lua")
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "core.lua")
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "water.lua")

-- dofile(mod_path .. DIR_DELIM .. "mapgen.lua")


