
local inventory = {
    width = 16,
    height = 6,
}
inventory.size = inventory.width * inventory.height

local function get_formspec(offset, size)
    if offset==nil then offset = {x=0,y=0} end
    if size==nil then size = {x=10,y=4} end
    return (
        "bgcolor[#ffffff90]"..
        "list[current_player;main;"..tostring(offset.x)..","..tostring(offset.y)..     ";"..(inventory.width)..","..(inventory.height-1)..";"..inventory.width.."]"..
        "list[current_player;main;"..tostring(offset.x)..","..tostring(0.3+offset.y+inventory.height-1)..";"..(inventory.width)..","..(1)..";]"..
        "listcolors[#66504f60;#554a6440]"
    )
end

local function get_craft_menu()
    return (
        "size["..inventory.width..","..(inventory.height+5).."]"..
        "list[current_player;craft;4,0.5;3,3;]"..
        "list[current_player;craftpreview;8,1.5;1,1;]"..
        get_formspec({x=0,y=4.5})..
        "style_type[image_button;bgcolor=#99eeff00;border=false]"..
        "image_button[14,2.5;1.5,1.5;br_achievement_button.png;openachievements; ]"
    )
end

local formspec = get_craft_menu()

minetest.register_on_joinplayer(function(player)
    player:set_inventory_formspec(formspec)
    local p_inv = player:get_inventory()
    p_inv:set_size("main", (br_core.dev_mode and inventory.size) or 6)
    player:set_nametag_attributes({
        -- text = " ",
        color = "#ffffff50",
        bgcolor = "#ffffff00"
    })
    if not br_core.dev_mode then player:hud_set_hotbar_itemcount(6)
    else player:hud_set_hotbar_itemcount(inventory.width) end
end)
