local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

br_core.level = {}
br_core.level_for_index = {}

function br_core.register_level(p)
    if p.level > 180 then error("CANNOT REGISTER LEVEL "..p.level.." AS IT WOULD EXCEED HEIGHT LIMIT") end
    if not p.biome_names then p.biome_names = {} end
    p.index = #br_core.level_for_index+1
    br_core.level[p.level] = p
    br_core.level_for_index[#br_core.level_for_index+1] = p.level
end
local biome_id_count = 0

function br_core.register_biome(p)
    biome_id_count = biome_id_count + 1
    p.uid = biome_id_count
    p.vert_schems = {}
    p.segheight = p.segheight or 80
    for i, schem in pairs(p.schems) do
        local all_layers = false
        if not schem.vertical_segments then
            schem.vertical_segments = {}
            all_layers = true
        end
        for k=0, math.floor(br_core.chunk_width / p.segheight) + 1 do
            if not p.vert_schems[k] then p.vert_schems[k] = {} end
            if all_layers or schem.vertical_segments[k] == 1 then
                for l=1, schem.prevalence or 1 do
                    p.vert_schems[k][#p.vert_schems[k]+1] = p.schems[i]
                end
            end
        end
    end
    if not br_core.level[p.level].biome then br_core.level[p.level].biome = {} end
    -- make a pointer to the biome so you can reference it by name
    if p.name and not br_core.level[p.level].biome_names[p.name] then
        br_core.level[p.level].biome_names[p.name] = {def=p, index=#br_core.level[p.level].biome+1}
    end
    for i=1, p.prevalence or 1 do
        br_core.level[p.level].biome[#br_core.level[p.level].biome+1] = p
    end
end
function br_core.index_to_level(index)
    return br_core.level_for_index[index]
end

function br_core.sort_levels()
    table.sort(br_core.level_for_index, function(a, b) return a < b end)
    for i, level in pairs(br_core.level_for_index) do
        br_core.level[level].index = i
    end
end

local default_loot_def = {{
    node_name      = "br_core:ceiling_conduit_rust",
    wherein		   = {"group:clear_after_mapgen"},
    clust_scarcity = 250,
    clust_num_ores = 1,
    clust_size	   = 5,
}}
function br_core.add_loot(level, loot_def)
    if not loot_def then loot_def = default_loot_def end
    minetest.register_ore({
        ore_type	   = "scatter",
        ore		       = loot_def.node_name      or "br_core:ceiling_conduit_rust",
        wherein		   = loot_def.wherein        or {"group:clear_after_mapgen"},
        clust_scarcity = loot_def.rarity         or 250,
        clust_num_ores = loot_def.clust_num_ores or 1,
        clust_size	   = loot_def.clust_size     or 1,
        y_min = level * br_core.level_height - br_core.offset,
        y_max = level * br_core.level_height - br_core.offset + br_core.level_height - 1,
    })
end
function br_core.add_loot_area(level, node_name, flags)
    if not flags then flags = {} end
    minetest.register_decoration({
        deco_type = "simple",
        place_on = flags.place_on or {"group:full_solid"},
        sidelen = 16,
        noise_params = flags.noise_params or {
            offset = 0.5,
            scale = 0.0,
            spread = {x = 1, y = 1, z = 1},
            seed = 8764,
            octaves = 1,
            persist = 0.2
        },
        y_min = flags.y_min or level * br_core.level_height - br_core.offset,
        y_max = flags.y_max or level * br_core.level_height - br_core.offset + br_core.level_height - 1,
        decoration = node_name,
        flags = flags.flags or "all_floors"
    })
end
minetest.register_on_mods_loaded(function()
    minetest.register_ore({
        ore_type       = "stratum",
        ore            = "air",
        wherein        = {"group:clear_after_mapgen"},
        y_min = -180 * br_core.level_height - br_core.offset,
        y_max =  180 * br_core.level_height - br_core.offset + br_core.level_height - 1,
    })
end)



--[[
====LAYOUT====
br_core.level
    LEVELNAME
        desc
        danger
        biome
            BIOMENAME
                schems
                on_generate
                danger
                desc
                level
]]
