local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

br_credits = {}

---@diagnostic disable: undefined-field

local full_license_text = ""

do -- get the full list of media licenses and all the files they cover
	local mods = core.get_modnames()
	local media_licenses = {}
	for i, modname in ipairs(mods) do
		local path = core.get_modpath(modname)
		local licensefile = io.open(path .. "/LICENSE", "r")
		if licensefile then
			local text = licensefile:read("a")
			local split = string.split(text, "===\nMedia Licenses\n===", false, 2)
			text = split[2] or ""
			local sections = string.split(text, "\n===", false)
			for k, section in ipairs(sections) do
				split = string.split(section, "\nFiles:\n", false)
				local license_text = split[1]
				license_text = string.gsub("$"..license_text, "$\n", "")
				local files = split[2]
				if files ~= nil then
					if not media_licenses[license_text] then media_licenses[license_text] = {} end
					table.insert(media_licenses[license_text], split[2])
				end
			end
		end
	end

	for license_text, section_list in pairs(media_licenses) do
		media_licenses[license_text] = table.concat(section_list, "\n")
		local list = {}
		for i, line in ipairs(string.split(media_licenses[license_text], "\n")) do
			if line ~= "" then
				table.insert(list, "    " .. line)
			end
		end
		media_licenses[license_text] = table.concat(list, "\n")
	end

	local txt = {}
	for license_text, section in pairs(media_licenses) do
		table.insert(txt, "")
		table.insert(txt, license_text)
		table.insert(txt, "Files:")
		table.insert(txt, section)
	end

	table.insert(txt, "")
	table.insert(txt, "")
	table.insert(txt, "")

	full_license_text = table.concat(txt, "\n")
end


br_credits.form = table.concat({
	table.concat({
        "formspec_version[6]size[20,12.5]position[0.5,0.5]anchor[0.5,0.5]",
        "bgcolor[#000]",
		"scroll_container[0,0.15;23,12.35;scroll;vertical;0.1]",
        "image[9,0.2;2,2;sumi.png]",
		"textarea[", 1, ",", 3, ";", 18, ",", 9, ";; ;",
			core.formspec_escape(table.concat({
				"    Sumi    <https://codeberg.org/SumianVoice> <https://github.com/SumianVoice>", "\n",
				S("- game design and project direction"), "\n",
				S("- game systems"), "\n",
				S("- textures, models, animations"), "\n",
				S("- most sounds"), "\n",
				S("- nodes and items"), "\n",
				S("- structures, map generation and environmental design"), "\n",
				"\n",
				S("    Anonymous 4chan user"), "\n",
				S("- the original concept of the backrooms"), "\n",
				"\n",
				S("    Various wikis and videos"), "\n",
				S("- expanded the lore to include some level ideas included in this game (1, 5, 12, 37)"), "\n",
				"\n",
				S("Although there are far too many people, one-shot videos, wikis and liminal images to list or to find, basically anyone who has contributed to backrooms lore before 2023 has probably influenced this project in some small way. However, no reference was intentionally made to any specific source of lore during the development of this project other than the original concept."), "\n",
				"\n",
				"Repository: https://codeberg.org/SumianVoice/backroomtest",
				"\n","\n","\n",
				S("Media licenses in verbose format:"),
			})),
		"]",
		"textarea[", 1, ",", 12.5, ";", 18, ",", 9, ";; ;",
			core.formspec_escape(full_license_text),
		"]",
		"scroll_container_end[]",
		"scrollbaroptions[arrows=hide;smallstep=10"..
		";thumbsize=20;max=100]",
		"scrollbar[19.3,0.25;0.7,12;vertical;scroll;0]",
	}),
})

full_license_text = ""
