
local inventory = {
    width = 16,
    height = 6,
}
inventory.size = inventory.width * inventory.height

local function get_formspec(offset, size)
    if offset==nil then offset = {x=0,y=0} end
    if size==nil then size = {x=10,y=4} end
    return (
        "bgcolor[#ffffff90]"..
        "list[current_player;main;"..tostring(offset.x)..","..tostring(offset.y)..     ";"..(inventory.width)..","..(inventory.height-1)..";"..inventory.width.."]"..
        "list[current_player;main;"..tostring(offset.x)..","..tostring(0.3+offset.y+inventory.height-1)..";"..(inventory.width)..","..(1)..";]"..
        "listcolors[#66504f60;#554a6440]"
    )
end

local function get_craft_menu(inv)
    return (
        "size["..inv.width..","..(inv.height+5).."]"..
        "list[current_player;craft;4,0.5;3,3;]"..
        "list[current_player;craftpreview;8,1.5;1,1;]"..
        get_formspec({x=0,y=4.5})..
        "style_type[image_button;bgcolor=#99eeff00;border=false]"..
        "image_button[14,2.5;1.5,1.5;br_achievement_button.png;openachievements; ]"
    )
end

local function get_hotbar_bg(inv)
    local w = inv.width
    local pw = 57
    local o = 4
    local ret = "[combine:"..math.ceil(w*pw+o).."x60"
    for i = 1, inv.width do
        ret = ret..":"..math.floor((i-1)*pw+o-2)..",0=br_inv_hotbar_bg.png\\^\\[opacity\\:50"
    end
    return ret
end

function br_core.update_player_formspec(player)
    local inv = table.copy(inventory)
    if not minetest.is_creative_enabled(player:get_player_name()) then
        inv.width = 6
        inv.height = 1
        inv.size = inv.width * inventory.height
    end

    local formspec = get_craft_menu(inv)
    player:set_inventory_formspec(formspec)
    local p_inv = player:get_inventory()
    p_inv:set_size("main", inv.size)

    player:hud_set_hotbar_itemcount(inv.width)
    player:hud_set_hotbar_selected_image("br_inv_itemslot_bg.png^[opacity:90")
    player:hud_set_hotbar_image(get_hotbar_bg(inv))

    player:set_nametag_attributes({
        -- text = " ",
        color = "#ffffff50",
        bgcolor = "#ffffff00"
    })
end

minetest.register_on_joinplayer(function(player)
    -- br_core.update_player_formspec(player)
end)
