local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

br_core = {
    debug = false,
    level_height = 160,
    chunk_width = 80,
    fullbright = false, --debug
    mapgen = "nil",
    generator = "main",
    dev_mode = false,
    nodes_pointable = true,
    offset = 32,
    loot_respawn_time = 60*30,
    mod_storage = core.get_mod_storage(),
    flags = {
        loot_crates = false,
        survival = false,
        doors_block_light = false,
        scary_doors = true,
    },
}

local save_path = core.get_worldpath()
local function find_backend()
    local file = io.open(save_path .. "/world.mt", "r")
    if not file then
        core.chat_send_all("ERROR: CANNOT OPEN world.mt TO CHECK BACKEND. ASSUMING \"sqlite3\".")
        return "sqlite3"
    end
    local content = file:read("*a")
    content = string.split(content, "\n")
    for i, line in pairs(content) do
        local st = string.split(line, " = ")
        if st[1] == "backend" then
            return st[2]
        end
    end
end

br_core.backend = find_backend()

if br_core.backend == "dummy" then
    br_core.mod_storage:set_string("br_enable_loot", "")
    br_core.mod_storage:set_string("br_survival", "")
end

if br_core.mod_storage:get_string("br_enable_loot") == "" then
    local setting = (core.settings:get_bool("br_enable_loot", false) and "1") or "0"
    br_core.mod_storage:set_string("br_enable_loot", setting)
end
if br_core.mod_storage:get_string("br_survival") == "" then
    local setting = (core.settings:get_bool("br_survival", false) and "1") or "0"
    br_core.mod_storage:set_string("br_survival", setting)
end

br_core.flags.loot_crates = (br_core.mod_storage:get_string("br_enable_loot") == "1")
br_core.flags.survival = (br_core.mod_storage:get_string("br_survival") == "1")

br_core.mapgen = core.get_mapgen_setting("mg_name")
-- set mapgen params if correct mapgen setting
if br_core.mapgen == "v7" then
    core.set_mapgen_setting("mg_name", "singlenode", true)
    core.set_mapgen_setting("mg_flags", "nocaves,nodungeons,light,decorations,biomes,ores", true)
end

if core.is_creative_enabled() or (br_core.mapgen == "flat") then
    br_core.fullbright = 1
    br_core.dev_mode = true
    br_core.nodes_pointable = true
end

if br_core.fullbright then
    core.register_on_mods_loaded(function()
        for iname, idef in pairs(core.registered_nodes) do
            local split = string.split(iname, ":")
            if #split == 2 then
                core.override_item(iname, {
                    sunlight_propagates = true,
                    paramtype = "light",
                })
            end
        end
    end)
end

if br_core.dev_mode then
    local _t = 0
    core.register_globalstep(function(dtime)
        _t = _t + dtime; if _t > 1 then _t = _t - 1 else return end
        for i, player in ipairs(core.get_connected_players()) do
            local pos1 = vector.offset(player:get_pos(), -10, -10, -10)
            local pos2 = pos1 + vector.new(20, 20, 20)
            core.fix_light(pos1, pos2)
        end
    end)
end



dofile(mod_path .. "/core" .. "/creative.lua")
dofile(mod_path .. "/core" .. "/on_generate.lua")
dofile(mod_path .. "/core" .. "/soundspecs.lua")
dofile(mod_path .. "/core" .. "/inventory.lua")
dofile(mod_path .. "/core" .. "/frames.lua")
dofile(mod_path .. "/core" .. "/core.lua")
dofile(mod_path .. "/core" .. "/sounds.lua")
dofile(mod_path .. "/core" .. "/spawn.lua")
dofile(mod_path .. "/core" .. "/level_tracker.lua")
dofile(mod_path .. "/core" .. "/achievements.lua")
dofile(mod_path .. "/core" .. "/credits.lua")
dofile(mod_path .. "/core" .. "/loot_tables.lua")

-- makes nodes
dofile(mod_path .. "/nodes" .. "/nodes_system.lua")
dofile(mod_path .. "/nodes" .. "/main_nodes.lua")
dofile(mod_path .. "/nodes" .. "/loot_sources.lua")
dofile(mod_path .. "/nodes" .. "/core.lua")
dofile(mod_path .. "/nodes" .. "/water.lua")
dofile(mod_path .. "/nodes" .. "/decoration.lua")
dofile(mod_path .. "/nodes" .. "/furniture.lua")
dofile(mod_path .. "/nodes" .. "/lights.lua")
dofile(mod_path .. "/nodes" .. "/doors.lua")

dofile(mod_path .. "/mapgen" .. "/mapgen.lua")

dofile(mod_path .. "/achievements" .. "/rebirth.lua")
dofile(mod_path .. "/achievements" .. "/scare.lua")
dofile(mod_path .. "/achievements" .. "/achievement_formspec.lua")

dofile(mod_path .. "/items" .. "/flashlight.lua")
dofile(mod_path .. "/items" .. "/relocator.lua")
dofile(mod_path .. "/items" .. "/food_system.lua")
dofile(mod_path .. "/items" .. "/food.lua")
dofile(mod_path .. "/items" .. "/drinks.lua")
dofile(mod_path .. "/items" .. "/supplies.lua")
dofile(mod_path .. "/items" .. "/keys.lua")

-- dofile(mod_path .. "/mapgen.lua")


