local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local function sch(name)
    return (mod_path .. "/schematics/" .. name .. ".mts")
end

br_core.register_level({
    level = 180,
    desc = "Level 180 \'the end\'",
    secret = true,
    danger = 0,
    grace_dist = 5,
    biome = {},
    segsize = 20,
    base_height = 42,
    biome_roughness = 2981.7138976,
    survival_stats = false,
    sun = {
        visible = true,
        sunrise_visible = false,
    },
    moon = {
        visible = false,
    },
    clouds = {
        density = 0.6,
        thickness = 2.3,
        ambient = "#fff",
        color = "#ffffff20",
        height = 180 * br_core.level_height - br_core.offset + 42 - 4.37 + 90,
        speed = {x=2.7, z=3}
    },
    sky = {
		base_color = "#ffffff",
		type = "regular",
		clouds = true,
		sky_color = {
			day_sky = "#3383a6" ,
			day_horizon = "#3383a6",
			dawn_sky = "#000" ,
			dawn_horizon = "#000",
			night_sky = "#263965" ,
			night_horizon = "#263965",
			indoors = "#263965",
			fog_sun_tint = "#263965",
			fog_moon_tint = "#263965",
			fog_tint_type = "custom",
		},
        fog = {
            fog_start = -1,
            fog_distance = -1,
        },
	},
})

br_core.register_biome({
    level = 180,
    desc = "Level 180 house",
    danger = 0,
    on_generate = nil,
    prevalence = 1,
    can_generate = function(seg_pos) -- must be deterministic
        if (seg_pos.x%18 == 0) and (seg_pos.z%18 == 0) then
            return true
        else
            return false
        end
    end,
    schems = {
        {name=sch("180_house_0")},
    }
})

br_core.register_biome({
    level = 180,
    desc = "Level 180",
    danger = 0,
    on_generate = nil,
    can_generate = function(pos) -- must be deterministic
        return true
    end,
    prevalence = 20,
    schems = {
        {name=sch("180_open_0")},
    }
})

br_core.register_biome({
    level = 180,
    desc = "Level 180",
    danger = 0,
    on_generate = nil,
    prevalence = 1,
    schems = {
        {name=sch("180_open_0")},
        {name=sch("180_open_0")},
        {name=sch("180_open_0")},
        {name=sch("180_open_0")},
        {name=sch("180_open_1")},
        {name=sch("180_open_2")},
        {name=sch("180_open_3")},
        {name=sch("180_open_4")},
        {name=sch("180_arch_0")},
        {name=sch("180_path_0")},
    }
})

br_core.register_biome({
    level = 180,
    desc = "Level 180",
    danger = 0,
    on_generate = nil,
    prevalence = 1,
    schems = {
        {name=sch("180_arch_0")},
        {name=sch("180_path_0")},
        {name=sch("180_path_0")},
        {name=sch("180_path_0")},
        {name=sch("180_path_1")},
        {name=sch("180_path_1")},
    }
})
br_core.register_on_changed_level(function(player, from_level, to_level)
    if to_level == 180 and from_level ~= nil then
        player:set_pos(vector.new(50,br_spawn.get_level_y(180),50))
    end
end)


local t_180_origin_sound = 6
local pl_180 = {}
br_core.register_on_level_enter(function(player, from_level, to_level)
    if to_level == 180 then
        pl_180[player] = true
        player:override_day_night_ratio(1)
    end
end)
br_core.register_on_level_exit(function(player, from_level, to_level)
    if from_level == 180 then
        pl_180[player] = nil
        player:override_day_night_ratio()
    end
end)

minetest.register_globalstep(function(dtime)
    t_180_origin_sound = t_180_origin_sound - dtime
    if t_180_origin_sound < 0 then t_180_origin_sound = t_180_origin_sound + (30 + math.random()*60) else return end
    for player,_ in pairs(pl_180) do repeat
        if core.is_player(player) then
            local pos = player:get_pos()
            local dist = vector.distance(pos, vector.new(-19, pos.y, -16))
            if dist < 80 then break end
            local dir = vector.copy(pos)
            dir.y = 0
            dir = vector.direction(dir, vector.new(
                -math.random() * 32,
                -math.random() * 32,
                -math.random() * 32
            ))
            core.sound_play("br_level_0_beep", {
                pos = pos + vector.multiply(dir, 20),
                to_player = player:get_player_name(),
                max_hear_distance = 999,
                gain = 0.3,
                start_time = 14.8,
            }, true)
        end
    until true end
end)
