local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local function sch(name)
    return (mod_path .. "/schematics/" .. name .. ".mts")
end

-- hotel
br_core.register_level({
    level = 5,
    desc = "Level 5",
    danger = 1,
    grace_dist = 5,
    biome = {},
    segsize = 20,
    base_height = 12,
    survival_stats = false,
    sun = {
        visible = false,
        texture = "blank.png",
        sunrise_visible = false,
    },
    moon = {
        visible = false,
    },
    sky = {
        clouds = false,
        base_color = "#001",
        type = "plain",
        fog = {
            fog_start = -1,
            fog_distance = -1,
        },
    },
})

br_core.register_biome({
    level = 5,
    desc = "Level 5 rust",
    danger = 1,
    on_generate = nil,
    can_generate = function(pos)
        return true
    end,
    segheight = 10,
    schems = {
        {name=sch("5_10h_rust_1_portal"), vertical_segments={1,1}},
        {name=sch("5_10h_rust_0"), rotation=0, vertical_segments={1,1}, prevalence=3},
        {name=sch("5_10h_rust_1"), rotation=0, vertical_segments={1,1}, prevalence=3},
        {name=sch("5_10h_rust_2"), rotation=0, vertical_segments={1,1}, prevalence=3},
    }
})

br_core.register_biome({
    level = 5,
    desc = "Level 0 orange",
    danger = 1,
    on_generate = nil,
    prevalence = 1,
    segheight = 10,
    schems = {
        {name=sch("5_10h_orange_2_portal"), vertical_segments={1,1}},
        {name=sch("5_10h_orange_0"), rotation=0, vertical_segments={1,1}, prevalence=3},
        {name=sch("5_10h_orange_1"), rotation=0, vertical_segments={1,1}, prevalence=3},
        {name=sch("5_10h_orange_2"), rotation=0, vertical_segments={1,1}, prevalence=3},
    }
})

br_core.register_biome({
    level = 5,
    desc = "Level 0 black",
    danger = 1,
    on_generate = nil,
    prevalence = 1,
    segheight = 10,
    schems = {
        {name=sch("5_10h_black_0"), rotation=0, vertical_segments={1,1}, prevalence=1},
        {name=sch("5_20h_black_stairs_0"), vertical_segments={1,0}, prevalence=1, skip_above=1},
        {name=sch("5_10h_black_1"), rotation=1, vertical_segments={1,1}, prevalence=1},
        {name=sch("5_10h_black_2"), rotation=1, vertical_segments={1,1}, prevalence=1},
        {name=sch("5_10h_black_3"), rotation=1, vertical_segments={1,1}, prevalence=1},
        {name=sch("5_10h_black_0"), rotation=0, vertical_segments={1,1}, prevalence=3},
        {name=sch("5_10h_black_1"), rotation=0, vertical_segments={1,1}, prevalence=6},
        {name=sch("5_10h_black_2"), rotation=0, vertical_segments={1,1}, prevalence=6},
        {name=sch("5_10h_black_3"), rotation=0, vertical_segments={1,1}, prevalence=6},
        {name=sch("5_10h_black_portal_0"), rotation=0, vertical_segments={1,1}, prevalence=2},
    }
})

br_core.register_level_sound({
    level = 5,
    time = 8,
    on_play = function(self, dtime, player)
        local can_play = false
        local playing = br_core.sound_get_tag("level5_hum", player)
        if playing == nil or #playing < 1
        or (playing and playing[1].fading and #playing <= 1) then can_play = true end
        if can_play then
            br_core.sound_play("level5_hum", player, {
                name = "br_fluorescent_hum",
                level = 5,
                gain = (br_sounds.master or 1) * (0.02 * math.random() + 0.001),
                fade = 0.01,
                to_player = player:get_player_name(),
                time = 8,
            })
        end
    end
})
