
local dig_immediate = (br_core.dev_mode and 3) or 0

local sign_box = {
    type = "fixed",
    fixed = {
        {
            (-4)/16, (-8)/16, (-1)/16,
            ( 4)/16, (-6)/16, ( 1)/16,
        },
        {
            (-7)/16, (-6)/16, (-2)/16,
            ( 7)/16, ( 3)/16, ( 2)/16,
        },
    },
}
core.register_node("br_core:sign_exit", {
    description = "br_core:sign_exit",
    pointable = br_core.nodes_pointable or false,
    groups = { oddly_breakable_by_hand = 2, dig_immediate = dig_immediate },
    drawtype = "nodebox",
    paramtype2 = "facedir",
    paramtype = "light",
    selection_box = sign_box,
    node_box = sign_box,
    sunlight_propagates = true,
    walkable = false,
    tiles = {
        { name = "br_sign_exit_side.png^[transformR180"},
        { name = "br_sign_exit_side.png^[transformR180"},
        { name = "br_sign_exit_side.png^[transformR180"},
        { name = "br_sign_exit_side.png^[transformR180"},
        { name = "br_sign_exit.png^[transformFY"},
        { name = "br_sign_exit.png^[transformR180"},
    },
    sounds = br_sounds.default(),
    light_source = 9,
    on_place = function(itemstack, placer, pointed_thing)
        return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
    end,
})
aom_tcraft.register_craft({output = "br_core:sign_exit", items = {unobtainable = 1}})

local flat_box = {
    type = "fixed",
    fixed = {
        {
            (-8)/16, (-7.9)/16, (-8)/16,
            ( 8)/16, (-7.8)/16, ( 8)/16,
        },
    },
}
core.register_node("br_core:sign_x", {
    description = "br_core:sign_x",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 0, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1, },
    drawtype = "nodebox",
    tiles = {
        "br_sign_x.png^[transformR90",
    },
    use_texture_alpha = "clip",
    sounds = br_sounds.default(),
    node_box = flat_box,
    selection_box = flat_box,
    paramtype2 = "facedir",
    paramtype = "light",
    light_source = 1,
    walkable = false,
    on_place = function(itemstack, placer, pointed_thing)
        return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
    end,
})
aom_tcraft.register_craft({output = "br_core:sign_x", items = {unobtainable = 1}})

core.register_node("br_core:sign_exclaim", {
    description = "br_core:sign_exclaim",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 0, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1, },
    drawtype = "nodebox",
    tiles = {
        "br_sign_exclaim.png^[transformR90",
    },
    use_texture_alpha = "clip",
    sounds = br_sounds.default(),
    node_box = flat_box,
    selection_box = flat_box,
    paramtype2 = "facedir",
    paramtype = "light",
    light_source = 1,
    walkable = false,
    on_place = function(itemstack, placer, pointed_thing)
        return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
    end,
})
aom_tcraft.register_craft({output = "br_core:sign_exclaim", items = {unobtainable = 1}})

core.register_node("br_core:sign_phone", {
    description = "br_core:sign_phone",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 0, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1, },
    drawtype = "nodebox",
    tiles = {
        "br_sign_phone.png^[transformR90",
    },
    use_texture_alpha = "clip",
    sounds = br_sounds.default(),
    node_box = flat_box,
    selection_box = flat_box,
    paramtype2 = "facedir",
    paramtype = "light",
    light_source = 1,
    walkable = false,
    on_place = function(itemstack, placer, pointed_thing)
        return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
    end,
})
aom_tcraft.register_craft({output = "br_core:sign_phone", items = {unobtainable = 1}})

core.register_node("br_core:sign_no_entry", {
    description = "br_core:sign_no_entry",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 0, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1, },
    drawtype = "nodebox",
    tiles = {
        "br_sign_no_entry.png^[transformR90",
    },
    use_texture_alpha = "clip",
    sounds = br_sounds.default(),
    node_box = flat_box,
    selection_box = flat_box,
    paramtype2 = "facedir",
    paramtype = "light",
    light_source = 1,
    walkable = false,
    on_place = function(itemstack, placer, pointed_thing)
        return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
    end,
})
aom_tcraft.register_craft({output = "br_core:sign_no_entry", items = {unobtainable = 1}})

for i=0, 1 do
    core.register_node("br_core:sign_various_"..i, {
        description = "br_core:sign_various_"..i,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 0, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1, },
        drawtype = "nodebox",
        tiles = {
            "br_sign_various_"..i..".png^[transformR90",
        },
        use_texture_alpha = "clip",
        sounds = br_sounds.default(),
        node_box = flat_box,
        selection_box = flat_box,
        paramtype2 = "facedir",
        paramtype = "light",
        light_source = 1,
        walkable = false,
        on_place = function(itemstack, placer, pointed_thing)
            return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
        end,
    })
    aom_tcraft.register_craft({output = "br_core:sign_various_"..i, items = {unobtainable = 1}})
end

local alarm_box = {
    type = "fixed",
    fixed = {
        {
            ( 0)/16, (-8)/16, (-2)/16,
            ( 6)/16, (-5)/16, ( 2)/16,
        },
    },
}
core.register_node("br_core:fire_alarm", {
    description = "br_core:fire_alarm",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 0, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1, },
    drawtype = "nodebox",
    tiles = {
        "br_fire_alarm.png^[transformR90",
        "br_fire_alarm.png^[transformR90",
        "br_fire_alarm.png^[transformR180", -- bottom
        "br_fire_alarm.png^[transformR180", -- top
        "br_fire_alarm.png^[transformR270", -- right
        "br_fire_alarm.png^[transformR90",
    },
    use_texture_alpha = "opaque",
    sounds = br_sounds.default(),
    node_box = alarm_box,
    selection_box = alarm_box,
    paramtype2 = "facedir",
    paramtype = "light",
    walkable = false,
    on_place = function(itemstack, placer, pointed_thing)
        return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
    end,
})
aom_tcraft.register_craft({output = "br_core:fire_alarm", items = {unobtainable = 1}})

local socket_box = {
    type = "fixed",
    fixed = {
        {
            (-4)/16, (-8)/16, (-4)/16,
            ( 0)/16, (-7)/16, ( 4)/16,
        },
    },
}
core.register_node("br_core:power_socket", {
    description = "br_core:power_socket",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 0, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1, },
    drawtype = "nodebox",
    tiles = {
        "br_power_socket.png^[transformR90",
        "br_power_socket.png^[transformR90",
        "br_power_socket.png^[transformR180", -- bottom
        "br_power_socket.png^[transformR180", -- top
        "br_power_socket.png^[transformR270", -- right
        "br_power_socket.png^[transformR90",
    },
    use_texture_alpha = "opaque",
    sounds = br_sounds.default(),
    node_box = socket_box,
    selection_box = socket_box,
    paramtype2 = "facedir",
    paramtype = "light",
    walkable = false,
    on_place = function(itemstack, placer, pointed_thing)
        return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
    end,
})
aom_tcraft.register_craft({output = "br_core:power_socket", items = {unobtainable = 1}})

local function place_door_handle(pos, placer, itemstack, pointed_thing)
    if not core.is_player(placer) then return end
    local ctrl = placer:get_player_control()
    if ctrl.aux1 then
        local node = core.get_node(pos)
        node.name = node.name.."_outer"
        core.swap_node(pos, node)
    end
end
-- door handle

local function register_door_handle(name, box)
    local handle = {
        description = "br_core:door_handle_0",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 0, oddly_breakable_by_hand = 2, dig_immediate = dig_immediate },
        tiles = {{
            name = "br_meta_blank.png^[colorize:#eef:255^(br_meta_overlay_dirt_1.png^[multiply:#753^[opacity:10)",
            align_style = "world",
            scale = 16,
        }},
        drawtype = "nodebox",
        sounds = br_sounds.default(),
        node_box = nodebox,
        selection_box = {
            type = "fixed",
            fixed = {{
                -4/16, -16/16, -4/16,
                 4/16,  -6/16,  4/16,
            }}},
        paramtype2 = "facedir",
        paramtype = "light",
        sunlight_propagates = true,
        walkable = false,
        on_place = function(itemstack, placer, pointed_thing)
            return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
        end,
    }
    -- make inner
    handle.node_box = box
    handle.drop = name
    handle.after_place_node = nil
    core.register_node(name.."_outer", table.copy(handle))
    local offset = -8/16 -- pushes the handle back so it matches up with a half slab, which is applied to the two y vals below
    for i, nb in pairs(box.fixed) do
        nb[2] = nb[2] + offset
        nb[5] = nb[5] + offset
    end
    handle.after_place_node = place_door_handle
    core.register_node(name, handle) -- don't need copy because it's the last one
	aom_tcraft.register_craft({output = name, items = {unobtainable = 1}})
end

register_door_handle("br_core:door_handle_0", {
    type = "fixed",
    fixed = {
        {
            -2/16, (-8)/16, -2/16,
             2/16, (-6)/16,  2/16,
        },
    },
})

register_door_handle("br_core:door_handle_1", {
    type = "fixed",
    fixed = {
        {
            (-1-5)/16, (-8)/16, -1/16,
            ( 1-5)/16, (-7)/16,  1/16,
        },
        {
            (-1+5)/16, (-8)/16, -1/16,
            ( 1+5)/16, (-7)/16,  1/16,
        },
        {
            -6/16, (-7)/16, -1/16,
             6/16, (-6)/16,  1/16,
        },
    },
})

local window_1x1_box = {
    type = "fixed", fixed = {
        -8/16, -8/16, -2/16,
         8/16,  8/16,  2/16,
    }
}

for variant, color in pairs(br_core.node_colors) do
    local name = "br_core:window_" .. variant .. "_0"
    core.register_node(name, {
        description = "",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, oddly_breakable_by_hand = 2, furniture = 1, },
        drawtype = "mesh",
        mesh = "br_window_0.obj",
        tiles = {{
            name = "br_white.png^[multiply:" .. color.main .. "^[hsl:0:-20:0" ..
            "^(br_meta_overlay_dirt_5.png^[multiply:#222^[opacity:60)",
            backface_culling = true,
        }},
        paramtype = "light",
        paramtype2 = "facedir",
        sunlight_propagates = true,
        collision_box = window_1x1_box,
        selection_box = window_1x1_box,
        sounds = br_sounds.concrete(),
    })
	aom_tcraft.register_craft({output = name, items = {unobtainable = 1}})
end

local multinode_2x2 = {
    nodes = {
        {vector.new(1, 0, 0), {name="br_core:blocker"}},
        {vector.new(1, 1, 0), {name="br_core:blocker"}},
        {vector.new(0, 1, 0), {name="br_core:blocker"}},
    },
    no_dig_if_missing_nodes = true,
    no_rotation = false,
}

local window_2x2_box = {
    type = "fixed", fixed = {
        -8/16, -8/16, -2/16,
        24/16, 24/16,  2/16,
    }
}

for variant, color in pairs(br_core.node_colors) do
    local name = "br_core:window_2x2_" .. variant .. "_0"
    core.register_node(name, {
        description = "",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, oddly_breakable_by_hand = 2, furniture = 1, },
        drawtype = "mesh",
        mesh = "br_window_2x2_0.obj",
        tiles = {{
            name = "br_white.png^[multiply:" .. color.main .. "^[hsl:0:-20:0" ..
            "^(br_meta_overlay_dirt_5.png^[multiply:#222^[opacity:60)",
            backface_culling = true,
        }},
        paramtype = "light",
        paramtype2 = "facedir",
        sunlight_propagates = true,
        collision_box = window_2x2_box,
        selection_box = window_2x2_box,
        sounds = br_sounds.concrete(),
        _multinode = multinode_2x2,
    })
	aom_tcraft.register_craft({output = name, items = {unobtainable = 1}})
end

for variant, color in pairs(br_core.node_colors) do
    local name = "br_core:window_2x2_" .. variant .. "_0_broken_0"
    core.register_node(name, {
        description = "",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, oddly_breakable_by_hand = 2, furniture = 1, },
        drawtype = "mesh",
        mesh = "br_window_2x2_0_broken_0.obj",
        tiles = {{
            name = "br_white.png^[multiply:" .. color.main .. "^[hsl:0:-20:0" ..
            "^(br_meta_overlay_dirt_5.png^[multiply:#222^[opacity:60)",
            backface_culling = true,
        }},
        paramtype = "light",
        paramtype2 = "facedir",
        sunlight_propagates = true,
        collision_box = window_2x2_box,
        selection_box = window_2x2_box,
        sounds = br_sounds.concrete(),
        _multinode = multinode_2x2,
    })
	aom_tcraft.register_craft({output = name, items = {unobtainable = 1}})
end

for variant, color in pairs(br_core.node_colors) do
    local name = "br_core:blinds_2x2_" .. variant .. "_0"
    core.register_node(name, {
        description = "",
        pointable = br_core.dev_mode or false,
        groups = { solid = 1, oddly_breakable_by_hand = 2, furniture = 1, },
        drawtype = "mesh",
        mesh = "br_blinds_2x2_0.obj",
        tiles = {{
            name = "br_white.png^[multiply:" .. color.main .. "^[hsl:0:-20:0" ..
            "^(br_meta_overlay_dirt_5.png^[multiply:#222^[opacity:60)",
            backface_culling = true,
        }},
        paramtype = "light",
        paramtype2 = "facedir",
        sunlight_propagates = true,
        selection_box = window_1x1_box,
        sounds = br_sounds.concrete(),
        walkable = false,
    })
	aom_tcraft.register_craft({output = name, items = {unobtainable = 1}})
end

for variant, color in pairs(br_core.node_colors) do
    local name = "br_core:blinds_2x1_" .. variant .. "_0"
    core.register_node(name, {
        description = "",
        pointable = br_core.dev_mode or false,
        groups = { solid = 1, oddly_breakable_by_hand = 2, furniture = 1, },
        drawtype = "mesh",
        mesh = "br_blinds_2x1_0.obj",
        tiles = {{
            name = "br_white.png^[multiply:" .. color.main .. "^[hsl:0:-20:0" ..
            "^(br_meta_overlay_dirt_5.png^[multiply:#222^[opacity:60)",
            backface_culling = true,
        }},
        paramtype = "light",
        paramtype2 = "facedir",
        sunlight_propagates = true,
        selection_box = window_1x1_box,
        sounds = br_sounds.concrete(),
        walkable = false,
    })
	aom_tcraft.register_craft({output = name, items = {unobtainable = 1}})
end

for variant, color in pairs(br_core.node_colors) do
    local name = "br_core:blinds_1x1_" .. variant .. "_0"
    core.register_node(name, {
        description = "",
        pointable = br_core.dev_mode or false,
        groups = { solid = 1, oddly_breakable_by_hand = 2, furniture = 1, },
        drawtype = "mesh",
        mesh = "br_blinds_1x1_0.obj",
        tiles = {{
            name = "br_white.png^[multiply:" .. color.main .. "^[hsl:0:-20:0" ..
            "^(br_meta_overlay_dirt_5.png^[multiply:#222^[opacity:60)",
            backface_culling = true,
        }},
        paramtype = "light",
        paramtype2 = "facedir",
        sunlight_propagates = true,
        selection_box = window_1x1_box,
        sounds = br_sounds.concrete(),
        walkable = false,
    })
	aom_tcraft.register_craft({output = name, items = {unobtainable = 1}})
end


for variant, color in pairs(br_core.node_colors) do
	for i = 0, 2 do
		local name = "br_core:blinds_2x2_" .. variant .. "_0_broken_"..i
		core.register_node(name, {
			description = "",
			pointable = br_core.dev_mode or false,
			groups = { solid = 1, oddly_breakable_by_hand = 2, furniture = 1, },
			drawtype = "mesh",
			mesh = "br_blinds_2x2_0_broken_"..i..".obj",
			tiles = {{
				name = "br_white.png^[multiply:" .. color.main .. "^[hsl:0:-20:0" ..
				"^(br_meta_overlay_dirt_5.png^[multiply:#222^[opacity:60)",
				backface_culling = true,
			}},
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			selection_box = window_1x1_box,
			sounds = br_sounds.concrete(),
			walkable = false,
		})
		aom_tcraft.register_craft({output = name, items = {unobtainable = 1}})
	end
end
