
local water_box = {
    -8/16,  -8/16, -8/16,
     8/16,   6/16,     8/16
}
local is_fancy = core.settings:get("leaves_style")
is_fancy = (is_fancy == "") or (is_fancy == "fancy")

local function typical_water_source(name, tile_top, overrides)
    local def = {
        description = 'Water Source',
        groups = { nature = 1, dig_immediate = (br_core.dev_mode and 2) or 0,
            water_source = 1, liquid = 3, water = 3, flowing = 0, dynamic_source=1,
            liquid_sink = 10,},
        tiles = {
            tile_top,
            {name='blank.png', backface_culling=true},
            {name='blank.png', backface_culling=true},
        },
        use_texture_alpha = 'blend',
        drawtype = 'liquid',
        paramtype = 'light',
        waving = 0,
        walkable = false,
        is_ground_content = false,
        liquid_move_physics = true,
        move_resistance = 2,
        pointable = br_core.nodes_pointable or false,
        liquid_renewable = false,
        liquid_range = 0,
        _on_node_update = function(pos)
            local node = core.get_node(vector.offset(pos, 0, 1, 0))
            if core.get_item_group(node.name, "liquid") == 0 then
                local thisnode = core.get_node(pos)
                thisnode.name = "br_core:water"..(name and ("_" .. name) or "").."_source_top"
                core.swap_node(pos, thisnode)
                return true
            end
        end,
    }
    for k, v in pairs(overrides or {}) do
        def[k] = v
    end
    return def
end

local function typical_water_top(name, tile_top, overrides)
    local def = {
        description = 'Water Source',
        groups = { nature = 1, dig_immediate = (br_core.dev_mode and 2) or 0,
            water_source = 1, liquid = 1, water = 1, flowing = 0, dynamic_source=1,
            liquid_sink = 10,},
        tiles = {
            tile_top,
            {name='blank.png', backface_culling=true},
            {name='blank.png', backface_culling=true},
        },
        use_texture_alpha = 'blend',
        drawtype = (is_fancy and 'nodebox') or "liquid",
        paramtype = 'light',
        waving = 0,
        node_box = {
            type = "fixed",
            fixed = water_box
        },
        walkable = false,
        is_ground_content = false,
        liquid_move_physics = true,
        move_resistance = 2,
        pointable = br_core.nodes_pointable or false,
        liquid_viscosity = 0.1,
        liquid_renewable = false,
        liquid_range = 0,
        _on_node_update = function(pos)
            local node = core.get_node(vector.offset(pos, 0, 1, 0))
            if core.get_item_group(node.name, "liquid") > 0 then
                local thisnode = core.get_node(pos)
                thisnode.name = "br_core:water"..(name and ("_" .. name) or "").."_source"
                core.swap_node(pos, thisnode)
                return true
            end
        end,
    }
    for k, v in pairs(overrides or {}) do
        def[k] = v
    end
    return def
end

core.register_node('br_core:water_source', typical_water_source(
    nil,
    {name="(br_meta_blank.png^[colorize:#3383a6:255"..
    "^(br_meta_overlay_dirt_2.png^[colorize:#ffffff03:255))^[opacity:"..(br_core.dev_mode and "20" or "0"),
    backface_culling=true, align_style="world", scale=16},
    {
        post_effect_color = {a=200, r=0x23, g=0x3E, b=0x6C},
    }
))

core.register_node('br_core:water_source_top', typical_water_top(
    nil,
    {name="(br_meta_blank.png^[colorize:#4ab:255"..
    "^(br_meta_overlay_dirt_2.png^[colorize:#ffffff05:255))^[opacity:"..("225"),
    backface_culling=true, align_style="world", scale=16},
    {
        post_effect_color = {a=200, r=0x23, g=0x3E, b=0x6C},
    }
))


core.register_node('br_core:water_green_source', typical_water_source(
    "green",
    {name="(br_meta_blank.png^[colorize:#6b8481:255"..
    "^(br_meta_overlay_dirt_2.png^[colorize:#ffffff03:255))^[opacity:"..(br_core.dev_mode and "20" or "0"),
    backface_culling=true, align_style="world", scale=16},
    {post_effect_color = "#151c14".."fa",}
))

core.register_node('br_core:water_green_source_top', typical_water_top(
    "green",
    {name="(br_meta_blank.png^[colorize:#3c4e3d:255"..
    "^(br_meta_overlay_dirt_2.png^[colorize:#ffffff03:255))^[opacity:"..("225")..
    "^(br_meta_overlay_dirt_2.png^[colorize:#ffffff10:255)",
    backface_culling=true, align_style="world", scale=16},
    {post_effect_color = "#293126".."f6"}
))


local pl = {}

core.register_globalstep(function(dtime)
    for _, player in pairs(core.get_connected_players()) do
        if not pl[player] then pl[player] = {time = 1} end
        local pi = player_info.get(player)
        local node = core.get_node(vector.offset(player:get_pos(), 0, 0, 0))
        local waterness = core.get_item_group(node.name, "liquid")
        local is_in_water = waterness > 0
        if is_in_water and not pl[player].is_in_water then
            pl[player].is_in_water = true
            core.sound_play("br_water_step", {
                gain = 0.2,
                object = player,
            })
        elseif not is_in_water then
            pl[player].is_in_water = false
        end
        if pl[player].can_play
        and is_in_water and pi and (pi.is_moving) then
            pl[player].handle = core.sound_play("br_water_step", {
                gain = 0.2,
                object = player,
            })
            core.sound_play("br_water_step", {
                gain = 0.2,
                pos = player:get_pos(),
            })
            pl[player].time = 1.2
            pl[player].can_play = false
        else
            pl[player].time = pl[player].time - dtime
            if pl[player].time < 0.3 then
                pl[player].can_play = true
            end
        end

        -- water physics
        if (core.get_modpath("playerphysics") ~= nil) then
            if (waterness >= 3 ) then
                if playerphysics.get_physics_factor(player, "liquid_sink", "br_core:water") ~= -2 then
                    playerphysics.add_physics_factor(player, "liquid_sink", "br_core:water", -2)
                end
            elseif (waterness > 0 ) then
                if playerphysics.get_physics_factor(player, "liquid_sink", "br_core:water") ~= 2 then
                    playerphysics.add_physics_factor(player, "liquid_sink", "br_core:water", 2)
                end
            end
        end
    end
end)

core.register_on_joinplayer(function(player, last_login)
end)
