local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local creative_setting = minetest.is_creative_enabled()
br_core.disable_take_item = false

function minetest.is_creative_enabled(name)
    if not name then return creative_setting end
    local player = minetest.get_player_by_name(name)
    return (player and player:get_meta():get_string("creative") == "true") or false
end

function br_core.set_creative_hand(player, bool)
    local inv = player:get_inventory()
    inv:set_size("hand", 1)
    if bool then
        inv:set_stack("hand", 1, ItemStack("br_core:creative_hand"))
    else
        inv:set_stack("hand", 1, ItemStack(""))
    end
end

function br_core.set_creative(player, bool, force)
    local name = player:get_player_name()
    bool = bool or false -- no nil
    local meta = player:get_meta()
    local is_creative = meta:get_string("creative") == "true"
    local changed = force or (is_creative ~= bool)
    if not changed then return end

    meta:set_string("creative", (bool and "true") or "")

    br_core.set_creative_hand(player, bool)

    br_core.update_player_formspec(player)
    if core.get_modpath("br_creative_helpers") ~= nil then
        aom_tcraft.pi(player).timer = -11
        core.after(0.1, function()
            br_creative_helpers.tcraft.force_update_formspec(player)
        end)
    end
end

minetest.register_on_joinplayer(function(player, last_login)
    if not last_login then
        br_core.set_creative(player, creative_setting or br_core.mapgen=="flat", true)
    -- make sure not to shrink existing players' inventories and destroy their items if migrating from old save
    elseif minetest.is_creative_enabled(player:get_player_name()) or br_core.mapgen=="flat" then
        br_core.set_creative(player, true, true)
    else
        br_core.set_creative(player, minetest.is_creative_enabled(player:get_player_name()), true)
    end
end)

minetest.register_privilege("creative", {
	description = S("Lets players change their creative status"),
	give_to_singleplayer = true
})

minetest.register_chatcommand("creative", {
	params = "/creative on|off",
	description = S("Turns on or off some features"),
	privs = {creative=true},
	func = function(name, param)
        local player = minetest.get_player_by_name(name)
        if param == "off" then
            br_core.set_creative(player, false)
            return true, "Set creative off for "..name.."."
        elseif param == "on" then
            br_core.set_creative(player, true)
            return true, "Set creative on for "..name.."."
        elseif param == "ignore" then
            player:get_meta():set_string("seen_creative_warning", "true")
            return true, "Never showing creative warning again."
        else
            return false, "Error: Please use [/creative on] or [/creative off]."
        end
	end
})

-- don't take items when in creative if it's the last item
local core_item_place = minetest.item_place_node
minetest.item_place_node = function(itemstack, placer, pointed_thing, param2, prevent_after_place, ...)
    local ret, pos = core_item_place(ItemStack(itemstack), placer, pointed_thing, param2, prevent_after_place, ...)
    local is_creative = core.is_player(placer) and minetest.is_creative_enabled(placer:get_player_name())
    -- don't take the last item in the stack
    if is_creative then
        return ((br_core.disable_take_item or ret:is_empty()) and itemstack or ret), pos
    else
        return ret, pos
    end
end
