local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

--[[
br_bottle.png
br_bottle_fill.png
br_bottle_label.png
br_bottle_shine.png
--]]

function br_core.get_bottle_texture(def)
    local t = {}
    local C
    function C(a) table.insert(t, a); return C end
    C"(br_bottle.png^[multiply:"(def.color_bottle or "#ccc")"^[opacity:"(def.opacity_bottle or "255")")"
    C"^(br_bottle_fill.png^[multiply:"(def.color_fill or "#aaa")"^[opacity:"(def.opacity_fill or "80")")"
    C"^(br_bottle_label.png^[multiply:"(def.color_label or "#eee")
        C"^[opacity:"(def.color_label and (def.opacity_label or "255") or def.opacity_label or "0")")"
    C"^(br_bottle_shine.png^[multiply:"(def.color_shine or "#fff")")"
    C"^(br_bottle_cap.png^[multiply:"(def.color_cap or def.color_label or "#fff")")"
    return table.concat(t)
end

core.register_craftitem("br_core:bottle", {
    description = S("Bottle"),
    inventory_image = br_core.get_bottle_texture({
        --
    }),
    wield_image = br_core.get_bottle_texture({
        opacity_fill = "200",
    }),
    groups = { junk = 1 },
    stack_max = 1,
    _empty_item = "br_core:bottle",
})

core.register_craftitem("br_core:bottle_cola", {
    description = S("Bottle of Cola"),
    inventory_image = br_core.get_bottle_texture({
        color_fill = "#302420", opacity_fill = "150",
        color_label = "#d94c4f", opacity_label = "255",
    }),
    groups = { drink = 1 },
    stack_max = 1,
    on_secondary_use = br_core.food_on_rightclick,
    on_place = br_core.food_on_rightclick,
    _empty_item = "br_core:bottle",
    _thirst = 70,
    _hunger = 10,
})

core.register_craftitem("br_core:bottle_water", {
    description = S("Bottle of Clean Water"),
    inventory_image = br_core.get_bottle_texture({
        color_bottle = "#abd",
        color_fill = "#8bd", opacity_fill = "160",
        color_label = "#35a", opacity_label = "255",
    }),
    wield_image = br_core.get_bottle_texture({
        color_bottle = "#abd",
        color_fill = "#8bd", opacity_fill = "200",
        color_label = "#35a", opacity_label = "255",
    }),
    groups = { drink = 1 },
    stack_max = 1,
    on_secondary_use = br_core.food_on_rightclick,
    on_place = br_core.food_on_rightclick,
    _empty_item = "br_core:bottle",
    _thirst = 100,
})

core.register_craftitem("br_core:bottle_water_dirty", {
    description = S("Bottle of Dirty Water"),
    inventory_image = br_core.get_bottle_texture({
        color_bottle = "#a2b4a9",
        color_fill = "#344d3e", opacity_fill = "120",
        color_label = "#fff", opacity_label = "0",
        color_cap = "#35a",
    }),
    wield_image = br_core.get_bottle_texture({
        color_bottle = "#a2b4a9",
        color_fill = "#344d3e", opacity_fill = "200",
        color_label = "#fff", opacity_label = "0",
        color_cap = "#35a",
    }),
    groups = { junk = 1 },
    stack_max = 1,
})

core.register_craftitem("br_core:carton_orange_juice", {
description = S("Orange Juice"),
    inventory_image = "br_carton_orange_juice.png",
    groups = { drink = 1 },
    stack_max = 1,
    on_secondary_use = br_core.food_on_rightclick,
    on_place = br_core.food_on_rightclick,
    _thirst = 70,
    _hunger = 10,
})

core.register_craftitem("br_core:carton_banana_juice", {
    description = S("Banana Juice"),
    inventory_image = "br_carton_banana_juice.png",
    groups = { drink = 1 },
    stack_max = 1,
    on_secondary_use = br_core.food_on_rightclick,
    on_place = br_core.food_on_rightclick,
    _thirst = 60,
    _hunger = 20,
})
