local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local function sch(name)
    return (mod_path .. "/schematics/" .. name .. ".mts")
end

local level = 0

br_core.register_level({
    level = level,
    desc = "Level 0",
    danger = 1,
    grace_dist = 5,
    biome = {},
    segsize = 20,
    base_height = 28,
    biome_roughness = 195,
    biome_pixelization = 4,
    sky = {
        clouds = false,
        base_color = "#001",
        type = "plain",
        fog = {
            fog_start = -1,
            fog_distance = -1,
        },
    },
})

br_core.register_biome({
    level = level,
    desc = "Level 0 columns",
    danger = 1,
    on_generate = nil,
    segheight = 20,
    can_generate = function(pos) -- must be deterministic
        if vector.distance(pos, vector.new(0, pos.y, 0)) > 10
        and vector.distance(pos, vector.new(0, pos.y, 0)) < 30 then
            return false
        else
            return true
        end
    end,
    schems = {
        {name=sch("0_20_1_columns_0"), vertical_segments={1,0}},
        {name=sch("0_20_2_columns_0"), vertical_segments={0,1}, rotation=0},
    }
})
br_core.register_biome({
    level = level,
    desc = "Level 0 main",
    danger = 1,
    on_generate = nil,
    segheight = 20,
    prevalence = 5,
    schems = {
        {name=sch("0_20_1_columns_0"), vertical_segments={1,0}},
        --
        {name=sch("0_20_2_columns_0"), vertical_segments={0,1}, rotation=0},
        {name=sch("0_20_2_pitfalls_0"), vertical_segments={0,1}, can_generate=function(pos, perlin)
            return ((pos.x%3==0) and pos.z%2==0)
        end},
        {name=sch("0_20_2_walls_0"), vertical_segments={0,1}},
        {name=sch("0_20_2_walls_1"), vertical_segments={0,1}},
        {name=sch("0_20_2_walls_2"), vertical_segments={0,1}},
        {name=sch("0_20_2_walls_3"), vertical_segments={0,1}},
    }
})
br_core.register_biome({
    level = level,
    desc = "Level 0 main with doors",
    danger = 1,
    on_generate = nil,
    segheight = 20,
    prevalence = 1,
    schems = {
        {name=sch("0_20_1_columns_0"), vertical_segments={1,0}},
        --
        {name=sch("0_20_2_columns_0"), vertical_segments={0,1}, rotation=0, prevalence=12},
        {name=sch("0_20_2_walls_0"), vertical_segments={0,1}, prevalence=12},
        {name=sch("0_20_2_walls_1"), vertical_segments={0,1}, prevalence=12},
        {name=sch("0_20_2_walls_2"), vertical_segments={0,1}, prevalence=12},
        {name=sch("0_20_2_walls_3"), vertical_segments={0,1}, prevalence=12},
        {name=sch("0_20_2_doors_0"), vertical_segments={0,1}, prevalence=2},
        {name=sch("0_20_2_doors_1"), vertical_segments={0,1}, prevalence=2},
        {name=sch("0_20_2_doors_0_portal"), vertical_segments={0,1}, prevalence=2},
        {name=sch("0_20_2_doors_1_portal"), vertical_segments={0,1}, prevalence=2},
        {name=sch("0_20_2_stairs_0_portal"), vertical_segments={0,1}, prevalence=1},
    }
})
br_core.register_biome({
    level = level,
    desc = "Level 0 concrete",
    danger = 1,
    on_generate = nil,
    segheight = 20,
    prevalence = 1,
    can_generate = function(pos) -- must be deterministic
        if vector.distance(pos, vector.new(0, pos.y, 0)) > 30 then
            return true
        else
            return false
        end
    end,
    schems = {
        {name=sch("0_20_1_columns_0"), vertical_segments={1,0}},
        --
        {name=sch("0_20_2_walls_concrete_0"), vertical_segments={0,1}, prevalence=9},
        {name=sch("0_20_2_walls_concrete_1"), vertical_segments={0,1}, prevalence=5},
        {name=sch("0_20_2_walls_concrete_1_portal"), vertical_segments={0,1}, prevalence=1},
    }
})
br_core.register_biome({
    level = level,
    desc = "Level 0 nolight",
    danger = 1,
    on_generate = nil,
    segheight = 20,
    prevalence = 2,
    schems = {
        {name=sch("0_20_1_columns_0"), vertical_segments={1,0}},
        --
        {name=sch("0_20_2_nolight_portal_0"), vertical_segments={0,1}, prevalence=1},
        {name=sch("0_20_2_nolight_walls_0"), vertical_segments={0,1}, prevalence=3},
        {name=sch("0_20_2_nolight_walls_1"), vertical_segments={0,1}, prevalence=3},
        {name=sch("0_20_2_nolight_walls_2"), vertical_segments={0,1}, prevalence=3},
        {name=sch("0_20_2_nolight_columns_0"), vertical_segments={0,1}, prevalence=2},
    }
})
br_core.register_biome({
    level = level,
    desc = "Level 0 dark",
    danger = 1,
    on_generate = nil,
    segheight = 20,
    prevalence = 1,
    can_generate = function(pos) -- must be deterministic
        if vector.distance(pos, vector.new(0, pos.y, 0)) > 30 then
            return true
        else
            return false
        end
    end,
    schems = {
        {name=sch("0_20_1_columns_0"), vertical_segments={1,0}},
        --
        {name=sch("0_20_2_dark_0"), vertical_segments={0,1}, prevalence=8},
        {name=sch("0_20_2_dark_walls_0"), vertical_segments={0,1}, prevalence=8},
        {name=sch("0_20_2_dark_walls_1"), vertical_segments={0,1}, prevalence=8},
        --
        {name=sch("0_20_2_dark_walls_2"), vertical_segments={0,1}, prevalence=4},
        {name=sch("0_20_2_dark_walls_2_portal"), vertical_segments={0,1}},
    }
})

br_core.register_level_sound({
    level = level,
    time = 5,
    on_play = function(self, dtime, player)
        local pos = player:get_pos()
        if pos.y < -5 then return end
        if pos.y > 0 then return end
        local light = (core.get_node_light(pos) or 0)
        if light < 4 then return end
        pos.y = 0
        local light_nodes = core.find_nodes_in_area(
            vector.offset(pos, -6, 0, -6),
            vector.offset(pos,  6, 0,  6),
            {"group:light_on"}, false
        )
        if #light_nodes < 1 then return end
        local can_play = false
        local playing = br_core.sound_get_tag("level0_hum", player)
        if playing == nil or #playing < 1
        or (playing and playing[1].fading and #playing <= 1) then can_play = true end
        if can_play then
            br_core.sound_play("level0_hum", player, {
                name = "br_fluorescent_hum",
                level = 0,
                gain = (br_sounds.master or 1) * (0.02 * math.random() + 0.005),
                fade = 0.02,
                to_player = player:get_player_name(),
                time = 8,
            })
        end
        -- shhhhhhh don't tell anyone
        local dist = vector.distance(pos, vector.new(3000,pos.y,0)) / 5000
        if 0.2 - (dist) > 0 then
            can_play = false
            local playing2 = br_core.sound_get_tag("level0_beep", player)
            if (playing2 == nil or #playing2 < 1)
            or (playing2 and (playing2[1].time <= 2) and #playing2 == 1) then can_play = true end
            if can_play then
                br_core.sound_play("level0_beep", player, {
                    name = "br_level_0_beep",
                    level = level,
                    gain = (br_sounds.master or 1) * math.max(0.2 - (dist), 0),
                    to_player = player:get_player_name(),
                    time = 18,
                })
            end
        end
    end
})

-- junk and occasional supplies
br_core.set_loot_table(level, 0, {
    node_names = {"br_core:loot_crate"},
    max_items = 4,
    items = {
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
        br_core.loot.list.food(32),
        br_core.loot.list.food(32),
        br_core.loot.list.drinks(32),
        br_core.loot.list.drinks(32),
        {items = {"br_core:key_2 1"}, rarity = 22},
        {items = {"br_core:key_3 1"}, rarity = 22},
    },
})
-- food
br_core.set_loot_table(level, 1, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.food(23),
        br_core.loot.list.food(23),
        br_core.loot.list.food(23),
    },
})
-- drinks
br_core.set_loot_table(level, 2, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.drinks(8),
        br_core.loot.list.drinks(8),
        br_core.loot.list.drinks(8),
    },
})
-- tools and supplies
br_core.set_loot_table(level, 3, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.tools(3),
        br_core.loot.list.junk(3),
        br_core.loot.list.junk(3),
        {items = {"br_core:key_2 1"}, rarity = 22},
        {items = {"br_core:key_3 1"}, rarity = 22},
    },
})
-- jackpot
br_core.set_loot_table(level, 4, {
    node_names = {"br_core:loot_crate"},
    max_items = 16,
    items = {
        br_core.loot.list.food(6),
        br_core.loot.list.food(6),
        br_core.loot.list.drinks(6),
        br_core.loot.list.drinks(6),
        br_core.loot.list.tools(4),
        {items = {"br_core:key_2 1"}, rarity = 12},
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
    },
})
-- keys
br_core.set_loot_table(level, 8, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        {items = {"br_core:key_2 1"}, rarity = 8},
        {items = {"br_core:key_3 1"}, rarity = 14},
        br_core.loot.list.junk(8),
        br_core.loot.list.junk(8),
        br_core.loot.list.tools(8),
    },
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_0",
    node_name = "br_core:loot_crate_0",
    rarity = 70,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_1",
    node_name = "br_core:loot_crate_1",
    rarity = 66,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_2",
    node_name = "br_core:loot_crate_2",
    rarity = 54,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_3",
    node_name = "br_core:loot_crate_3",
    rarity = 54,
})
