local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local function sch(name)
    return (mod_path .. "/schematics/" .. name .. ".mts")
end

local level = 1

br_core.register_level({
    level = level,
    desc = "Level 1",
    danger = 1,
    grace_dist = 5,
    biome = {},
    segsize = 20,
    base_height = 20,
    sun = {
        visible = false,
        texture = "blank.png",
        sunrise_visible = false,
    },
    moon = {
        visible = false,
    },
    sky = {
        clouds = false,
        base_color = "#001",
        type = "plain",
        fog = {
            fog_start = -1,
            fog_distance = -1,
        },
    },
})

br_core.register_biome({
    level = level,
    desc = "Level 1 columns",
    danger = 1,
    on_generate = nil,
    can_generate = function(pos) -- must be deterministic
        if vector.distance(pos, vector.new(0, pos.y, 0)) > 10 then
            return false
        else
            return true
        end
    end,
    schems = {
        {name=sch("1_open_0"), no_rotation=true},
    }
})
br_core.register_biome({
    level = level,
    desc = "Level 1 main",
    danger = 1,
    on_generate = nil,
    prevalence = 2,
    schems = {
        {name=sch("1_open_0"), no_rotation=true},
        {name=sch("1_open_1"), no_rotation=true},
        {name=sch("1_open_0"), no_rotation=true},
        {name=sch("1_open_1"), no_rotation=true},
        {name=sch("1_open_0"), no_rotation=true},
        {name=sch("1_open_2")},
        {name=sch("1_open_2")},
        {name=sch("1_building_0")}, --PORTAL
        {name=sch("1_building_1")},
        {name=sch("1_building_2")},
        {name=sch("1_stairs_0")},
        {name=sch("1_ramp_0")},
    }
})
br_core.register_biome({
    level = level,
    desc = "Level 1 main",
    danger = 1,
    on_generate = nil,
    prevalence = 1,
    schems = {
        {name=sch("1_stairs_0")},
        {name=sch("1_building_0")}, --PORTAL
        {name=sch("1_building_1")},
        {name=sch("1_building_2")},
        {name=sch("1_building_2")},
        {name=sch("1_building_2")},
        {name=sch("1_open_0"), no_rotation=true},
    }
})

br_core.register_level_sound({
    level = level,
    time = 8,
    scare_timer = {},
    on_play = function(self, dtime, player)
        if self.scare_timer[player] == nil then self.scare_timer[player] = math.random(60, 80) end
        local can_play = false
        local playing = br_core.sound_get_tag("level1_hum", player)
        if playing == nil or #playing < 1
        or (playing and playing[1].fading and #playing <= 1) then can_play = true end
        if can_play then
            br_core.sound_play("level1_traffic", player, {
                name = "br_traffic_distant_cc0_klangfabrik",
                level = level,
                gain = (br_sounds.master or 1) * (0.1 * math.random() + 0.01),
                fade = 0.02,
                to_player = player:get_player_name(),
                time = 8,
            })
            br_core.sound_play("level1_hum", player, {
                name = "br_fluorescent_hum",
                level = level,
                gain = (br_sounds.master or 1) * (0.002 * math.random() + 0.001),
                fade = 0.01,
                to_player = player:get_player_name(),
                time = 8,
            })
        end

        self.scare_timer[player] = self.scare_timer[player] - dtime
        playing = br_core.sound_get_tag("level1_footsteps", player)
        if (self.scare_timer[player] < 0) and (playing == nil or #playing < 1) then
            self.scare_timer[player] = math.random(60, 240)
            br_core.achievements.achieve(player, "whatwasthat1", 5)
            local yaw = player:get_look_horizontal() + ((math.random(-1,1)) * 1.5) + 3.14
            local dir = vector.multiply(minetest.yaw_to_dir(yaw), 20)
            local pos = vector.add(player:get_pos(), dir)
            if not minetest.line_of_sight(pos, player:get_pos()) then
                br_core.sound_play("level1_footsteps", player, {
                    name = "br_m_trigger_footsteps_concrete",
                    level = level,
                    gain = (br_sounds.master or 1) * 1,
                    max_hear_distance = 100,
                    to_player = player:get_player_name(),
                    time = 6,
                    pos = pos
                })
            else
                self.scare_timer[player] = 2
            end
        end
    end
})

-- junk and occasional supplies
br_core.set_loot_table(level, 0, {
    node_names = {"br_core:loot_crate"},
    max_items = 4,
    items = {
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
        br_core.loot.list.food(32),
        br_core.loot.list.food(32),
        br_core.loot.list.drinks(32),
        br_core.loot.list.drinks(32),
        {items = {"br_core:key_2 1"}, rarity = 22},
        {items = {"br_core:key_3 1"}, rarity = 22},
    },
})
-- food
br_core.set_loot_table(level, 1, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.food(23),
        br_core.loot.list.food(23),
        br_core.loot.list.food(23),
    },
})
-- drinks
br_core.set_loot_table(level, 2, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.drinks(16),
        br_core.loot.list.drinks(16),
        br_core.loot.list.drinks(16),
    },
})
-- tools and supplies
br_core.set_loot_table(level, 3, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.tools(3),
        br_core.loot.list.junk(3),
        br_core.loot.list.junk(3),
        {items = {"br_core:key_2 1"}, rarity = 22},
        {items = {"br_core:key_3 1"}, rarity = 22},
    },
})
-- jackpot
br_core.set_loot_table(level, 4, {
    node_names = {"br_core:loot_crate"},
    max_items = 16,
    items = {
        br_core.loot.list.food(12),
        br_core.loot.list.food(12),
        br_core.loot.list.drinks(12),
        br_core.loot.list.drinks(12),
        br_core.loot.list.tools(4),
        {items = {"br_core:key_2 1"}, rarity = 8},
        {items = {"br_core:key_3 1"}, rarity = 14},
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
    },
})
-- keys
br_core.set_loot_table(level, 8, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        {items = {"br_core:key_2 1"}, rarity = 8},
        br_core.loot.list.junk(8),
        br_core.loot.list.junk(8),
        br_core.loot.list.tools(8),
    },
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_0",
    node_name = "br_core:loot_crate_0",
    rarity = 70,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_1",
    node_name = "br_core:loot_crate_1",
    rarity = 66,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_2",
    node_name = "br_core:loot_crate_2",
    rarity = 54,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_3",
    node_name = "br_core:loot_crate_3",
    rarity = 54,
})
