local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local function sch(name)
    return (mod_path .. "/schematics/" .. name .. ".mts")
end

-- hub
br_core.register_level({
    level = 12,
    desc = "Level 12 hub",
    danger = 0,
    grace_dist = 5,
    biome = {},
    segsize = 40,
    base_height = 23,
    survival_stats = false,
    sun = {
        visible = true,
        texture = "blank.png",
        sunrise_visible = false,
    },
    moon = {
        visible = false,
    },
    sky = {
        clouds = false,
        base_color = "#001",
        type = "plain",
        fog = {
            fog_start = -1,
            fog_distance = -1,
        },
    },
})

local l12pattern = {
    1,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0
}
br_core.register_biome({
    level = 12,
    desc = "Level 12 tunnel",
    danger = 0,
    on_generate = nil,
    can_generate = function(pos)
        return ((pos.z % 3 == 0) and l12pattern[pos.x%30+1] <= 1)
    end,
    schems = {
        {name=sch("12_tunnel_portal_0"), rotation=1, prevalence=4},
        {name=sch("12_tunnel_random_0"), rotation=1, prevalence=3},
        {name=sch("12_tunnel_0"), rotation=1, prevalence=10},
        {name=sch("12_tunnel_1"), rotation=1, prevalence=3},
    }
})
br_core.register_biome({
    level = 12,
    desc = "Level 12 block",
    danger = 0,
    on_generate = nil,
    can_generate = function(pos)
        return ((pos.z % 3 ~= 0) and l12pattern[pos.x%30+1] == 0)
    end,
    schems = {
        {name=sch("12_block_0")},
    }
})
br_core.register_biome({
    level = 12,
    desc = "Level 12 empty",
    danger = 0,
    on_generate = nil,
    can_generate = function(pos)
        return ((pos.z % 3 ~= 0) and l12pattern[pos.x%30+1] == 1)
    end,
    schems = {
        {name=sch("12_block_1")},
    }
})
br_core.register_biome({
    level = 12,
    desc = "Level 12 bridge",
    danger = 0,
    on_generate = nil,
    can_generate = function(pos)
        return ((pos.z % 3 == 0) and l12pattern[pos.x%30+1] == 2)
    end,
    schems = {
        {name=sch("12_bridge_0"), rotation=1},
    }
})
br_core.register_biome({
    level = 12,
    desc = "Level 12 water",
    danger = 3,
    on_generate = nil,
    can_generate = function(pos)
        return ((pos.z % 3 ~= 0) and l12pattern[pos.x%30+1] == 2)
    end,
    schems = {
        {name=sch("12_water_0"), rotation=1},
    }
})
br_core.register_on_level_enter(function(player, from_level, to_level)
    if to_level == 12 then
        player:override_day_night_ratio(0.2)
    end
end)
br_core.register_on_level_exit(function(player, from_level, to_level)
    if from_level == 12 then
        player:override_day_night_ratio()
    end
end)
