local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local function sch(name)
    return (mod_path .. "/schematics/" .. name .. ".mts")
end

-- pipes
br_core.register_level({
    level = 2,
    desc = "Level 2",
    danger = 3,
    grace_dist = 5,
    biome = {},
    segsize = 20,
    base_height = 20,
    survival_stats = false,
    sun = {
        visible = false,
        texture = "blank.png",
        sunrise_visible = false,
    },
    moon = {
        visible = false,
    },
    sky = {
        clouds = false,
        base_color = "#001",
        type = "plain",
        fog = {
            fog_start = -1,
            fog_distance = -1,
        },
    },
})

br_core.register_biome({
    level = 2,
    desc = "Level 2 corridors",
    danger = 3,
    on_generate = nil,
    can_generate = function(pos) -- must be deterministic
        if vector.distance(pos, vector.new(0, pos.y, 0)) > 10 then
            return false
        else
            return true
        end
    end,
    schems = {
        {name=sch("2_crossroad_0"), no_rotation=true},
    }
})

br_core.register_biome({
    level = 2,
    desc = "Level 0 main",
    danger = 1,
    on_generate = nil,
    biome_roughness = 1,
    biome_pixelization = 2,
    prevalence = 1,
    schems = {
        {name=sch("2_maze_0"), rotation=0, prevalence=9},
        {name=sch("2_crossroad_0"), rotation=0, prevalence=2},
        {name=sch("2_open_0")},
        {name=sch("2_water_0")},
    }
})

br_core.register_biome({
    level = 2,
    desc = "Level 0 main",
    danger = 1,
    on_generate = nil,
    prevalence = 1,
    schems = {
        {name=sch("2_blue_1"), rotation=0, prevalence=5},
        {name=sch("2_blue_1"), rotation=1, prevalence=1},
        {name=sch("2_blue_1_portal"), no_rotation=true},
        {name=sch("2_blue_0"), rotation=0, prevalence=4},
        {name=sch("2_blue_0_portal")},
    }
})

br_core.register_biome({
    level = 2,
    desc = "Level 0 main",
    danger = 1,
    on_generate = nil,
    prevalence = 1,
    schems = {
        {name=sch("2_green_0"), rotation=0, prevalence=4},
        {name=sch("2_green_1_portal")},
        {name=sch("2_green_1"), rotation=0, prevalence=4},
        {name=sch("2_green_2"), rotation=0, prevalence=4},
        {name=sch("2_green_0_nolight")},
        {name=sch("2_green_1_nolight")},
    }
})

br_core.register_level_sound({
    level = 2,
    time = 8,
    scare_timer = {},
    on_play = function(self, dtime, player)
        if self.scare_timer[player] == nil then self.scare_timer[player] = math.random(120, 200) end
        local can_play = false
        local playing = br_core.sound_get_tag("level2_hum", player)
        if playing == nil or #playing < 1
        or (playing and playing[1].fading and #playing <= 1) then can_play = true end
        if can_play then
            br_core.sound_play("level2_hum", player, {
                name = "br_fluorescent_hum",
                level = 2,
                gain = (br_sounds.master or 1) * (0.003 * math.random() + 0.001),
                fade = 0.01,
                to_player = player:get_player_name(),
                time = 8,
            })
            br_core.sound_play("2_dripsandwater", player, {
                name = "br_dripsandwater_WTFPL_Sumianvoice",
                level = 2,
                gain = (br_sounds.master or 1) * (math.random()*0.3),
                fade = 0.2,
                max_hear_distance = 50,
                to_player = player:get_player_name(),
                time = 40,
            })
        end

        self.scare_timer[player] = self.scare_timer[player] - dtime
        playing = br_core.sound_get_tag("level2_footsteps", player)
        if (self.scare_timer[player] < 0) and (playing == nil or #playing < 1) then
            self.scare_timer[player] = math.random(60, 240)
            local yaw = player:get_look_horizontal() + ((math.random(-1,1)) * 1.5) + 3.14
            local dir = vector.multiply(minetest.yaw_to_dir(yaw), 20)
            local pos = vector.add(player:get_pos(), dir)
            br_core.sound_play("level2_footsteps", player, {
                name = "br_m_trigger_footsteps_concrete",
                level = 1,
                gain = (br_sounds.master or 1) * 1,
                max_hear_distance = 100,
                to_player = player:get_player_name(),
                time = 6,
                pos = pos
            })
        end
    end
})
