local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local function sch(name)
    return (mod_path .. "/schematics/" .. name .. ".mts")
end

-- doors
br_core.register_level({
    level = 45,
    desc = "Level 45",
    secret = true,
    danger = 0,
    grace_dist = 5,
    biome = {},
    segsize = 20,
    base_height = 41,
    survival_stats = false,
    sun = {
        texture = "blank.png",
        sunrise_visible = false,
    },
    moon = {
        visible = false,
    },
    sky = {
		base_color = "#ffffff",
		type = "regular",
        clouds = false,
		sky_color = {
			day_sky = "#92b9f2" ,
			day_horizon = "#010c22",
			dawn_sky = "#92b9f2" ,
			dawn_horizon = "#010c22",
			night_sky = "#006bff" ,
			night_horizon = "#010c22",
			indoors = "#010c22",
			fog_sun_tint = "#010c22",
			fog_moon_tint = "#010c22",
			fog_tint_type = "custom",
		},
        fog = {
            fog_start = -1,
            fog_distance = -1,
        },
	},
})

br_core.register_biome({
    level = 45,
    desc = "Level 45 doors",
    danger = 0,
    on_generate = nil,
    can_generate = function(pos) -- must be deterministic
        if vector.distance(pos, vector.new(0, pos.y, 0)) > 10 then
            return false
        else
            return true
        end
    end,
    schems = {
        {name=sch("45_doors_0"), no_rotation=true},
        {name=sch("45_sparse_0"), no_rotation=true},
        {name=sch("45_sparse_0"), no_rotation=true},
    }
})

br_core.register_biome({
    level = 45,
    desc = "Level 45 doors with portal",
    danger = 0,
    on_generate = nil,
    prevalence = 1,
    schems = {
        {name=sch("45_sparse_0"), no_rotation=true},
        {name=sch("45_sparse_0"), no_rotation=true},
        {name=sch("45_sparse_0"), no_rotation=true},
        {name=sch("45_sparse_0_portal"), no_rotation=true},
        {name=sch("45_doors_0"), no_rotation=true},
        {name=sch("45_doors_0"), no_rotation=true},
        {name=sch("45_doors_0"), no_rotation=true},
    }
})

br_core.register_level_sound({
    level = 45,
    time = 7,
    on_play = function(self, dtime, player)
        local can_play = false
        local playing = br_core.sound_get_tag("level45_wind", player)
        if playing == nil or #playing < 1
        or (playing and playing[1].fading and #playing <= 1) then can_play = true end
        if can_play then
            br_core.sound_play("level45_wind", player, {
                name = "br_wind_noise_WTFPL_Sumianvoice",
                level = 45,
                gain = (br_sounds.master or 1) * (0.2 * math.random() + 0.1),
                fade = 0.15,
                to_player = player:get_player_name(),
                time = 7,
            })
        end
    end
})
